/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.notebook.converter;

import java.util.Map;
import org.scijava.convert.ConvertService;
import org.scijava.convert.Converter;
import org.scijava.notebook.converter.HTMLNotebookOutputConverter;
import org.scijava.notebook.converter.HTMLTableBuilder;
import org.scijava.notebook.converter.output.HTMLTableNotebookOutput;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;

@Plugin(type=Converter.class)
public class MapToHTMLTableNotebookConverter<K, V>
extends HTMLNotebookOutputConverter<Map<K, V>, HTMLTableNotebookOutput> {
    @Parameter
    private ConvertService convertService;

    @Override
    public Class<Map<K, V>> getInputType() {
        return Map.class;
    }

    @Override
    public Class<HTMLTableNotebookOutput> getOutputType() {
        return HTMLTableNotebookOutput.class;
    }

    @Override
    public HTMLTableNotebookOutput convert(Object object) {
        Map table = (Map)object;
        String htmlTable = HTMLTableBuilder.startTable();
        htmlTable = htmlTable + HTMLTableBuilder.appendHeadings("Key", false);
        htmlTable = htmlTable + HTMLTableBuilder.appendHeadings("Value", true);
        for (Object key : table.keySet()) {
            String k = this.asHTML(key);
            String v = this.asHTML(table.get(key));
            htmlTable = htmlTable + HTMLTableBuilder.appendData(k, true, false);
            htmlTable = htmlTable + HTMLTableBuilder.appendData(v, false, true);
        }
        htmlTable = htmlTable + HTMLTableBuilder.endTable();
        return new HTMLTableNotebookOutput(HTMLTableBuilder.getTableStyle(false) + htmlTable);
    }
}

