/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.notebook.converter;

import net.imagej.table.Column;
import net.imagej.table.Table;
import org.scijava.convert.Converter;
import org.scijava.notebook.converter.HTMLNotebookOutputConverter;
import org.scijava.notebook.converter.HTMLTableBuilder;
import org.scijava.notebook.converter.output.HTMLTableNotebookOutput;
import org.scijava.plugin.Plugin;

@Plugin(type=Converter.class)
public class TableToHTMLNotebookConverter<C extends Column<? extends T>, T>
extends HTMLNotebookOutputConverter<Table<C, T>, HTMLTableNotebookOutput> {
    @Override
    public Class<Table<C, T>> getInputType() {
        return Table.class;
    }

    @Override
    public Class<HTMLTableNotebookOutput> getOutputType() {
        return HTMLTableNotebookOutput.class;
    }

    @Override
    public HTMLTableNotebookOutput convert(Object object) {
        int i;
        Table table = (Table)object;
        boolean rowLabels = false;
        String htmlTable = HTMLTableBuilder.startTable();
        htmlTable = htmlTable + HTMLTableBuilder.appendRowLabelHeading();
        for (i = 0; i < table.getColumnCount(); ++i) {
            htmlTable = htmlTable + HTMLTableBuilder.appendHeadings(this.asHTML(table.getColumnHeader(i)), i == table.getColumnCount() - 1);
        }
        for (i = 0; i < table.getRowCount(); ++i) {
            if (table.getRowHeader(i) != null) {
                rowLabels = true;
            }
            htmlTable = htmlTable + HTMLTableBuilder.appendRowLabelData(table.getRowHeader(i));
            for (int j = 0; j < table.getColumnCount(); ++j) {
                htmlTable = htmlTable + HTMLTableBuilder.appendData(this.asHTML(table.get(j, i)), false, j == table.getColumnCount());
            }
        }
        htmlTable = htmlTable + HTMLTableBuilder.endTable();
        return new HTMLTableNotebookOutput(HTMLTableBuilder.getTableStyle(rowLabels) + htmlTable);
    }
}

