/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.samples.color;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.color.ColorSpace;
import java.awt.color.ICC_ColorSpace;
import java.awt.color.ICC_Profile;
import java.io.IOException;
import java.util.LinkedList;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jhotdraw.color.CIELABColorSpace;
import org.jhotdraw.color.CMYKGenericColorSpace;
import org.jhotdraw.color.CMYKNominalColorSpace;
import org.jhotdraw.color.ColorSliderModel;
import org.jhotdraw.color.ColorUtil;
import org.jhotdraw.color.DefaultColorSliderModel;
import org.jhotdraw.color.HSBColorSpace;
import org.jhotdraw.color.HSLColorSpace;
import org.jhotdraw.color.HSLPhysiologicColorSpace;
import org.jhotdraw.color.HSVColorSpace;
import org.jhotdraw.color.HSVPhysiologicColorSpace;
import org.jhotdraw.color.JColorWheel;

public class WheelsAndSlidersMain
extends JPanel {
    private Color color;
    private JLabel colorLabel;
    private LinkedList<ColorSliderModel> models;
    private Handler handler;
    private JPanel chooserPanel;
    private JLabel previewLabel;

    public WheelsAndSlidersMain() {
        this.initComponents();
        this.models = new LinkedList();
        this.handler = new Handler();
        this.previewLabel.setOpaque(true);
        this.chooserPanel.add(this.createColorWheelChooser(HSBColorSpace.getInstance()));
        this.chooserPanel.add(this.createColorWheelChooser(HSVColorSpace.getInstance(), 1, 0, 2, JColorWheel.Type.SQUARE, false, false));
        this.chooserPanel.add(this.createColorWheelChooser(HSLColorSpace.getInstance()));
        this.chooserPanel.add(this.createColorWheelChooser(HSLColorSpace.getInstance(), 0, 2, 1));
        CIELABColorSpace cielab = new CIELABColorSpace();
        cielab.setOutsideGamutHandling(CIELABColorSpace.OutsideGamutHandling.LEAVE_OUTSIDE);
        this.chooserPanel.add(this.createColorWheelChooser(cielab, 1, 2, 0, JColorWheel.Type.COMPLEX));
        this.chooserPanel.add(this.createColorWheelChooser(HSVPhysiologicColorSpace.getInstance()));
        this.chooserPanel.add(this.createColorWheelChooser(HSLPhysiologicColorSpace.getInstance()));
        this.chooserPanel.add(this.createColorWheelChooser(HSLPhysiologicColorSpace.getInstance(), 0, 2, 1));
        this.chooserPanel.add(this.createColorWheelChooser(ICC_ColorSpace.getInstance(1004), 0, 1, 2, JColorWheel.Type.SQUARE));
        this.chooserPanel.add(this.createColorWheelChooser(ICC_ColorSpace.getInstance(1001), 1, 0, 2, JColorWheel.Type.SQUARE));
        this.chooserPanel.add(this.createColorWheelChooser(ICC_ColorSpace.getInstance(1002), 1, 2, 0, JColorWheel.Type.SQUARE));
        this.chooserPanel.add(new JPanel());
        this.chooserPanel.add(this.createColorWheelChooser(ICC_ColorSpace.getInstance(1000), 0, 1, 2, JColorWheel.Type.SQUARE));
        try {
            this.chooserPanel.add(this.createColorWheelChooser(new ICC_ColorSpace(ICC_Profile.getInstance(WheelsAndSlidersMain.class.getResourceAsStream("/org/jhotdraw/color/Munsell CIELab_to_UPLab.icc"))), 2, 1, 0, JColorWheel.Type.SQUARE));
            this.chooserPanel.add(this.createColorWheelChooser(new ICC_ColorSpace(ICC_Profile.getInstance(WheelsAndSlidersMain.class.getResourceAsStream("/org/jhotdraw/color/Munsell CIELab_to_UPLab2.icc"))), 2, 1, 0, JColorWheel.Type.SQUARE));
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        this.chooserPanel.add(this.createSliderChooser(ColorSpace.getInstance(1000)));
        this.chooserPanel.add(this.createSliderChooser(CMYKGenericColorSpace.getInstance()));
        this.chooserPanel.add(this.createSliderChooser(CMYKNominalColorSpace.getInstance()));
    }

    private JPanel createColorWheelChooser(ColorSpace sys) {
        return this.createColorWheelChooser(sys, 0, 1, 2);
    }

    private JPanel createColorWheelChooser(ColorSpace sys, int angularIndex, int radialIndex, int verticalIndex) {
        return this.createColorWheelChooser(sys, angularIndex, radialIndex, verticalIndex, JColorWheel.Type.POLAR);
    }

    private JPanel createColorWheelChooser(ColorSpace sys, int angularIndex, int radialIndex, int verticalIndex, JColorWheel.Type type) {
        return this.createColorWheelChooser(sys, angularIndex, radialIndex, verticalIndex, type, false, false);
    }

    private JPanel createColorWheelChooser(ColorSpace sys, int angularIndex, int radialIndex, int verticalIndex, JColorWheel.Type type, boolean flipX, boolean flipY) {
        JPanel p = new JPanel(new BorderLayout());
        DefaultColorSliderModel m = new DefaultColorSliderModel(sys);
        this.models.add(m);
        m.addChangeListener(this.handler);
        JColorWheel w = new JColorWheel();
        w.setType(type);
        w.setAngularComponentIndex(angularIndex);
        w.setRadialComponentIndex(radialIndex);
        w.setVerticalComponentIndex(verticalIndex);
        w.setFlipX(flipX);
        w.setFlipY(flipY);
        w.setModel(m);
        JSlider s = new JSlider(1);
        m.configureSlider(verticalIndex, s);
        p.add((Component)new JLabel("<html>" + ColorUtil.getName(sys) + "<br>\u03b1:" + angularIndex + " r:" + radialIndex + " v:" + verticalIndex), "North");
        p.add((Component)w, "Center");
        p.add((Component)s, "East");
        return p;
    }

    private JPanel createSliderChooser(ColorSpace sys) {
        return this.createSliderChooser(sys, false);
    }

    private JPanel createSliderChooser(ColorSpace sys, boolean vertical) {
        JPanel p = new JPanel(new GridLayout(vertical ? 1 : 0, vertical ? 0 : 1));
        DefaultColorSliderModel m = new DefaultColorSliderModel(sys);
        this.models.add(m);
        if (!vertical) {
            p.add((Component)new JLabel("<html>" + ColorUtil.getName(sys)), "North");
        }
        m.addChangeListener(this.handler);
        for (int i = 0; i < m.getComponentCount(); ++i) {
            JSlider s = new JSlider(0);
            s.setMajorTickSpacing(50);
            s.setPaintTicks(true);
            s.setOrientation(vertical ? 1 : 0);
            m.configureSlider(i, s);
            p.add(s);
        }
        return p;
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JFrame f = new JFrame("Color Wheels, Squares and Sliders");
                f.add(new WheelsAndSlidersMain());
                f.setDefaultCloseOperation(3);
                f.pack();
                f.setVisible(true);
            }
        });
    }

    private void initComponents() {
        this.chooserPanel = new JPanel();
        this.previewLabel = new JLabel();
        this.setLayout(new BorderLayout());
        this.chooserPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.chooserPanel.setLayout(new GridLayout(0, 4, 10, 10));
        this.add((Component)this.chooserPanel, "Center");
        this.previewLabel.setText("Selected Color");
        this.add((Component)this.previewLabel, "South");
    }

    private class Handler
    implements ChangeListener {
        private int adjusting;

        private Handler() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            if (this.adjusting++ == 0) {
                ColorSliderModel m = (ColorSliderModel)e.getSource();
                WheelsAndSlidersMain.this.color = m.getColor();
                WheelsAndSlidersMain.this.previewLabel.setBackground(WheelsAndSlidersMain.this.color);
                for (ColorSliderModel c : WheelsAndSlidersMain.this.models) {
                    if (c == m) continue;
                    if (c.getColorSpace().equals(m.getColorSpace())) {
                        for (int i = 0; i < m.getComponentCount(); ++i) {
                            c.setComponent(i, m.getComponent(i));
                        }
                        continue;
                    }
                    c.setColor(WheelsAndSlidersMain.this.color);
                }
            }
            --this.adjusting;
        }
    }
}

