/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw.tool;

import java.awt.Graphics2D;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.util.HashSet;
import org.jhotdraw.draw.Drawing;
import org.jhotdraw.draw.DrawingEditor;
import org.jhotdraw.draw.DrawingView;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.event.ToolAdapter;
import org.jhotdraw.draw.event.ToolEvent;
import org.jhotdraw.draw.handle.Handle;
import org.jhotdraw.draw.tool.AbstractTool;
import org.jhotdraw.draw.tool.DefaultDragTracker;
import org.jhotdraw.draw.tool.DefaultHandleTracker;
import org.jhotdraw.draw.tool.DefaultSelectAreaTracker;
import org.jhotdraw.draw.tool.DragTracker;
import org.jhotdraw.draw.tool.HandleTracker;
import org.jhotdraw.draw.tool.SelectAreaTracker;
import org.jhotdraw.draw.tool.Tool;

public class SelectionTool
extends AbstractTool {
    private Tool tracker = this.getSelectAreaTracker();
    private HandleTracker handleTracker;
    private SelectAreaTracker selectAreaTracker;
    private DragTracker dragTracker;
    private TrackerHandler trackerHandler = new TrackerHandler();
    public static final String SELECT_BEHIND_ENABLED_PROPERTY = "selectBehindEnabled";
    private boolean isSelectBehindEnabled = true;

    public SelectionTool() {
        this.tracker.addToolListener(this.trackerHandler);
    }

    public void setSelectBehindEnabled(boolean newValue) {
        boolean oldValue = this.isSelectBehindEnabled;
        this.isSelectBehindEnabled = newValue;
        this.firePropertyChange(SELECT_BEHIND_ENABLED_PROPERTY, oldValue, newValue);
    }

    public boolean isSelectBehindEnabled() {
        return this.isSelectBehindEnabled;
    }

    @Override
    public void activate(DrawingEditor editor) {
        super.activate(editor);
        this.tracker.activate(editor);
    }

    @Override
    public void deactivate(DrawingEditor editor) {
        super.deactivate(editor);
        this.tracker.deactivate(editor);
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (this.getView() != null && this.getView().isEnabled()) {
            this.tracker.keyPressed(e);
        }
    }

    @Override
    public void keyReleased(KeyEvent evt) {
        if (this.getView() != null && this.getView().isEnabled()) {
            this.tracker.keyReleased(evt);
        }
    }

    @Override
    public void keyTyped(KeyEvent evt) {
        if (this.getView() != null && this.getView().isEnabled()) {
            this.tracker.keyTyped(evt);
        }
    }

    @Override
    public void mouseClicked(MouseEvent evt) {
        if (this.getView() != null && this.getView().isEnabled()) {
            this.tracker.mouseClicked(evt);
        }
    }

    @Override
    public void mouseDragged(MouseEvent evt) {
        if (this.getView() != null && this.getView().isEnabled()) {
            this.tracker.mouseDragged(evt);
        }
    }

    @Override
    public void mouseEntered(MouseEvent evt) {
        super.mouseEntered(evt);
        this.tracker.mouseEntered(evt);
    }

    @Override
    public void mouseExited(MouseEvent evt) {
        super.mouseExited(evt);
        this.tracker.mouseExited(evt);
    }

    @Override
    public void mouseMoved(MouseEvent evt) {
        this.tracker.mouseMoved(evt);
    }

    @Override
    public void mouseReleased(MouseEvent evt) {
        if (this.getView() != null && this.getView().isEnabled()) {
            this.tracker.mouseReleased(evt);
        }
    }

    @Override
    public void draw(Graphics2D g) {
        this.tracker.draw(g);
    }

    @Override
    public void mousePressed(MouseEvent evt) {
        if (this.getView() != null && this.getView().isEnabled()) {
            super.mousePressed(evt);
            DrawingView view = this.getView();
            Handle handle = view.findHandle(this.anchor);
            Tool newTracker = null;
            if (handle != null) {
                newTracker = this.getHandleTracker(handle);
            } else {
                Figure figure;
                Drawing drawing = view.getDrawing();
                Point2D.Double p = view.viewToDrawing(this.anchor);
                if (this.isSelectBehindEnabled() && (evt.getModifiersEx() & 0x280) != 0) {
                    figure = view.findFigure(this.anchor);
                    while (figure != null && !figure.isSelectable()) {
                        figure = drawing.findFigureBehind(p, figure);
                    }
                    HashSet<Figure> ignoredFigures = new HashSet<Figure>(view.getSelectedFigures());
                    ignoredFigures.add(figure);
                    Figure figureBehind = view.getDrawing().findFigureBehind(view.viewToDrawing(this.anchor), ignoredFigures);
                    if (figureBehind != null) {
                        figure = figureBehind;
                    }
                } else {
                    figure = null;
                    if (this.isSelectBehindEnabled()) {
                        for (Figure f : view.getSelectedFigures()) {
                            if (!f.contains(p)) continue;
                            figure = f;
                            break;
                        }
                    }
                    if (figure == null) {
                        figure = view.findFigure(this.anchor);
                        while (figure != null && !figure.isSelectable()) {
                            figure = drawing.findFigureBehind(p, figure);
                        }
                    }
                }
                if (figure != null && figure.isSelectable()) {
                    newTracker = this.getDragTracker(figure);
                } else {
                    if (!evt.isShiftDown()) {
                        view.clearSelection();
                        view.setHandleDetailLevel(0);
                    }
                    newTracker = this.getSelectAreaTracker();
                }
            }
            if (newTracker != null) {
                this.setTracker(newTracker);
            }
            this.tracker.mousePressed(evt);
        }
    }

    protected void setTracker(Tool newTracker) {
        if (this.tracker != null) {
            this.tracker.deactivate(this.getEditor());
            this.tracker.removeToolListener(this.trackerHandler);
        }
        this.tracker = newTracker;
        if (this.tracker != null) {
            this.tracker.activate(this.getEditor());
            this.tracker.addToolListener(this.trackerHandler);
        }
    }

    protected HandleTracker getHandleTracker(Handle handle) {
        if (this.handleTracker == null) {
            this.handleTracker = new DefaultHandleTracker();
        }
        this.handleTracker.setHandles(handle, this.getView().getCompatibleHandles(handle));
        return this.handleTracker;
    }

    protected DragTracker getDragTracker(Figure f) {
        if (this.dragTracker == null) {
            this.dragTracker = new DefaultDragTracker();
        }
        this.dragTracker.setDraggedFigure(f);
        return this.dragTracker;
    }

    protected SelectAreaTracker getSelectAreaTracker() {
        if (this.selectAreaTracker == null) {
            this.selectAreaTracker = new DefaultSelectAreaTracker();
        }
        return this.selectAreaTracker;
    }

    public void setHandleTracker(HandleTracker newValue) {
        this.handleTracker = newValue;
    }

    public void setSelectAreaTracker(SelectAreaTracker newValue) {
        this.selectAreaTracker = newValue;
    }

    public void setDragTracker(DragTracker newValue) {
        this.dragTracker = newValue;
    }

    @Override
    public boolean supportsHandleInteraction() {
        return true;
    }

    private class TrackerHandler
    extends ToolAdapter {
        private TrackerHandler() {
        }

        @Override
        public void toolDone(ToolEvent event) {
            SelectAreaTracker newTracker = SelectionTool.this.getSelectAreaTracker();
            if (newTracker != null) {
                if (SelectionTool.this.tracker != null) {
                    SelectionTool.this.tracker.deactivate(SelectionTool.this.getEditor());
                    SelectionTool.this.tracker.removeToolListener(this);
                }
                SelectionTool.this.tracker = newTracker;
                SelectionTool.this.tracker.activate(SelectionTool.this.getEditor());
                SelectionTool.this.tracker.addToolListener(this);
            }
            SelectionTool.this.fireToolDone();
        }

        @Override
        public void areaInvalidated(ToolEvent e) {
            SelectionTool.this.fireAreaInvalidated(e.getInvalidatedArea());
        }

        @Override
        public void boundsInvalidated(ToolEvent e) {
            SelectionTool.this.fireBoundsInvalidated(e.getInvalidatedArea());
        }
    }
}

