/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.plugins.tools;

import org.scijava.command.CommandService;
import org.scijava.display.event.input.KyPressedEvent;
import org.scijava.input.Accelerator;
import org.scijava.input.InputModifiers;
import org.scijava.input.KeyCode;
import org.scijava.module.ModuleInfo;
import org.scijava.module.ModuleService;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.scijava.tool.AbstractTool;
import org.scijava.tool.Tool;

@Plugin(type=Tool.class, name="Keyboard Shortcuts", priority=-10000.0)
public class AcceleratorHandler
extends AbstractTool {
    @Parameter
    private ModuleService moduleService;
    @Parameter
    private CommandService commandService;

    public boolean isAlwaysActive() {
        return true;
    }

    public boolean isActiveInAppFrame() {
        return true;
    }

    public void onKeyDown(KyPressedEvent evt) {
        InputModifiers modifiers;
        KeyCode keyCode;
        Accelerator modAcc;
        Accelerator acc = evt.getAccelerator();
        if (acc.getKeyCode() == KeyCode.UNDEFINED) {
            return;
        }
        ModuleInfo moduleInfo = null;
        moduleInfo = this.moduleService.getModuleForAccelerator(acc);
        boolean addModifierAutomatically = true;
        if (moduleInfo == null && !acc.equals((Object)(modAcc = new Accelerator(keyCode = acc.getKeyCode(), modifiers = this.forceDefaultModifier(acc.getModifiers()))))) {
            moduleInfo = this.moduleService.getModuleForAccelerator(modAcc);
        }
        if (moduleInfo == null) {
            return;
        }
        this.moduleService.run(moduleInfo, true, new Object[0]);
        evt.consume();
    }

    private InputModifiers forceDefaultModifier(InputModifiers modifiers) {
        boolean forceMeta = Accelerator.isCtrlReplacedWithMeta();
        boolean forceCtrl = !forceMeta;
        boolean alt = modifiers.isAltDown();
        boolean altGr = modifiers.isAltGrDown();
        boolean ctrl = forceCtrl || modifiers.isCtrlDown();
        boolean meta = forceMeta || modifiers.isMetaDown();
        boolean shift = modifiers.isShiftDown();
        return new InputModifiers(alt, altGr, ctrl, meta, shift, false, false, false);
    }
}

