/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.plugins.platforms.macos;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import org.scijava.command.CommandInfo;
import org.scijava.command.CommandService;
import org.scijava.display.event.window.WinActivatedEvent;
import org.scijava.event.EventHandler;
import org.scijava.event.EventService;
import org.scijava.event.EventSubscriber;
import org.scijava.event.SciJavaEvent;
import org.scijava.module.event.ModulesUpdatedEvent;
import org.scijava.platform.AbstractPlatform;
import org.scijava.platform.Platform;
import org.scijava.platform.PlatformService;
import org.scijava.plugin.Plugin;
import org.scijava.plugins.platforms.macos.MacOSAppEventDispatcher;

@Plugin(type=Platform.class, name="macOS")
public class MacOSPlatform
extends AbstractPlatform {
    private static final boolean SCREEN_MENU = true;
    private Object appEventDispatcher;
    private JMenuBar menuBar;
    private List<EventSubscriber<?>> subscribers;

    public String osName() {
        return "macOS";
    }

    public void configure(PlatformService service) {
        super.configure(service);
        System.setProperty("apple.laf.useScreenMenuBar", "true");
        this.removeAppCommandsFromMenu();
        EventService eventService = this.getPlatformService().eventService();
        try {
            this.appEventDispatcher = new MacOSAppEventDispatcher(eventService);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
        this.subscribers = eventService.subscribe((Object)this);
    }

    public void open(URL url) throws IOException {
        if (this.getPlatformService().exec(new String[]{"open", url.toString()}) != 0) {
            throw new IOException("Could not open " + url);
        }
    }

    public boolean registerAppMenus(Object menus) {
        if (menus instanceof JMenuBar) {
            this.menuBar = (JMenuBar)menus;
        }
        return false;
    }

    public void dispose() {
        this.getPlatformService().getEventService().unsubscribe(this.subscribers);
    }

    @EventHandler
    protected void onEvent(WinActivatedEvent evt) {
        if (!this.isTarget()) {
            return;
        }
        Object window = evt.getWindow();
        if (!(window instanceof JFrame)) {
            return;
        }
        ((JFrame)window).setJMenuBar(this.menuBar);
    }

    private void removeAppCommandsFromMenu() {
        PlatformService platformService = this.getPlatformService();
        EventService eventService = platformService.getEventService();
        CommandService commandService = platformService.getCommandService();
        ArrayList<CommandInfo> infos = new ArrayList<CommandInfo>();
        for (CommandInfo info : commandService.getCommands()) {
            if (!info.is("app-command")) continue;
            info.setMenuPath(null);
            infos.add(info);
        }
        eventService.publish((SciJavaEvent)new ModulesUpdatedEvent(infos));
    }
}

