/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.app;

import net.imagej.app.ImageJApp;
import org.scijava.app.App;
import org.scijava.log.LogService;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.scijava.service.Service;

@Plugin(type=App.class, name="ImageJ", priority=101.0)
public class ToplevelImageJApp
extends ImageJApp {
    @Parameter(required=false)
    private LogService log;

    @Override
    public String getArtifactId() {
        return "imagej";
    }

    public String getVersion() {
        String version = super.getVersion();
        String legacyVersion = this.getLegacyVersion();
        return version + (legacyVersion == null ? "" : "/" + legacyVersion);
    }

    private String getLegacyVersion() {
        try {
            Class<?> c = Class.forName("net.imagej.legacy.LegacyService");
            if (!Service.class.isAssignableFrom(c)) {
                return null;
            }
            Class<?> sc = c;
            Service legacyService = this.getContext().getService(sc);
            if (legacyService == null) {
                return null;
            }
            return legacyService.getVersion();
        }
        catch (ClassNotFoundException exc) {
            if (this.log != null) {
                this.log.debug((Throwable)exc);
            }
            return null;
        }
    }
}

