/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.view.iteration;

import java.util.Arrays;
import java.util.Iterator;
import net.imglib2.AbstractWrappedInterval;
import net.imglib2.Cursor;
import net.imglib2.FlatIterationOrder;
import net.imglib2.Interval;
import net.imglib2.IterableInterval;
import net.imglib2.RandomAccessible;
import net.imglib2.transform.integer.BoundingBox;
import net.imglib2.transform.integer.SlicingTransform;
import net.imglib2.util.Intervals;
import net.imglib2.view.IterableRandomAccessibleInterval;
import net.imglib2.view.TransformBuilder;
import net.imglib2.view.Views;
import net.imglib2.view.iteration.SlicingCursor;
import net.imglib2.view.iteration.SubIntervalIterable;

public class IterableTransformBuilder<T>
extends TransformBuilder<T> {
    protected Interval interval;

    public static <S> IterableInterval<S> getEfficientIterableInterval(Interval interval, RandomAccessible<S> randomAccessible) {
        return new IterableTransformBuilder<S>(interval, randomAccessible).buildIterableInterval();
    }

    public IterableTransformBuilder(Interval interval, RandomAccessible<T> randomAccessible) {
        super(interval, randomAccessible);
        this.interval = interval;
    }

    public IterableInterval<T> buildIterableInterval() {
        if (this.boundingBox != null && SubIntervalIterable.class.isInstance(this.source)) {
            SubIntervalIterable iterableSource = (SubIntervalIterable)((Object)this.source);
            if (this.transforms.isEmpty()) {
                if (iterableSource.supportsOptimizedCursor(this.interval)) {
                    return new SubInterval(iterableSource);
                }
            } else if (this.transforms.size() == 1 && SlicingTransform.class.isInstance(this.transforms.get(0))) {
                Interval sliceInterval;
                SlicingTransform t = (SlicingTransform)this.transforms.get(0);
                int m = t.numTargetDimensions();
                int n = t.numSourceDimensions();
                boolean optimizable = true;
                for (int firstZeroDim = 0; firstZeroDim < m && !t.getComponentZero(firstZeroDim); ++firstZeroDim) {
                }
                for (int d = firstZeroDim + 1; d < m && optimizable; ++d) {
                    if (t.getComponentZero(d)) continue;
                    optimizable = false;
                }
                int[] sourceComponent = new int[n];
                if (optimizable) {
                    int d;
                    Arrays.fill(sourceComponent, -1);
                    for (d = 0; d < m; ++d) {
                        if (t.getComponentZero(d)) continue;
                        sourceComponent[t.getComponentMapping((int)d)] = d;
                    }
                    for (d = 0; d < n && optimizable; ++d) {
                        if (sourceComponent[d] >= 0) continue;
                        optimizable = false;
                    }
                }
                if (optimizable && iterableSource.supportsOptimizedCursor(sliceInterval = t.transform(new BoundingBox(this.interval)).getInterval())) {
                    boolean flat = FlatIterationOrder.class.isInstance(iterableSource.subIntervalIterationOrder(sliceInterval));
                    for (int d = 0; d < n - 1; ++d) {
                        if (sourceComponent[d + 1] > sourceComponent[d]) continue;
                        flat = false;
                    }
                    return new Slice(iterableSource, sliceInterval, t, flat);
                }
            }
        }
        return new IterableRandomAccessibleInterval(Views.interval(this.build(), this.interval));
    }

    private class Slice
    extends AbstractWrappedInterval<Interval>
    implements IterableInterval<T> {
        final long numElements;
        final SubIntervalIterable<T> iterableSource;
        final Interval sourceInterval;
        final SlicingTransform transformToSource;
        final boolean hasFlatIterationOrder;

        public Slice(SubIntervalIterable<T> iterableSource, Interval sourceInterval, SlicingTransform transformToSource, boolean hasFlatIterationOrder) {
            super(IterableTransformBuilder.this.interval);
            this.numElements = Intervals.numElements(IterableTransformBuilder.this.interval);
            this.iterableSource = iterableSource;
            this.sourceInterval = sourceInterval;
            this.transformToSource = transformToSource;
            this.hasFlatIterationOrder = hasFlatIterationOrder;
        }

        @Override
        public long size() {
            return this.numElements;
        }

        @Override
        public T firstElement() {
            return this.cursor().next();
        }

        @Override
        public Object iterationOrder() {
            return this.hasFlatIterationOrder ? new FlatIterationOrder(IterableTransformBuilder.this.interval) : this;
        }

        @Override
        public Iterator<T> iterator() {
            return this.cursor();
        }

        @Override
        public Cursor<T> cursor() {
            return new SlicingCursor(this.iterableSource.cursor(this.sourceInterval), this.transformToSource);
        }

        @Override
        public Cursor<T> localizingCursor() {
            return new SlicingCursor(this.iterableSource.localizingCursor(this.sourceInterval), this.transformToSource);
        }
    }

    private class SubInterval
    extends AbstractWrappedInterval<Interval>
    implements IterableInterval<T> {
        final long numElements;
        final SubIntervalIterable<T> iterableSource;

        public SubInterval(SubIntervalIterable<T> iterableSource) {
            super(IterableTransformBuilder.this.interval);
            this.numElements = Intervals.numElements(IterableTransformBuilder.this.interval);
            this.iterableSource = iterableSource;
        }

        @Override
        public long size() {
            return this.numElements;
        }

        @Override
        public T firstElement() {
            return this.cursor().next();
        }

        @Override
        public Object iterationOrder() {
            return this.iterableSource.subIntervalIterationOrder(IterableTransformBuilder.this.interval);
        }

        @Override
        public Iterator<T> iterator() {
            return this.cursor();
        }

        @Override
        public Cursor<T> cursor() {
            return this.iterableSource.cursor(IterableTransformBuilder.this.interval);
        }

        @Override
        public Cursor<T> localizingCursor() {
            return this.iterableSource.localizingCursor(IterableTransformBuilder.this.interval);
        }
    }
}

