/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.view;

import java.util.Arrays;
import net.imglib2.FinalInterval;
import net.imglib2.Interval;
import net.imglib2.Localizable;
import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessible;

public class HyperSlice<T>
implements RandomAccessible<T> {
    protected final RandomAccessible<T> source;
    protected final int numDimensions;
    protected final int[] axes;
    protected final long[] position;

    private Interval sourceInterval(Interval interval) {
        int d;
        assert (interval.numDimensions() == this.axes.length) : "Interval dimensions do not match Hyperslice dimensions.";
        long[] min = new long[this.numDimensions];
        long[] max = new long[this.numDimensions];
        for (d = 0; d < this.position.length; ++d) {
            min[d] = max[d] = this.position[d];
        }
        for (d = 0; d < interval.numDimensions(); ++d) {
            min[this.axes[d]] = interval.min(d);
            max[this.axes[d]] = interval.max(d);
        }
        return new FinalInterval(min, max);
    }

    public HyperSlice(RandomAccessible<T> source, int[] fixedAxes, long[] position) {
        this.source = source;
        int[] sortedFixedAxes = (int[])fixedAxes.clone();
        Arrays.sort(sortedFixedAxes);
        this.numDimensions = source.numDimensions() - fixedAxes.length;
        this.axes = new int[this.numDimensions];
        this.position = new long[position.length];
        int da = 0;
        int db = 0;
        for (int d = 0; d < source.numDimensions(); ++d) {
            if (da < sortedFixedAxes.length && sortedFixedAxes[da] == d) {
                ++da;
                this.position[d] = position[d];
                continue;
            }
            this.axes[db++] = d;
        }
    }

    @Override
    public int numDimensions() {
        return this.axes.length;
    }

    public HyperSliceRandomAccess randomAccess() {
        return new HyperSliceRandomAccess();
    }

    @Override
    public RandomAccess<T> randomAccess(Interval interval) {
        return new HyperSliceRandomAccess();
    }

    public class HyperSliceRandomAccess
    implements RandomAccess<T> {
        protected final RandomAccess<T> sourceAccess;

        public HyperSliceRandomAccess() {
            this.sourceAccess = HyperSlice.this.source.randomAccess();
            this.sourceAccess.setPosition(HyperSlice.this.position);
        }

        public HyperSliceRandomAccess(Interval interval) {
            this.sourceAccess = HyperSlice.this.source.randomAccess(HyperSlice.this.sourceInterval(interval));
            this.sourceAccess.setPosition(HyperSlice.this.position);
        }

        @Override
        public void localize(int[] position) {
            for (int d = 0; d < HyperSlice.this.numDimensions; ++d) {
                position[d] = this.sourceAccess.getIntPosition(HyperSlice.this.axes[d]);
            }
        }

        @Override
        public void localize(long[] position) {
            for (int d = 0; d < HyperSlice.this.numDimensions; ++d) {
                position[d] = this.sourceAccess.getLongPosition(HyperSlice.this.axes[d]);
            }
        }

        @Override
        public int getIntPosition(int d) {
            return this.sourceAccess.getIntPosition(HyperSlice.this.axes[d]);
        }

        @Override
        public long getLongPosition(int d) {
            return this.sourceAccess.getLongPosition(HyperSlice.this.axes[d]);
        }

        @Override
        public void localize(float[] position) {
            for (int d = 0; d < HyperSlice.this.numDimensions; ++d) {
                position[d] = this.sourceAccess.getFloatPosition(HyperSlice.this.axes[d]);
            }
        }

        @Override
        public void localize(double[] position) {
            for (int d = 0; d < HyperSlice.this.numDimensions; ++d) {
                position[d] = this.sourceAccess.getDoublePosition(HyperSlice.this.axes[d]);
            }
        }

        @Override
        public float getFloatPosition(int d) {
            return this.sourceAccess.getFloatPosition(HyperSlice.this.axes[d]);
        }

        @Override
        public double getDoublePosition(int d) {
            return this.sourceAccess.getDoublePosition(HyperSlice.this.axes[d]);
        }

        @Override
        public int numDimensions() {
            return HyperSlice.this.numDimensions;
        }

        @Override
        public void fwd(int d) {
            this.sourceAccess.fwd(HyperSlice.this.axes[d]);
        }

        @Override
        public void bck(int d) {
            this.sourceAccess.bck(HyperSlice.this.axes[d]);
        }

        @Override
        public void move(int distance, int d) {
            this.sourceAccess.move(distance, HyperSlice.this.axes[d]);
        }

        @Override
        public void move(long distance, int d) {
            this.sourceAccess.move(distance, HyperSlice.this.axes[d]);
        }

        @Override
        public void move(Localizable localizable) {
            for (int d = 0; d < HyperSlice.this.numDimensions; ++d) {
                this.sourceAccess.move(localizable.getLongPosition(d), HyperSlice.this.axes[d]);
            }
        }

        @Override
        public void move(int[] distance) {
            for (int d = 0; d < HyperSlice.this.numDimensions; ++d) {
                this.sourceAccess.move(distance[d], HyperSlice.this.axes[d]);
            }
        }

        @Override
        public void move(long[] distance) {
            for (int d = 0; d < HyperSlice.this.numDimensions; ++d) {
                this.sourceAccess.move(distance[d], HyperSlice.this.axes[d]);
            }
        }

        @Override
        public void setPosition(Localizable localizable) {
            for (int d = 0; d < HyperSlice.this.numDimensions; ++d) {
                this.sourceAccess.setPosition(localizable.getLongPosition(d), HyperSlice.this.axes[d]);
            }
        }

        @Override
        public void setPosition(int[] position) {
            for (int d = 0; d < HyperSlice.this.numDimensions; ++d) {
                this.sourceAccess.setPosition(position[d], HyperSlice.this.axes[d]);
            }
        }

        @Override
        public void setPosition(long[] position) {
            for (int d = 0; d < HyperSlice.this.numDimensions; ++d) {
                this.sourceAccess.setPosition(position[d], HyperSlice.this.axes[d]);
            }
        }

        @Override
        public void setPosition(int position, int d) {
            this.sourceAccess.setPosition(position, HyperSlice.this.axes[d]);
        }

        @Override
        public void setPosition(long position, int d) {
            this.sourceAccess.setPosition(position, HyperSlice.this.axes[d]);
        }

        @Override
        public T get() {
            return this.sourceAccess.get();
        }

        public HyperSliceRandomAccess copy() {
            return new HyperSliceRandomAccess();
        }

        public HyperSliceRandomAccess copyRandomAccess() {
            return this.copy();
        }
    }
}

