/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.view;

import net.imglib2.AbstractEuclideanSpace;
import net.imglib2.Localizable;
import net.imglib2.RandomAccess;
import net.imglib2.transform.integer.Slicing;

public class FullSourceMapSlicingRandomAccess<T>
extends AbstractEuclideanSpace
implements RandomAccess<T> {
    private final RandomAccess<T> s;
    private final int m;
    private final int[] sourceComponent;
    private final long[] tmpPosition;
    private final long[] tmpDistance;

    FullSourceMapSlicingRandomAccess(RandomAccess<T> source, Slicing transformToSource) {
        super(transformToSource.numSourceDimensions());
        assert (source.numDimensions() == transformToSource.numTargetDimensions());
        this.s = source;
        this.m = transformToSource.numTargetDimensions();
        boolean[] targetZero = new boolean[this.m];
        int[] targetComponent = new int[this.m];
        transformToSource.getComponentZero(targetZero);
        transformToSource.getComponentMapping(targetComponent);
        this.sourceComponent = new int[this.n];
        for (int d = 0; d < this.m; ++d) {
            if (transformToSource.getComponentZero(d)) {
                this.s.setPosition(transformToSource.getTranslation(d), d);
                continue;
            }
            this.sourceComponent[transformToSource.getComponentMapping((int)d)] = d;
        }
        this.tmpPosition = new long[this.m];
        transformToSource.getTranslation(this.tmpPosition);
        this.tmpDistance = new long[this.m];
    }

    protected FullSourceMapSlicingRandomAccess(FullSourceMapSlicingRandomAccess<T> randomAccess) {
        super(randomAccess.numDimensions());
        this.s = randomAccess.s.copyRandomAccess();
        this.m = randomAccess.m;
        this.sourceComponent = (int[])randomAccess.sourceComponent.clone();
        this.tmpPosition = (long[])randomAccess.tmpPosition.clone();
        this.tmpDistance = (long[])randomAccess.tmpDistance.clone();
    }

    @Override
    public void localize(int[] position) {
        assert (position.length >= this.n);
        for (int d = 0; d < this.n; ++d) {
            position[d] = this.getIntPosition(d);
        }
    }

    @Override
    public void localize(long[] position) {
        assert (position.length >= this.n);
        for (int d = 0; d < this.n; ++d) {
            position[d] = this.getLongPosition(d);
        }
    }

    @Override
    public int getIntPosition(int d) {
        assert (d < this.n);
        return this.s.getIntPosition(this.sourceComponent[d]);
    }

    @Override
    public long getLongPosition(int d) {
        assert (d < this.n);
        return this.s.getLongPosition(this.sourceComponent[d]);
    }

    @Override
    public void localize(float[] position) {
        assert (position.length >= this.n);
        for (int d = 0; d < this.n; ++d) {
            position[d] = this.getFloatPosition(d);
        }
    }

    @Override
    public void localize(double[] position) {
        assert (position.length >= this.n);
        for (int d = 0; d < this.n; ++d) {
            position[d] = this.getDoublePosition(d);
        }
    }

    @Override
    public float getFloatPosition(int d) {
        assert (d < this.n);
        return this.s.getFloatPosition(this.sourceComponent[d]);
    }

    @Override
    public double getDoublePosition(int d) {
        assert (d < this.n);
        return this.s.getDoublePosition(this.sourceComponent[d]);
    }

    @Override
    public void fwd(int d) {
        this.s.fwd(this.sourceComponent[d]);
    }

    @Override
    public void bck(int d) {
        this.s.bck(this.sourceComponent[d]);
    }

    @Override
    public void move(int distance, int d) {
        assert (d < this.n);
        this.s.move(distance, this.sourceComponent[d]);
    }

    @Override
    public void move(long distance, int d) {
        assert (d < this.n);
        this.s.move(distance, this.sourceComponent[d]);
    }

    @Override
    public void move(Localizable localizable) {
        assert (localizable.numDimensions() >= this.n);
        for (int d = 0; d < this.n; ++d) {
            this.tmpDistance[this.sourceComponent[d]] = localizable.getLongPosition(d);
        }
        this.s.move(this.tmpDistance);
    }

    @Override
    public void move(int[] distance) {
        assert (distance.length >= this.n);
        for (int d = 0; d < this.n; ++d) {
            this.tmpDistance[this.sourceComponent[d]] = distance[d];
        }
        this.s.move(this.tmpDistance);
    }

    @Override
    public void move(long[] distance) {
        assert (distance.length >= this.n);
        for (int d = 0; d < this.n; ++d) {
            this.tmpDistance[this.sourceComponent[d]] = distance[d];
        }
        this.s.move(this.tmpDistance);
    }

    @Override
    public void setPosition(Localizable localizable) {
        assert (localizable.numDimensions() >= this.n);
        for (int d = 0; d < this.n; ++d) {
            this.tmpPosition[this.sourceComponent[d]] = localizable.getLongPosition(d);
        }
        this.s.setPosition(this.tmpPosition);
    }

    @Override
    public void setPosition(int[] position) {
        assert (position.length >= this.n);
        for (int d = 0; d < this.n; ++d) {
            this.tmpPosition[this.sourceComponent[d]] = position[d];
        }
        this.s.setPosition(this.tmpPosition);
    }

    @Override
    public void setPosition(long[] position) {
        assert (position.length >= this.n);
        for (int d = 0; d < this.n; ++d) {
            this.tmpPosition[this.sourceComponent[d]] = position[d];
        }
        this.s.setPosition(this.tmpPosition);
    }

    @Override
    public void setPosition(int position, int d) {
        assert (d < this.n);
        this.s.setPosition(position, this.sourceComponent[d]);
    }

    @Override
    public void setPosition(long position, int d) {
        assert (d < this.n);
        this.s.setPosition(position, this.sourceComponent[d]);
    }

    @Override
    public T get() {
        return this.s.get();
    }

    @Override
    public FullSourceMapSlicingRandomAccess<T> copy() {
        return new FullSourceMapSlicingRandomAccess<T>(this);
    }

    @Override
    public FullSourceMapSlicingRandomAccess<T> copyRandomAccess() {
        return this.copy();
    }
}

