/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.util;

import net.imglib2.Dimensions;
import net.imglib2.FinalDimensions;
import net.imglib2.FinalInterval;
import net.imglib2.FinalRealInterval;
import net.imglib2.Interval;
import net.imglib2.Localizable;
import net.imglib2.RealInterval;
import net.imglib2.RealLocalizable;

public class Intervals {
    public static FinalInterval createMinSize(long ... minsize) {
        return FinalInterval.createMinSize(minsize);
    }

    public static FinalInterval createMinMax(long ... minmax) {
        return FinalInterval.createMinMax(minmax);
    }

    @Deprecated
    public static FinalRealInterval createMinSizeReal(double ... minsize) {
        return FinalRealInterval.createMinSize(minsize);
    }

    public static FinalRealInterval createMinMaxReal(double ... minmax) {
        return FinalRealInterval.createMinMax(minmax);
    }

    public static FinalInterval expand(Interval interval, long border) {
        int n = interval.numDimensions();
        long[] min = new long[n];
        long[] max = new long[n];
        interval.min(min);
        interval.max(max);
        int d = 0;
        while (d < n) {
            int n2 = d;
            min[n2] = min[n2] - border;
            int n3 = d++;
            max[n3] = max[n3] + border;
        }
        return new FinalInterval(min, max);
    }

    public static FinalInterval expand(Interval interval, long ... border) {
        return Intervals.expand(interval, new FinalDimensions(border));
    }

    public static FinalInterval expand(Interval interval, Dimensions border) {
        int n = interval.numDimensions();
        long[] min = new long[n];
        long[] max = new long[n];
        interval.min(min);
        interval.max(max);
        for (int d = 0; d < n; ++d) {
            int n2 = d;
            min[n2] = min[n2] - border.dimension(d);
            int n3 = d;
            max[n3] = max[n3] + border.dimension(d);
        }
        return new FinalInterval(min, max);
    }

    public static FinalInterval expand(Interval interval, long border, int d) {
        int n = interval.numDimensions();
        long[] min = new long[n];
        long[] max = new long[n];
        interval.min(min);
        interval.max(max);
        int n2 = d;
        min[n2] = min[n2] - border;
        int n3 = d;
        max[n3] = max[n3] + border;
        return new FinalInterval(min, max);
    }

    public static FinalInterval translate(Interval interval, long t, int d) {
        int n = interval.numDimensions();
        long[] min = new long[n];
        long[] max = new long[n];
        interval.min(min);
        interval.max(max);
        int n2 = d;
        min[n2] = min[n2] + t;
        int n3 = d;
        max[n3] = max[n3] + t;
        return new FinalInterval(min, max);
    }

    public static FinalInterval intersect(Interval intervalA, Interval intervalB) {
        assert (intervalA.numDimensions() == intervalB.numDimensions());
        int n = intervalA.numDimensions();
        long[] min = new long[n];
        long[] max = new long[n];
        for (int d = 0; d < n; ++d) {
            min[d] = Math.max(intervalA.min(d), intervalB.min(d));
            max[d] = Math.min(intervalA.max(d), intervalB.max(d));
        }
        return new FinalInterval(min, max);
    }

    public static FinalInterval union(Interval intervalA, Interval intervalB) {
        assert (intervalA.numDimensions() == intervalB.numDimensions());
        int n = intervalA.numDimensions();
        long[] min = new long[n];
        long[] max = new long[n];
        for (int d = 0; d < n; ++d) {
            min[d] = Math.min(intervalA.min(d), intervalB.min(d));
            max[d] = Math.max(intervalA.max(d), intervalB.max(d));
        }
        return new FinalInterval(min, max);
    }

    public static Interval smallestContainingInterval(RealInterval ri) {
        int n = ri.numDimensions();
        long[] min = new long[n];
        long[] max = new long[n];
        for (int d = 0; d < n; ++d) {
            min[d] = (long)Math.floor(ri.realMin(d));
            max[d] = (long)Math.ceil(ri.realMax(d));
        }
        return new FinalInterval(min, max);
    }

    public static Interval largestContainedInterval(RealInterval ri) {
        int n = ri.numDimensions();
        long[] min = new long[n];
        long[] max = new long[n];
        for (int d = 0; d < n; ++d) {
            min[d] = (long)Math.ceil(ri.realMin(d));
            max[d] = (long)Math.floor(ri.realMax(d));
        }
        return new FinalInterval(min, max);
    }

    public static boolean isEmpty(Interval interval) {
        int n = interval.numDimensions();
        for (int d = 0; d < n; ++d) {
            if (interval.min(d) <= interval.max(d)) continue;
            return true;
        }
        return false;
    }

    public static boolean contains(Interval containing, Localizable contained) {
        assert (containing.numDimensions() == contained.numDimensions());
        int n = containing.numDimensions();
        for (int d = 0; d < n; ++d) {
            long p = contained.getLongPosition(d);
            if (p >= containing.min(d) && p <= containing.max(d)) continue;
            return false;
        }
        return true;
    }

    public static boolean contains(RealInterval containing, RealLocalizable contained) {
        assert (containing.numDimensions() == contained.numDimensions());
        int n = containing.numDimensions();
        for (int d = 0; d < n; ++d) {
            double p = contained.getDoublePosition(d);
            if (!(p < containing.realMin(d)) && !(p > containing.realMax(d))) continue;
            return false;
        }
        return true;
    }

    public static final boolean contains(Interval containing, Interval contained) {
        assert (containing.numDimensions() == contained.numDimensions());
        int n = containing.numDimensions();
        for (int d = 0; d < n; ++d) {
            if (containing.min(d) <= contained.min(d) && containing.max(d) >= contained.max(d)) continue;
            return false;
        }
        return true;
    }

    public static final boolean contains(RealInterval containing, RealInterval contained) {
        assert (containing.numDimensions() == contained.numDimensions());
        int n = containing.numDimensions();
        for (int d = 0; d < n; ++d) {
            if (!(containing.realMin(d) > contained.realMin(d)) && !(containing.realMax(d) < contained.realMax(d))) continue;
            return false;
        }
        return true;
    }

    public static long numElements(Dimensions interval) {
        long numPixels = interval.dimension(0);
        int n = interval.numDimensions();
        for (int d = 1; d < n; ++d) {
            numPixels *= interval.dimension(d);
        }
        return numPixels;
    }

    public static long numElements(int ... dimensions) {
        long numPixels = dimensions[0];
        for (int d = 1; d < dimensions.length; ++d) {
            numPixels *= (long)dimensions[d];
        }
        return numPixels;
    }

    public static long numElements(long ... dimensions) {
        long numPixels = dimensions[0];
        for (int d = 1; d < dimensions.length; ++d) {
            numPixels *= dimensions[d];
        }
        return numPixels;
    }

    public static boolean equals(Interval a, Interval b) {
        if (a.numDimensions() != b.numDimensions()) {
            return false;
        }
        for (int d = 0; d < a.numDimensions(); ++d) {
            if (a.min(d) == b.min(d) && a.max(d) == b.max(d)) continue;
            return false;
        }
        return true;
    }

    public static boolean equalDimensions(Interval a, Interval b) {
        if (a.numDimensions() != b.numDimensions()) {
            return false;
        }
        for (int d = 0; d < a.numDimensions(); ++d) {
            if (a.dimension(d) == b.dimension(d)) continue;
            return false;
        }
        return true;
    }

    public static long[] dimensionsAsLongArray(Dimensions dimensions) {
        long[] dims = new long[dimensions.numDimensions()];
        dimensions.dimensions(dims);
        return dims;
    }

    public static int[] dimensionsAsIntArray(Dimensions dimensions) {
        int n = dimensions.numDimensions();
        int[] dims = new int[n];
        for (int d = 0; d < n; ++d) {
            dims[d] = (int)dimensions.dimension(d);
        }
        return dims;
    }

    public static long[] minAsLongArray(Interval interval) {
        long[] min = new long[interval.numDimensions()];
        interval.min(min);
        return min;
    }

    public static int[] minAsIntArray(Interval interval) {
        int n = interval.numDimensions();
        int[] min = new int[n];
        for (int d = 0; d < n; ++d) {
            min[d] = (int)interval.min(d);
        }
        return min;
    }

    public static long[] maxAsLongArray(Interval interval) {
        long[] max = new long[interval.numDimensions()];
        interval.max(max);
        return max;
    }

    public static int[] maxAsIntArray(Interval interval) {
        int n = interval.numDimensions();
        int[] max = new int[n];
        for (int d = 0; d < n; ++d) {
            max[d] = (int)interval.max(d);
        }
        return max;
    }

    public static double[] maxAsDoubleArray(RealInterval interval) {
        double[] max = new double[interval.numDimensions()];
        interval.realMax(max);
        return max;
    }

    public static double[] minAsDoubleArray(RealInterval interval) {
        double[] min = new double[interval.numDimensions()];
        interval.realMin(min);
        return min;
    }
}

