/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.type.numeric.integer;

import net.imglib2.img.NativeImg;
import net.imglib2.img.NativeImgFactory;
import net.imglib2.img.basictypeaccess.LongAccess;
import net.imglib2.img.basictypeaccess.array.LongArray;
import net.imglib2.type.numeric.integer.AbstractIntegerBitType;
import net.imglib2.util.Fraction;

public class Unsigned4BitType
extends AbstractIntegerBitType<Unsigned4BitType> {
    private static final long mask = 15L;

    public Unsigned4BitType(NativeImg<?, ? extends LongAccess> bitStorage) {
        super(bitStorage, 4);
    }

    public Unsigned4BitType(long value) {
        this((NativeImg)null);
        this.dataAccess = new LongArray(1);
        this.set(value);
    }

    public Unsigned4BitType(LongAccess access) {
        this((NativeImg)null);
        this.dataAccess = access;
    }

    public Unsigned4BitType() {
        this(0L);
    }

    @Override
    public NativeImg<Unsigned4BitType, ? extends LongAccess> createSuitableNativeImg(NativeImgFactory<Unsigned4BitType> storageFactory, long[] dim) {
        NativeImg<Unsigned4BitType, LongAccess> container = storageFactory.createLongInstance(dim, new Fraction(this.getBitsPerPixel(), 64L));
        Unsigned4BitType linkedType = new Unsigned4BitType(container);
        container.setLinkedType(linkedType);
        return container;
    }

    @Override
    public Unsigned4BitType duplicateTypeOnSameNativeImg() {
        return new Unsigned4BitType(this.img);
    }

    @Override
    public long get() {
        return this.dataAccess.getValue((int)(this.i >>> 4)) >>> (int)((this.i & 0xFL) << 2) & 0xFL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void set(long value) {
        int i1 = (int)(this.i >>> 4);
        long shift = this.i << 2 & 0x3FL;
        long bitsToRetain = 15L << (int)shift ^ 0xFFFFFFFFFFFFFFFFL;
        long bitsToSet = (value & 0xFL) << (int)shift;
        LongAccess longAccess = this.dataAccess;
        synchronized (longAccess) {
            this.dataAccess.setValue(i1, this.dataAccess.getValue(i1) & bitsToRetain | bitsToSet);
        }
    }

    @Override
    public Unsigned4BitType createVariable() {
        return new Unsigned4BitType(0L);
    }

    @Override
    public Unsigned4BitType copy() {
        return new Unsigned4BitType(this.get());
    }
}

