/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.img.cell;

import net.imglib2.AbstractLocalizable;
import net.imglib2.Localizable;
import net.imglib2.RandomAccess;
import net.imglib2.img.cell.AbstractCellImg;
import net.imglib2.img.cell.Cell;
import net.imglib2.img.cell.CellGrid;
import net.imglib2.type.NativeType;

public class CellRandomAccess<T extends NativeType<T>, C extends Cell<?>>
extends AbstractLocalizable
implements RandomAccess<T>,
AbstractCellImg.CellImgSampler<C> {
    protected final T type;
    protected final CellGrid grid;
    protected final RandomAccess<C> randomAccessOnCells;
    protected final int[] cellDims;
    protected final long[] dimensions;
    protected int[] currentCellSteps;
    protected long[] currentCellMin;
    protected long[] currentCellMax;
    protected boolean isOutOfBounds;
    protected final long[] oobCellMin;
    protected final long[] oobCellMax;
    protected int index;

    protected CellRandomAccess(CellRandomAccess<T, C> randomAccess) {
        super(randomAccess.numDimensions());
        this.type = randomAccess.type.duplicateTypeOnSameNativeImg();
        this.grid = randomAccess.grid;
        this.randomAccessOnCells = randomAccess.randomAccessOnCells.copyRandomAccess();
        randomAccess.localize(this.position);
        this.cellDims = randomAccess.cellDims;
        this.dimensions = randomAccess.dimensions;
        this.currentCellSteps = randomAccess.currentCellSteps;
        this.currentCellMin = randomAccess.currentCellMin;
        this.currentCellMax = randomAccess.currentCellMax;
        this.isOutOfBounds = randomAccess.isOutOfBounds;
        this.oobCellMin = randomAccess.oobCellMin;
        this.oobCellMax = randomAccess.oobCellMax;
        this.index = randomAccess.index;
        this.type.updateContainer(this);
        this.type.updateIndex(this.index);
    }

    public CellRandomAccess(AbstractCellImg<T, ?, C, ?> img) {
        super(img.numDimensions());
        this.type = img.createLinkedType();
        this.grid = img.getCellGrid();
        this.randomAccessOnCells = img.getCells().randomAccess();
        this.cellDims = new int[this.n];
        this.dimensions = new long[this.n];
        img.getCellGrid().cellDimensions(this.cellDims);
        img.getCellGrid().imgDimensions(this.dimensions);
        this.isOutOfBounds = false;
        this.oobCellMin = new long[this.n];
        this.oobCellMax = new long[this.n];
        for (int d = 0; d < this.n; ++d) {
            this.oobCellMin[d] = Long.MAX_VALUE;
            this.oobCellMax[d] = Long.MIN_VALUE;
        }
        img.getCellGrid().getCellPosition(this.position, this.randomAccessOnCells);
        this.updatePosition(false);
    }

    @Override
    public C getCell() {
        return (C)((Cell)this.randomAccessOnCells.get());
    }

    @Override
    public T get() {
        return this.type;
    }

    public CellRandomAccess<T, C> copy() {
        return new CellRandomAccess<T, C>(this);
    }

    public CellRandomAccess<T, C> copyRandomAccess() {
        return this.copy();
    }

    @Override
    public void fwd(int d) {
        this.index += this.currentCellSteps[d];
        int n = d;
        this.position[n] = this.position[n] + 1L;
        if (this.position[n] > this.currentCellMax[d]) {
            this.randomAccessOnCells.fwd(d);
            this.updatePosition(this.position[d] >= this.dimensions[d]);
        }
        this.type.updateIndex(this.index);
    }

    @Override
    public void bck(int d) {
        this.index -= this.currentCellSteps[d];
        int n = d;
        this.position[n] = this.position[n] - 1L;
        if (this.position[n] < this.currentCellMin[d]) {
            this.randomAccessOnCells.bck(d);
            this.updatePosition(this.position[d] < 0L);
        }
        this.type.updateIndex(this.index);
    }

    @Override
    public void move(int distance, int d) {
        this.index += distance * this.currentCellSteps[d];
        int n = d;
        this.position[n] = this.position[n] + (long)distance;
        if (this.position[d] < this.currentCellMin[d] || this.position[d] > this.currentCellMax[d]) {
            this.randomAccessOnCells.setPosition(this.position[d] / (long)this.cellDims[d], d);
            this.updatePosition(this.position[d] < 0L || this.position[d] >= this.dimensions[d]);
        }
        this.type.updateIndex(this.index);
    }

    @Override
    public void move(long distance, int d) {
        this.index += (int)distance * this.currentCellSteps[d];
        int n = d;
        this.position[n] = this.position[n] + distance;
        if (this.position[d] < this.currentCellMin[d] || this.position[d] > this.currentCellMax[d]) {
            this.randomAccessOnCells.setPosition(this.position[d] / (long)this.cellDims[d], d);
            this.updatePosition(this.position[d] < 0L || this.position[d] >= this.dimensions[d]);
        }
        this.type.updateIndex(this.index);
    }

    @Override
    public void move(Localizable localizable) {
        for (int d = 0; d < this.n; ++d) {
            long pos = localizable.getLongPosition(d);
            if (pos == 0L) continue;
            this.index += (int)pos * this.currentCellSteps[d];
            int n = d;
            this.position[n] = this.position[n] + pos;
            if (this.position[d] >= this.currentCellMin[d] && this.position[d] <= this.currentCellMax[d]) continue;
            this.randomAccessOnCells.setPosition(this.position[d] / (long)this.cellDims[d], d);
            boolean movedOutOfBounds = this.position[d] < 0L || this.position[d] >= this.dimensions[d];
            ++d;
            while (d < this.n) {
                long pos2 = localizable.getLongPosition(d);
                if (pos2 != 0L) {
                    int n2 = d;
                    this.position[n2] = this.position[n2] + pos2;
                    if (this.position[d] < this.currentCellMin[d] || this.position[d] > this.currentCellMax[d]) {
                        this.randomAccessOnCells.setPosition(this.position[d] / (long)this.cellDims[d], d);
                        movedOutOfBounds |= this.position[d] < 0L || this.position[d] >= this.dimensions[d];
                    }
                }
                ++d;
            }
            this.updatePosition(movedOutOfBounds);
        }
        this.type.updateIndex(this.index);
    }

    @Override
    public void move(int[] distance) {
        for (int d = 0; d < this.n; ++d) {
            if (distance[d] == 0) continue;
            this.index += distance[d] * this.currentCellSteps[d];
            int n = d;
            this.position[n] = this.position[n] + (long)distance[d];
            if (this.position[d] >= this.currentCellMin[d] && this.position[d] <= this.currentCellMax[d]) continue;
            this.randomAccessOnCells.setPosition(this.position[d] / (long)this.cellDims[d], d);
            boolean movedOutOfBounds = this.position[d] < 0L || this.position[d] >= this.dimensions[d];
            ++d;
            while (d < this.n) {
                if (distance[d] != 0) {
                    int n2 = d;
                    this.position[n2] = this.position[n2] + (long)distance[d];
                    if (this.position[d] < this.currentCellMin[d] || this.position[d] > this.currentCellMax[d]) {
                        this.randomAccessOnCells.setPosition(this.position[d] / (long)this.cellDims[d], d);
                        movedOutOfBounds |= this.position[d] < 0L || this.position[d] >= this.dimensions[d];
                    }
                }
                ++d;
            }
            this.updatePosition(movedOutOfBounds);
        }
        this.type.updateIndex(this.index);
    }

    @Override
    public void move(long[] distance) {
        for (int d = 0; d < this.n; ++d) {
            if (distance[d] == 0L) continue;
            this.index += (int)distance[d] * this.currentCellSteps[d];
            int n = d;
            this.position[n] = this.position[n] + distance[d];
            if (this.position[d] >= this.currentCellMin[d] && this.position[d] <= this.currentCellMax[d]) continue;
            this.randomAccessOnCells.setPosition(this.position[d] / (long)this.cellDims[d], d);
            boolean movedOutOfBounds = this.position[d] < 0L || this.position[d] >= this.dimensions[d];
            ++d;
            while (d < this.n) {
                if (distance[d] != 0L) {
                    int n2 = d;
                    this.position[n2] = this.position[n2] + distance[d];
                    if (this.position[d] < this.currentCellMin[d] || this.position[d] > this.currentCellMax[d]) {
                        this.randomAccessOnCells.setPosition(this.position[d] / (long)this.cellDims[d], d);
                        movedOutOfBounds |= this.position[d] < 0L || this.position[d] >= this.dimensions[d];
                    }
                }
                ++d;
            }
            this.updatePosition(movedOutOfBounds);
        }
        this.type.updateIndex(this.index);
    }

    @Override
    public void setPosition(int pos, int d) {
        this.index += (int)((long)pos - this.position[d]) * this.currentCellSteps[d];
        this.position[d] = pos;
        if ((long)pos < this.currentCellMin[d] || (long)pos > this.currentCellMax[d]) {
            this.randomAccessOnCells.setPosition(pos / this.cellDims[d], d);
            this.updatePosition(this.position[d] < 0L || this.position[d] >= this.dimensions[d]);
        }
        this.type.updateIndex(this.index);
    }

    @Override
    public void setPosition(long pos, int d) {
        this.index += (int)(pos - this.position[d]) * this.currentCellSteps[d];
        this.position[d] = pos;
        if (pos < this.currentCellMin[d] || pos > this.currentCellMax[d]) {
            this.randomAccessOnCells.setPosition(pos / (long)this.cellDims[d], d);
            this.updatePosition(this.position[d] < 0L || this.position[d] >= this.dimensions[d]);
        }
        this.type.updateIndex(this.index);
    }

    @Override
    public void setPosition(Localizable localizable) {
        for (int d = 0; d < this.n; ++d) {
            long pos = localizable.getLongPosition(d);
            if (pos == this.position[d]) continue;
            this.index += (int)(pos - this.position[d]) * this.currentCellSteps[d];
            this.position[d] = pos;
            if (this.position[d] >= this.currentCellMin[d] && this.position[d] <= this.currentCellMax[d]) continue;
            this.randomAccessOnCells.setPosition(this.position[d] / (long)this.cellDims[d], d);
            boolean movedOutOfBounds = this.position[d] < 0L || this.position[d] >= this.dimensions[d];
            ++d;
            while (d < this.n) {
                long posInner = localizable.getLongPosition(d);
                if (posInner != this.position[d]) {
                    this.position[d] = posInner;
                    if (this.position[d] < this.currentCellMin[d] || this.position[d] > this.currentCellMax[d]) {
                        this.randomAccessOnCells.setPosition(this.position[d] / (long)this.cellDims[d], d);
                        movedOutOfBounds |= this.position[d] < 0L || this.position[d] >= this.dimensions[d];
                    }
                }
                ++d;
            }
            this.updatePosition(movedOutOfBounds);
        }
        this.type.updateIndex(this.index);
    }

    @Override
    public void setPosition(int[] pos) {
        for (int d = 0; d < this.n; ++d) {
            if ((long)pos[d] == this.position[d]) continue;
            this.index += (int)((long)pos[d] - this.position[d]) * this.currentCellSteps[d];
            if ((long)pos[d] < this.currentCellMin[d] || (long)pos[d] > this.currentCellMax[d]) {
                this.setPos2(pos, d);
                break;
            }
            this.position[d] = pos[d];
        }
        this.type.updateIndex(this.index);
    }

    private void setPos2(int[] pos, int d0) {
        boolean movedOutOfBounds = false;
        for (int d = d0; d < this.n; ++d) {
            if ((long)pos[d] == this.position[d]) continue;
            this.position[d] = pos[d];
            if ((long)pos[d] >= this.currentCellMin[d] && (long)pos[d] <= this.currentCellMax[d]) continue;
            this.randomAccessOnCells.setPosition(pos[d] / this.cellDims[d], d);
            movedOutOfBounds |= pos[d] < 0 || (long)pos[d] >= this.dimensions[d];
        }
        this.updatePosition(movedOutOfBounds);
    }

    @Override
    public void setPosition(long[] pos) {
        for (int d = 0; d < this.n; ++d) {
            if (pos[d] == this.position[d]) continue;
            this.index += (int)(pos[d] - this.position[d]) * this.currentCellSteps[d];
            this.position[d] = pos[d];
            if (this.position[d] >= this.currentCellMin[d] && this.position[d] <= this.currentCellMax[d]) continue;
            this.randomAccessOnCells.setPosition(this.position[d] / (long)this.cellDims[d], d);
            boolean movedOutOfBounds = this.position[d] < 0L || this.position[d] >= this.dimensions[d];
            ++d;
            while (d < this.n) {
                if (pos[d] != this.position[d]) {
                    this.position[d] = pos[d];
                    if (this.position[d] < this.currentCellMin[d] || this.position[d] > this.currentCellMax[d]) {
                        this.randomAccessOnCells.setPosition(this.position[d] / (long)this.cellDims[d], d);
                        movedOutOfBounds |= this.position[d] < 0L || this.position[d] >= this.dimensions[d];
                    }
                }
                ++d;
            }
            this.updatePosition(movedOutOfBounds);
        }
        this.type.updateIndex(this.index);
    }

    private void updatePosition(boolean movedOutOfBounds) {
        if (movedOutOfBounds) {
            this.isOutOfBounds = true;
            this.currentCellMin = this.oobCellMin;
            this.currentCellMax = this.oobCellMax;
        } else {
            if (this.isOutOfBounds) {
                for (int d = 0; d < this.n; ++d) {
                    if (this.position[d] >= 0L && this.position[d] < this.dimensions[d]) continue;
                    return;
                }
                this.isOutOfBounds = false;
                this.grid.getCellPosition(this.position, this.randomAccessOnCells);
            }
            Object cell = this.getCell();
            this.currentCellSteps = ((Cell)cell).steps;
            this.currentCellMin = ((Cell)cell).min;
            this.currentCellMax = ((Cell)cell).max;
            this.index = ((Cell)cell).globalPositionToIndex(this.position);
            this.type.updateContainer(this);
        }
    }
}

