/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.img.cell;

import net.imglib2.AbstractCursor;
import net.imglib2.Cursor;
import net.imglib2.IterableInterval;
import net.imglib2.img.cell.AbstractCellImg;
import net.imglib2.img.cell.Cell;
import net.imglib2.type.NativeType;

public class CellCursor<T extends NativeType<T>, C extends Cell<?>>
extends AbstractCursor<T>
implements AbstractCellImg.CellImgSampler<C> {
    protected final T type;
    protected final Cursor<C> cursorOnCells;
    protected int lastIndexInCell;
    protected int index;
    protected boolean isNotLastCell;

    protected CellCursor(CellCursor<T, C> cursor) {
        super(cursor.numDimensions());
        this.type = cursor.type.duplicateTypeOnSameNativeImg();
        this.cursorOnCells = cursor.cursorOnCells.copyCursor();
        this.isNotLastCell = cursor.isNotLastCell;
        this.lastIndexInCell = cursor.lastIndexInCell;
        this.index = cursor.index;
        this.type.updateContainer(this);
        this.type.updateIndex(this.index);
    }

    public CellCursor(AbstractCellImg<T, ?, C, ?> img) {
        super(img.numDimensions());
        this.type = img.createLinkedType();
        this.cursorOnCells = ((IterableInterval)img.getCells()).cursor();
        this.reset();
    }

    @Override
    public C getCell() {
        return (C)((Cell)this.cursorOnCells.get());
    }

    @Override
    public T get() {
        return this.type;
    }

    @Override
    public CellCursor<T, C> copy() {
        return new CellCursor<T, C>(this);
    }

    @Override
    public CellCursor<T, C> copyCursor() {
        return this.copy();
    }

    @Override
    public boolean hasNext() {
        return this.index < this.lastIndexInCell || this.isNotLastCell;
    }

    @Override
    public void jumpFwd(long steps) {
        long newIndex;
        for (newIndex = (long)this.index + steps; newIndex > (long)this.lastIndexInCell; newIndex -= (long)(this.lastIndexInCell + 1)) {
            this.cursorOnCells.fwd();
            this.isNotLastCell = this.cursorOnCells.hasNext();
            this.lastIndexInCell = (int)(((Cell)this.getCell()).size() - 1L);
        }
        this.index = (int)newIndex;
        this.type.updateIndex(this.index);
        this.type.updateContainer(this);
    }

    @Override
    public void fwd() {
        if (++this.index > this.lastIndexInCell) {
            this.moveToNextCell();
            this.index = 0;
        }
        this.type.updateIndex(this.index);
    }

    @Override
    public void reset() {
        this.cursorOnCells.reset();
        this.moveToNextCell();
        this.type.updateIndex(this.index);
    }

    @Override
    public String toString() {
        return this.type.toString();
    }

    @Override
    public long getLongPosition(int dim) {
        return ((Cell)this.getCell()).indexToGlobalPosition(this.index, dim);
    }

    @Override
    public void localize(long[] position) {
        ((Cell)this.getCell()).indexToGlobalPosition(this.index, position);
    }

    private void moveToNextCell() {
        this.cursorOnCells.fwd();
        this.isNotLastCell = this.cursorOnCells.hasNext();
        this.lastIndexInCell = (int)(((Cell)this.getCell()).size() - 1L);
        this.index = -1;
        this.type.updateContainer(this);
    }
}

