/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.img.array;

import net.imglib2.img.array.ArrayImg;
import net.imglib2.img.array.ArrayImgFactory;
import net.imglib2.img.basictypeaccess.ByteAccess;
import net.imglib2.img.basictypeaccess.DoubleAccess;
import net.imglib2.img.basictypeaccess.FloatAccess;
import net.imglib2.img.basictypeaccess.IntAccess;
import net.imglib2.img.basictypeaccess.LongAccess;
import net.imglib2.img.basictypeaccess.ShortAccess;
import net.imglib2.img.basictypeaccess.array.ByteArray;
import net.imglib2.img.basictypeaccess.array.DoubleArray;
import net.imglib2.img.basictypeaccess.array.FloatArray;
import net.imglib2.img.basictypeaccess.array.IntArray;
import net.imglib2.img.basictypeaccess.array.LongArray;
import net.imglib2.img.basictypeaccess.array.ShortArray;
import net.imglib2.type.logic.BitType;
import net.imglib2.type.numeric.ARGBType;
import net.imglib2.type.numeric.complex.ComplexDoubleType;
import net.imglib2.type.numeric.complex.ComplexFloatType;
import net.imglib2.type.numeric.integer.ByteType;
import net.imglib2.type.numeric.integer.IntType;
import net.imglib2.type.numeric.integer.LongType;
import net.imglib2.type.numeric.integer.ShortType;
import net.imglib2.type.numeric.integer.UnsignedByteType;
import net.imglib2.type.numeric.integer.UnsignedIntType;
import net.imglib2.type.numeric.integer.UnsignedLongType;
import net.imglib2.type.numeric.integer.UnsignedShortType;
import net.imglib2.type.numeric.real.DoubleType;
import net.imglib2.type.numeric.real.FloatType;
import net.imglib2.util.Fraction;

public final class ArrayImgs {
    private ArrayImgs() {
    }

    public static final ArrayImg<UnsignedByteType, ByteArray> unsignedBytes(long ... dim) {
        return new ArrayImgFactory().create(dim, new UnsignedByteType());
    }

    public static final ArrayImg<UnsignedByteType, ByteArray> unsignedBytes(byte[] array, long ... dim) {
        return ArrayImgs.unsignedBytes(new ByteArray(array), dim);
    }

    public static final <A extends ByteAccess> ArrayImg<UnsignedByteType, A> unsignedBytes(A access, long ... dim) {
        ArrayImg<UnsignedByteType, A> img = new ArrayImg<UnsignedByteType, A>(access, dim, new Fraction());
        UnsignedByteType t = new UnsignedByteType(img);
        img.setLinkedType(t);
        return img;
    }

    public static final ArrayImg<ByteType, ByteArray> bytes(long ... dim) {
        return new ArrayImgFactory().create(dim, new ByteType());
    }

    public static final ArrayImg<ByteType, ByteArray> bytes(byte[] array, long ... dim) {
        return ArrayImgs.bytes(new ByteArray(array), dim);
    }

    public static final <A extends ByteAccess> ArrayImg<ByteType, A> bytes(A access, long ... dim) {
        ArrayImg<ByteType, A> img = new ArrayImg<ByteType, A>(access, dim, new Fraction());
        ByteType t = new ByteType(img);
        img.setLinkedType(t);
        return img;
    }

    public static final ArrayImg<UnsignedShortType, ShortArray> unsignedShorts(long ... dim) {
        return new ArrayImgFactory().create(dim, new UnsignedShortType());
    }

    public static final ArrayImg<UnsignedShortType, ShortArray> unsignedShorts(short[] array, long ... dim) {
        return ArrayImgs.unsignedShorts(new ShortArray(array), dim);
    }

    public static final <A extends ShortAccess> ArrayImg<UnsignedShortType, A> unsignedShorts(A access, long ... dim) {
        ArrayImg<UnsignedShortType, A> img = new ArrayImg<UnsignedShortType, A>(access, dim, new Fraction());
        UnsignedShortType t = new UnsignedShortType(img);
        img.setLinkedType(t);
        return img;
    }

    public static final ArrayImg<ShortType, ShortArray> shorts(long ... dim) {
        return new ArrayImgFactory().create(dim, new ShortType());
    }

    public static final ArrayImg<ShortType, ShortArray> shorts(short[] array, long ... dim) {
        return ArrayImgs.shorts(new ShortArray(array), dim);
    }

    public static final <A extends ShortAccess> ArrayImg<ShortType, A> shorts(A access, long ... dim) {
        ArrayImg<ShortType, A> img = new ArrayImg<ShortType, A>(access, dim, new Fraction());
        ShortType t = new ShortType(img);
        img.setLinkedType(t);
        return img;
    }

    public static final ArrayImg<UnsignedIntType, IntArray> unsignedInts(long ... dim) {
        return new ArrayImgFactory().create(dim, new UnsignedIntType());
    }

    public static final ArrayImg<UnsignedIntType, IntArray> unsignedInts(int[] array, long ... dim) {
        return ArrayImgs.unsignedInts(new IntArray(array), dim);
    }

    public static final <A extends IntAccess> ArrayImg<UnsignedIntType, A> unsignedInts(A access, long ... dim) {
        ArrayImg<UnsignedIntType, A> img = new ArrayImg<UnsignedIntType, A>(access, dim, new Fraction());
        UnsignedIntType t = new UnsignedIntType(img);
        img.setLinkedType(t);
        return img;
    }

    public static final ArrayImg<IntType, IntArray> ints(long ... dim) {
        return new ArrayImgFactory().create(dim, new IntType());
    }

    public static final ArrayImg<IntType, IntArray> ints(int[] array, long ... dim) {
        return ArrayImgs.ints(new IntArray(array), dim);
    }

    public static final <A extends IntAccess> ArrayImg<IntType, A> ints(A access, long ... dim) {
        ArrayImg<IntType, A> img = new ArrayImg<IntType, A>(access, dim, new Fraction());
        IntType t = new IntType(img);
        img.setLinkedType(t);
        return img;
    }

    public static final <A extends LongAccess> ArrayImg<UnsignedLongType, A> unsignedLongs(A access, long ... dim) {
        ArrayImg<UnsignedLongType, A> img = new ArrayImg<UnsignedLongType, A>(access, dim, new Fraction());
        UnsignedLongType t = new UnsignedLongType(img);
        img.setLinkedType(t);
        return img;
    }

    public static final ArrayImg<LongType, LongArray> longs(long ... dim) {
        return new ArrayImgFactory().create(dim, new LongType());
    }

    public static final ArrayImg<LongType, LongArray> longs(long[] array, long ... dim) {
        return ArrayImgs.longs(new LongArray(array), dim);
    }

    public static final <A extends LongAccess> ArrayImg<LongType, A> longs(A access, long ... dim) {
        ArrayImg<LongType, A> img = new ArrayImg<LongType, A>(access, dim, new Fraction());
        LongType t = new LongType(img);
        img.setLinkedType(t);
        return img;
    }

    public static final ArrayImg<BitType, LongArray> bits(long ... dim) {
        return new ArrayImgFactory().create(dim, new BitType());
    }

    public static final <A extends LongAccess> ArrayImg<BitType, A> bits(A access, long ... dim) {
        ArrayImg<BitType, A> img = new ArrayImg<BitType, A>(access, dim, new Fraction(1L, 64L));
        BitType t = new BitType(img);
        img.setLinkedType(t);
        return img;
    }

    public static final ArrayImg<FloatType, FloatArray> floats(long ... dim) {
        return new ArrayImgFactory().create(dim, new FloatType());
    }

    public static final ArrayImg<FloatType, FloatArray> floats(float[] array, long ... dim) {
        return ArrayImgs.floats(new FloatArray(array), dim);
    }

    public static final <A extends FloatAccess> ArrayImg<FloatType, A> floats(A access, long ... dim) {
        ArrayImg<FloatType, A> img = new ArrayImg<FloatType, A>(access, dim, new Fraction());
        FloatType t = new FloatType(img);
        img.setLinkedType(t);
        return img;
    }

    public static final ArrayImg<DoubleType, DoubleArray> doubles(long ... dim) {
        return new ArrayImgFactory().create(dim, new DoubleType());
    }

    public static final ArrayImg<DoubleType, DoubleArray> doubles(double[] array, long ... dim) {
        return ArrayImgs.doubles(new DoubleArray(array), dim);
    }

    public static final <A extends DoubleAccess> ArrayImg<DoubleType, A> doubles(A access, long ... dim) {
        ArrayImg<DoubleType, A> img = new ArrayImg<DoubleType, A>(access, dim, new Fraction());
        DoubleType t = new DoubleType(img);
        img.setLinkedType(t);
        return img;
    }

    public static final ArrayImg<ARGBType, IntArray> argbs(long ... dim) {
        return new ArrayImgFactory().create(dim, new ARGBType());
    }

    public static final ArrayImg<ARGBType, IntArray> argbs(int[] array, long ... dim) {
        return ArrayImgs.argbs(new IntArray(array), dim);
    }

    public static final <A extends IntAccess> ArrayImg<ARGBType, A> argbs(A access, long ... dim) {
        ArrayImg<ARGBType, A> img = new ArrayImg<ARGBType, A>(access, dim, new Fraction());
        ARGBType t = new ARGBType(img);
        img.setLinkedType(t);
        return img;
    }

    public static final ArrayImg<ComplexFloatType, FloatArray> complexFloats(long ... dim) {
        return new ArrayImgFactory().create(dim, new ComplexFloatType());
    }

    public static final ArrayImg<ComplexFloatType, FloatArray> complexFloats(float[] array, long ... dim) {
        return ArrayImgs.complexFloats(new FloatArray(array), dim);
    }

    public static final <A extends FloatAccess> ArrayImg<ComplexFloatType, A> complexFloats(A access, long ... dim) {
        ArrayImg<ComplexFloatType, A> img = new ArrayImg<ComplexFloatType, A>(access, dim, new Fraction(2L, 1L));
        ComplexFloatType t = new ComplexFloatType(img);
        img.setLinkedType(t);
        return img;
    }

    public static final ArrayImg<ComplexDoubleType, DoubleArray> complexDoubles(long ... dim) {
        return new ArrayImgFactory().create(dim, new ComplexDoubleType());
    }

    public static final ArrayImg<ComplexDoubleType, DoubleArray> complexDoubles(double[] array, long ... dim) {
        return ArrayImgs.complexDoubles(new DoubleArray(array), dim);
    }

    public static final <A extends DoubleAccess> ArrayImg<ComplexDoubleType, A> complexDoubles(A access, long ... dim) {
        ArrayImg<ComplexDoubleType, A> img = new ArrayImg<ComplexDoubleType, A>(access, dim, new Fraction(2L, 1L));
        ComplexDoubleType t = new ComplexDoubleType(img);
        img.setLinkedType(t);
        return img;
    }
}

