/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.sgl;

import edu.mines.jtk.dsp.EigenTensors3;
import edu.mines.jtk.dsp.Sampling;
import edu.mines.jtk.sgl.Axis;
import edu.mines.jtk.sgl.AxisAlignedFrame;
import edu.mines.jtk.sgl.AxisAlignedPanel;
import edu.mines.jtk.sgl.DrawContext;
import edu.mines.jtk.sgl.EllipsoidGlyph;
import edu.mines.jtk.sgl.StateSet;
import edu.mines.jtk.util.ArrayMath;
import java.awt.Color;

public class TensorsPanel
extends AxisAlignedPanel {
    private Sampling _sx;
    private Sampling _sy;
    private Sampling _sz;
    private EigenTensors3 _et;
    private float _emax;
    private int _ellipsoidSize = 10;
    private EllipsoidGlyph _eg = new EllipsoidGlyph();

    public TensorsPanel(EigenTensors3 et) {
        this(new Sampling(et.getN1()), new Sampling(et.getN2()), new Sampling(et.getN3()), et);
    }

    public TensorsPanel(Sampling s1, Sampling s2, Sampling s3, EigenTensors3 et) {
        this._sx = s3;
        this._sy = s2;
        this._sz = s1;
        this._et = et;
        this._emax = this.findMaxEigenvalue();
        this.setStates(StateSet.forTwoSidedShinySurface(Color.CYAN));
    }

    public void update() {
        this.dirtyDraw();
    }

    public void setEllipsoidSize(int size) {
        this._ellipsoidSize = size;
        this.dirtyDraw();
    }

    @Override
    protected void draw(DrawContext dc) {
        AxisAlignedFrame aaf = this.getFrame();
        if (aaf == null) {
            return;
        }
        Axis axis = aaf.getAxis();
        this.drawEllipsoids(axis);
    }

    private void drawEllipsoids(Axis axis) {
        block16: {
            AxisAlignedFrame aaf;
            float etiny;
            float scale;
            int kec;
            float dymax;
            float dxmax;
            double zmax;
            double zmin;
            double ymax;
            double ymin;
            double xmax;
            double xmin;
            double fy;
            double fx;
            double dz;
            double dy;
            double dx;
            int ny;
            int nx;
            block17: {
                float dzmax;
                double fz;
                int nz;
                block15: {
                    nx = this._sx.getCount();
                    ny = this._sy.getCount();
                    nz = this._sz.getCount();
                    dx = this._sx.getDelta();
                    dy = this._sy.getDelta();
                    dz = this._sz.getDelta();
                    fx = this._sx.getFirst();
                    fy = this._sy.getFirst();
                    fz = this._sz.getFirst();
                    xmin = this._sx.getFirst();
                    xmax = this._sx.getLast();
                    ymin = this._sy.getFirst();
                    ymax = this._sy.getLast();
                    zmin = this._sz.getFirst();
                    zmax = this._sz.getLast();
                    float dmax = 0.5f * (float)this._ellipsoidSize;
                    dxmax = (float)dx * dmax;
                    dymax = (float)dy * dmax;
                    dzmax = (float)dz * dmax;
                    kec = (int)(2.0 * (double)dmax);
                    scale = dmax / ArrayMath.sqrt(this._emax);
                    etiny = 1.0E-4f * this._emax;
                    aaf = this.getFrame();
                    if (axis != Axis.X) break block15;
                    int nyc = (int)((ymax - ymin) / (double)(2.0f * dymax));
                    double dyc = (double)kec * dy;
                    double fyc = 0.5 * (ymax - ymin - (double)(nyc - 1) * dyc);
                    int jyc = (int)(fyc / dy);
                    int nzc = (int)((zmax - zmin) / (double)(2.0f * dzmax));
                    double dzc = (double)kec * dz;
                    double fzc = 0.5 * (zmax - zmin - (double)(nzc - 1) * dzc);
                    int jzc = (int)(fzc / dz);
                    xmin = aaf.getCornerMin().x;
                    xmax = aaf.getCornerMax().x;
                    ymin = aaf.getCornerMin().y;
                    ymax = aaf.getCornerMax().y;
                    zmin = aaf.getCornerMin().z;
                    zmax = aaf.getCornerMax().z;
                    float xc = 0.5f * (float)(xmax + xmin);
                    int ix = this._sx.indexOfNearest(xc);
                    for (int iy = jyc; iy < ny; iy += kec) {
                        float yc = (float)(fy + (double)iy * dy);
                        if (!(ymin < (double)(yc - dymax)) || !((double)(yc + dymax) < ymax)) continue;
                        for (int iz = jzc; iz < nz; iz += kec) {
                            float zc = (float)(fz + (double)iz * dz);
                            if (!(zmin < (double)(zc - dzmax)) || !((double)(zc + dzmax) < zmax)) continue;
                            float[] e = this._et.getEigenvalues(iz, iy, ix);
                            float[] u = this._et.getEigenvectorU(iz, iy, ix);
                            float[] v = this._et.getEigenvectorV(iz, iy, ix);
                            float[] w = this._et.getEigenvectorW(iz, iy, ix);
                            float eu = e[0];
                            float ev = e[1];
                            float ew = e[2];
                            if (eu <= etiny) {
                                eu = etiny;
                            }
                            if (ev <= etiny) {
                                ev = etiny;
                            }
                            if (ew <= etiny) {
                                ew = etiny;
                            }
                            float uz = u[0];
                            float uy = u[1];
                            float ux = u[2];
                            float vz = v[0];
                            float vy = v[1];
                            float vx = v[2];
                            float wz = w[0];
                            float wy = w[1];
                            float wx = w[2];
                            float su = scale * ArrayMath.sqrt(eu);
                            float sv = scale * ArrayMath.sqrt(ev);
                            float sw = scale * ArrayMath.sqrt(ew);
                            ux = (float)((double)ux * ((double)su * dx));
                            uy = (float)((double)uy * ((double)su * dy));
                            uz = (float)((double)uz * ((double)su * dz));
                            vx = (float)((double)vx * ((double)sv * dx));
                            vy = (float)((double)vy * ((double)sv * dy));
                            vz = (float)((double)vz * ((double)sv * dz));
                            wx = (float)((double)wx * ((double)sw * dx));
                            wy = (float)((double)wy * ((double)sw * dy));
                            wz = (float)((double)wz * ((double)sw * dz));
                            this._eg.draw(xc, yc, zc, ux, uy, uz, vx, vy, vz, wx, wy, wz);
                        }
                    }
                    break block16;
                }
                if (axis != Axis.Y) break block17;
                int nxc = (int)((xmax - xmin) / (double)(2.0f * dxmax));
                double dxc = (double)kec * dx;
                double fxc = 0.5 * (xmax - xmin - (double)(nxc - 1) * dxc);
                int jxc = (int)(fxc / dx);
                int nzc = (int)((zmax - zmin) / (double)(2.0f * dzmax));
                double dzc = (double)kec * dz;
                double fzc = 0.5 * (zmax - zmin - (double)(nzc - 1) * dzc);
                int jzc = (int)(fzc / dz);
                xmin = aaf.getCornerMin().x;
                xmax = aaf.getCornerMax().x;
                ymin = aaf.getCornerMin().y;
                ymax = aaf.getCornerMax().y;
                zmin = aaf.getCornerMin().z;
                zmax = aaf.getCornerMax().z;
                float yc = 0.5f * (float)(ymax + ymin);
                int iy = this._sy.indexOfNearest(yc);
                for (int ix = jxc; ix < nx; ix += kec) {
                    float xc = (float)(fx + (double)ix * dx);
                    if (!(xmin < (double)(xc - dxmax)) || !((double)(xc + dxmax) < xmax)) continue;
                    for (int iz = jzc; iz < nz; iz += kec) {
                        float zc = (float)(fz + (double)iz * dz);
                        if (!(zmin < (double)(zc - dzmax)) || !((double)(zc + dzmax) < zmax)) continue;
                        float[] e = this._et.getEigenvalues(iz, iy, ix);
                        float[] u = this._et.getEigenvectorU(iz, iy, ix);
                        float[] v = this._et.getEigenvectorV(iz, iy, ix);
                        float[] w = this._et.getEigenvectorW(iz, iy, ix);
                        float eu = e[0];
                        float ev = e[1];
                        float ew = e[2];
                        if (eu <= etiny) {
                            eu = etiny;
                        }
                        if (ev <= etiny) {
                            ev = etiny;
                        }
                        if (ew <= etiny) {
                            ew = etiny;
                        }
                        float uz = u[0];
                        float uy = u[1];
                        float ux = u[2];
                        float vz = v[0];
                        float vy = v[1];
                        float vx = v[2];
                        float wz = w[0];
                        float wy = w[1];
                        float wx = w[2];
                        float su = scale * ArrayMath.sqrt(eu);
                        float sv = scale * ArrayMath.sqrt(ev);
                        float sw = scale * ArrayMath.sqrt(ew);
                        ux = (float)((double)ux * ((double)su * dx));
                        uy = (float)((double)uy * ((double)su * dy));
                        uz = (float)((double)uz * ((double)su * dz));
                        vx = (float)((double)vx * ((double)sv * dx));
                        vy = (float)((double)vy * ((double)sv * dy));
                        vz = (float)((double)vz * ((double)sv * dz));
                        wx = (float)((double)wx * ((double)sw * dx));
                        wy = (float)((double)wy * ((double)sw * dy));
                        wz = (float)((double)wz * ((double)sw * dz));
                        this._eg.draw(xc, yc, zc, ux, uy, uz, vx, vy, vz, wx, wy, wz);
                    }
                }
                break block16;
            }
            if (axis != Axis.Z) break block16;
            int nxc = (int)((xmax - xmin) / (double)(2.0f * dxmax));
            double dxc = (double)kec * dx;
            double fxc = 0.5 * (xmax - xmin - (double)(nxc - 1) * dxc);
            int jxc = (int)(fxc / dx);
            int nyc = (int)((ymax - ymin) / (double)(2.0f * dymax));
            double dyc = (double)kec * dy;
            double fyc = 0.5 * (ymax - ymin - (double)(nyc - 1) * dyc);
            int jyc = (int)(fyc / dy);
            xmin = aaf.getCornerMin().x;
            xmax = aaf.getCornerMax().x;
            ymin = aaf.getCornerMin().y;
            ymax = aaf.getCornerMax().y;
            zmin = aaf.getCornerMin().z;
            zmax = aaf.getCornerMax().z;
            float zc = 0.5f * (float)(zmax + zmin);
            int iz = this._sz.indexOfNearest(zc);
            for (int ix = jxc; ix < nx; ix += kec) {
                float xc = (float)(fx + (double)ix * dx);
                if (!(xmin < (double)(xc - dxmax)) || !((double)(xc + dxmax) < xmax)) continue;
                for (int iy = jyc; iy < ny; iy += kec) {
                    float yc = (float)(fy + (double)iy * dy);
                    if (!(ymin < (double)(yc - dymax)) || !((double)(yc + dymax) < ymax)) continue;
                    float[] e = this._et.getEigenvalues(iz, iy, ix);
                    float[] u = this._et.getEigenvectorU(iz, iy, ix);
                    float[] v = this._et.getEigenvectorV(iz, iy, ix);
                    float[] w = this._et.getEigenvectorW(iz, iy, ix);
                    float eu = e[0];
                    float ev = e[1];
                    float ew = e[2];
                    if (eu <= etiny) {
                        eu = etiny;
                    }
                    if (ev <= etiny) {
                        ev = etiny;
                    }
                    if (ew <= etiny) {
                        ew = etiny;
                    }
                    float uz = u[0];
                    float uy = u[1];
                    float ux = u[2];
                    float vz = v[0];
                    float vy = v[1];
                    float vx = v[2];
                    float wz = w[0];
                    float wy = w[1];
                    float wx = w[2];
                    float su = scale * ArrayMath.sqrt(eu);
                    float sv = scale * ArrayMath.sqrt(ev);
                    float sw = scale * ArrayMath.sqrt(ew);
                    ux = (float)((double)ux * ((double)su * dx));
                    uy = (float)((double)uy * ((double)su * dy));
                    uz = (float)((double)uz * ((double)su * dz));
                    vx = (float)((double)vx * ((double)sv * dx));
                    vy = (float)((double)vy * ((double)sv * dy));
                    vz = (float)((double)vz * ((double)sv * dz));
                    wx = (float)((double)wx * ((double)sw * dx));
                    wy = (float)((double)wy * ((double)sw * dy));
                    wz = (float)((double)wz * ((double)sw * dz));
                    this._eg.draw(xc, yc, zc, ux, uy, uz, vx, vy, vz, wx, wy, wz);
                }
            }
        }
    }

    private float findMaxEigenvalue() {
        int n1 = this._et.getN1();
        int n2 = this._et.getN2();
        int n3 = this._et.getN3();
        float[] e = new float[3];
        float emax = 0.0f;
        for (int i3 = 0; i3 < n3; ++i3) {
            for (int i2 = 0; i2 < n2; ++i2) {
                for (int i1 = 0; i1 < n1; ++i1) {
                    this._et.getEigenvalues(i1, i2, i3, e);
                    float emaxi = ArrayMath.max(e[0], e[1], e[2]);
                    if (!(emax < emaxi)) continue;
                    emax = emaxi;
                }
            }
        }
        return emax;
    }
}

