/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.dsp;

import edu.mines.jtk.util.ArrayMath;
import edu.mines.jtk.util.Check;
import edu.mines.jtk.util.Parallel;
import java.util.Random;

public class SymmetricTridiagonalFilter {
    private double _af;
    private double _ai;
    private double _al;
    private double _b;

    public SymmetricTridiagonalFilter(double af, double ai, double al, double b) {
        this._af = af;
        this._ai = ai;
        this._al = al;
        this._b = b;
    }

    public void apply(float[] x, float[] y) {
        float xim1;
        int n = x.length;
        int nm1 = n - 1;
        float af = (float)this._af;
        float ai = (float)this._ai;
        float al = (float)this._al;
        float b = (float)this._b;
        float xi = x[0];
        float xip1 = x[1];
        y[0] = af * xi + b * xip1;
        for (int i = 1; i < nm1; ++i) {
            xim1 = xi;
            xi = xip1;
            xip1 = x[i + 1];
            y[i] = ai * xi + b * (xim1 + xip1);
        }
        xim1 = xi;
        xi = xip1;
        y[n - 1] = al * xi + b * xim1;
    }

    public void apply1(final float[][] x, final float[][] y) {
        int n = x.length;
        Parallel.loop(n, new Parallel.LoopInt(){

            @Override
            public void compute(int i) {
                SymmetricTridiagonalFilter.this.apply(x[i], y[i]);
            }
        });
    }

    public void apply2(float[][] x, float[][] y) {
        int i1;
        int n1 = x[0].length;
        int n2 = x.length;
        int n2m1 = n2 - 1;
        float af = (float)this._af;
        float ai = (float)this._ai;
        float al = (float)this._al;
        float b = (float)this._b;
        float[] xi2m1 = new float[n1];
        float[] xi2 = ArrayMath.copy(x[0]);
        float[] xi2p1 = ArrayMath.copy(x[1]);
        float[] yi2 = y[0];
        for (i1 = 0; i1 < n1; ++i1) {
            yi2[i1] = af * xi2[i1] + b * xi2p1[i1];
        }
        for (int i2 = 1; i2 < n2m1; ++i2) {
            float[] xtemp = xi2m1;
            xi2m1 = xi2;
            xi2 = xi2p1;
            xi2p1 = xtemp;
            ArrayMath.copy(x[i2 + 1], xi2p1);
            yi2 = y[i2];
            for (int i12 = 0; i12 < n1; ++i12) {
                yi2[i12] = ai * xi2[i12] + b * (xi2m1[i12] + xi2p1[i12]);
            }
        }
        xi2m1 = xi2;
        xi2 = xi2p1;
        yi2 = y[n2 - 1];
        for (i1 = 0; i1 < n1; ++i1) {
            yi2[i1] = al * xi2[i1] + b * xi2m1[i1];
        }
    }

    public void apply1(final float[][][] x, final float[][][] y) {
        int n = x.length;
        Parallel.loop(n, new Parallel.LoopInt(){

            @Override
            public void compute(int i) {
                SymmetricTridiagonalFilter.this.apply1(x[i], y[i]);
            }
        });
    }

    public void apply2(final float[][][] x, final float[][][] y) {
        int n = x.length;
        Parallel.loop(n, new Parallel.LoopInt(){

            @Override
            public void compute(int i) {
                SymmetricTridiagonalFilter.this.apply2(x[i], y[i]);
            }
        });
    }

    public void apply3(float[][][] x, float[][][] y) {
        int n2 = x[0].length;
        int n3 = x.length;
        float[][][] xt = new float[n2][n3][];
        float[][][] yt = new float[n2][n3][];
        for (int i2 = 0; i2 < n2; ++i2) {
            for (int i3 = 0; i3 < n3; ++i3) {
                xt[i2][i3] = x[i3][i2];
                yt[i2][i3] = y[i3][i2];
            }
        }
        this.apply2(xt, yt);
    }

    public void applyInverse(float[] x, float[] y) {
        int i;
        this.checkInvertible();
        int n = x.length;
        int nm1 = n - 1;
        if (this._b == 0.0) {
            y[0] = x[0] / (float)this._af;
            float oa = 1.0f / (float)this._ai;
            for (int i2 = 1; i2 < nm1; ++i2) {
                y[i2] = x[i2] * oa;
            }
            y[n - 1] = x[n - 1] / (float)this._al;
            return;
        }
        float u = (float)(this._ai / this._af);
        float v = (float)(this._ai / this._al);
        float a = (float)(this._ai / this._b);
        float aa = a * a;
        float b = -a * (1.0f + ArrayMath.sqrt(1.0f - 4.0f / aa)) / 2.0f;
        if (ArrayMath.abs(b) > 1.0f) {
            b = 1.0f / b;
        }
        float bb = b * b;
        float ss = (1.0f + bb) / u - bb;
        float gg = (1.0f + bb) / v - 1.0f;
        float scale = (1.0f + bb) / (float)this._ai;
        for (i = 0; i < n; ++i) {
            y[i] = scale * x[i];
        }
        if (bb < 1.0f) {
            int m;
            int i3;
            float ynm1 = 0.0f;
            float c = (1.0f - bb - ss) / ss;
            float d = 1.0f - bb + gg * (1.0f + c * ArrayMath.pow(bb, (float)(n - 1)));
            float e = ArrayMath.pow(1.0f - ArrayMath.abs(b), 2.0f) * 1.1920929E-7f / 4.0f;
            int k = ArrayMath.min((int)ArrayMath.ceil(ArrayMath.log(e) / ArrayMath.log(ArrayMath.abs(b))), 2 * (n - 1));
            for (i3 = m = k - n + 1; i3 > 0; --i3) {
                ynm1 = b * ynm1 + y[i3];
            }
            ynm1 *= c;
            if (n - k < 1) {
                ynm1 = b * ynm1 + (1.0f + c) * y[0];
            }
            for (i3 = m = ArrayMath.max(n - k, 1); i3 < n; ++i3) {
                ynm1 = b * ynm1 + y[i3];
            }
            int n2 = n - 1;
            y[n2] = y[n2] - gg * (ynm1 /= d);
            for (i3 = n - 2; i3 >= 0; --i3) {
                int n3 = i3;
                y[n3] = y[n3] + b * y[i3 + 1];
            }
            y[0] = y[0] / ss;
            for (i3 = 1; i3 < nm1; ++i3) {
                int n4 = i3;
                y[n4] = y[n4] + b * y[i3 - 1];
            }
            y[n - 1] = ynm1;
        } else if (ss > 0.0f && gg > 0.0f) {
            int i4;
            float oss = 1.0f / ss;
            float sum = 0.0f;
            for (int j = 0; j < nm1; ++j) {
                sum = (sum + ((float)j + oss) * y[j]) * b;
            }
            float ynm1 = (sum += ((float)(n - 1) + oss) * y[n - 1]) / (1.0f + gg * (float)(n - 1) + gg / ss);
            int n5 = n - 1;
            y[n5] = y[n5] - gg * ynm1;
            for (i4 = n - 2; i4 >= 0; --i4) {
                int n6 = i4;
                y[n6] = y[n6] + b * y[i4 + 1];
            }
            y[0] = y[0] / ss;
            for (i4 = 1; i4 < nm1; ++i4) {
                int n7 = i4;
                y[n7] = y[n7] + b * y[i4 - 1];
            }
            y[n - 1] = ynm1;
        } else if (ss == 0.0f) {
            y[0] = y[0] * -b;
            for (i = 1; i < nm1; ++i) {
                y[i] = b * (y[i - 1] - y[i]);
            }
            y[n - 1] = (y[n - 1] - y[n - 2]) / gg;
            for (i = n - 2; i >= 0; --i) {
                y[i] = b * (y[i + 1] - y[i]);
            }
        } else if (gg == 0.0f) {
            for (i = n - 2; i > 0; --i) {
                int n8 = i;
                y[n8] = y[n8] + b * y[i + 1];
            }
            y[0] = (y[0] + b * y[1]) / ss;
            for (i = 1; i < n; ++i) {
                int n9 = i;
                y[n9] = y[n9] + b * y[i - 1];
            }
        } else {
            Check.state(false, "filter is invertible");
        }
    }

    public void applyInverse1(final float[][] x, final float[][] y) {
        int n = x.length;
        Parallel.loop(n, new Parallel.LoopInt(){

            @Override
            public void compute(int i) {
                SymmetricTridiagonalFilter.this.applyInverse(x[i], y[i]);
            }
        });
    }

    public void applyInverse2(float[][] x, float[][] y) {
        int i1;
        int i12;
        int i2;
        this.checkInvertible();
        int n1 = x[0].length;
        int n2 = x.length;
        int n2m1 = n2 - 1;
        if (this._b == 0.0) {
            int i13;
            float oa = 1.0f / (float)this._af;
            for (i13 = 0; i13 < n1; ++i13) {
                y[0][i13] = x[0][i13] * oa;
            }
            oa = 1.0f / (float)this._ai;
            for (int i22 = 1; i22 < n2m1; ++i22) {
                for (int i14 = 0; i14 < n1; ++i14) {
                    y[i22][i14] = x[i22][i14] * oa;
                }
            }
            oa = 1.0f / (float)this._al;
            for (i13 = 0; i13 < n1; ++i13) {
                y[n2m1][i13] = x[n2m1][i13] * oa;
            }
            return;
        }
        float u = (float)(this._ai / this._af);
        float v = (float)(this._ai / this._al);
        float a = (float)(this._ai / this._b);
        float aa = a * a;
        float b = -a * (1.0f + ArrayMath.sqrt(1.0f - 4.0f / aa)) / 2.0f;
        if (ArrayMath.abs(b) > 1.0f) {
            b = 1.0f / b;
        }
        float bb = b * b;
        float ss = (1.0f + bb) / u - bb;
        float gg = (1.0f + bb) / v - 1.0f;
        float scale = (1.0f + bb) / (float)this._ai;
        for (i2 = 0; i2 < n2; ++i2) {
            for (i12 = 0; i12 < n1; ++i12) {
                y[i2][i12] = scale * x[i2][i12];
            }
        }
        if (bb < 1.0f) {
            int i15;
            int m2;
            int i23;
            float[] yn2m1 = new float[n1];
            float c = (1.0f - bb - ss) / ss;
            float d = 1.0f - bb + gg * (1.0f + c * ArrayMath.pow(bb, (float)(n2 - 1)));
            float e = ArrayMath.pow(1.0f - ArrayMath.abs(b), 2.0f) * 1.1920929E-7f / 4.0f;
            int k2 = ArrayMath.min((int)ArrayMath.ceil(ArrayMath.log(e) / ArrayMath.log(ArrayMath.abs(b))), 2 * (n2 - 1));
            for (i23 = m2 = k2 - n2 + 1; i23 > 0; --i23) {
                for (i15 = 0; i15 < n1; ++i15) {
                    yn2m1[i15] = b * yn2m1[i15] + y[i23][i15];
                }
            }
            int i16 = 0;
            while (i16 < n1) {
                int n = i16++;
                yn2m1[n] = yn2m1[n] * c;
            }
            if (n2 - k2 < 1) {
                for (i16 = 0; i16 < n1; ++i16) {
                    yn2m1[i16] = b * yn2m1[i16] + (1.0f + c) * y[0][i16];
                }
            }
            for (i23 = m2 = ArrayMath.max(n2 - k2, 1); i23 < n2; ++i23) {
                for (i15 = 0; i15 < n1; ++i15) {
                    yn2m1[i15] = b * yn2m1[i15] + y[i23][i15];
                }
            }
            i16 = 0;
            while (i16 < n1) {
                int n = i16++;
                yn2m1[n] = yn2m1[n] / d;
            }
            for (i16 = 0; i16 < n1; ++i16) {
                float[] fArray = y[n2 - 1];
                int n = i16;
                fArray[n] = fArray[n] - gg * yn2m1[i16];
            }
            for (i23 = n2 - 2; i23 >= 0; --i23) {
                for (i15 = 0; i15 < n1; ++i15) {
                    float[] fArray = y[i23];
                    int n = i15;
                    fArray[n] = fArray[n] + b * y[i23 + 1][i15];
                }
            }
            i16 = 0;
            while (i16 < n1) {
                float[] fArray = y[0];
                int n = i16++;
                fArray[n] = fArray[n] / ss;
            }
            for (i23 = 1; i23 < n2m1; ++i23) {
                for (i15 = 0; i15 < n1; ++i15) {
                    float[] fArray = y[i23];
                    int n = i15;
                    fArray[n] = fArray[n] + b * y[i23 - 1][i15];
                }
            }
            for (i16 = 0; i16 < n1; ++i16) {
                y[n2m1][i16] = yn2m1[i16];
            }
        } else if (ss > 0.0f && gg > 0.0f) {
            int i17;
            int i24;
            float[] yn2m1 = new float[n1];
            float oss = 1.0f / ss;
            float sum = 0.0f;
            for (i24 = 0; i24 < n2m1; ++i24) {
                for (i17 = 0; i17 < n1; ++i17) {
                    yn2m1[i17] = (yn2m1[i17] + ((float)i24 + oss) * y[i24][i17]) * b;
                }
            }
            int i18 = 0;
            while (i18 < n1) {
                int n = i18;
                yn2m1[n] = yn2m1[n] + ((float)n2m1 + oss) * y[n2m1][i18];
                int n3 = i18++;
                yn2m1[n3] = yn2m1[n3] / (1.0f + gg * (float)n2m1 + gg / ss);
            }
            for (i18 = 0; i18 < n1; ++i18) {
                float[] fArray = y[n2m1];
                int n = i18;
                fArray[n] = fArray[n] - gg * yn2m1[i18];
            }
            for (i24 = n2 - 2; i24 >= 0; --i24) {
                for (i17 = 0; i17 < n1; ++i17) {
                    float[] fArray = y[i24];
                    int n = i17;
                    fArray[n] = fArray[n] + b * y[i24 + 1][i17];
                }
            }
            i18 = 0;
            while (i18 < n1) {
                float[] fArray = y[0];
                int n = i18++;
                fArray[n] = fArray[n] / ss;
            }
            for (i24 = 1; i24 < n2m1; ++i24) {
                for (i17 = 0; i17 < n1; ++i17) {
                    float[] fArray = y[i24];
                    int n = i17;
                    fArray[n] = fArray[n] + b * y[i24 - 1][i17];
                }
            }
            for (i18 = 0; i18 < n1; ++i18) {
                y[n2 - 1][i18] = yn2m1[i18];
            }
        } else if (ss == 0.0f) {
            i1 = 0;
            while (i1 < n1) {
                float[] fArray = y[0];
                int n = i1++;
                fArray[n] = fArray[n] * -b;
            }
            for (i2 = 1; i2 < n2m1; ++i2) {
                for (i12 = 0; i12 < n1; ++i12) {
                    y[i2][i12] = b * (y[i2 - 1][i12] - y[i2][i12]);
                }
            }
            for (i1 = 0; i1 < n1; ++i1) {
                y[n2m1][i1] = (y[n2 - 1][i1] - y[n2 - 2][i1]) / gg;
            }
            for (i2 = n2 - 2; i2 >= 0; --i2) {
                for (i12 = 0; i12 < n1; ++i12) {
                    y[i2][i12] = b * (y[i2 + 1][i12] - y[i2][i12]);
                }
            }
        } else if (gg == 0.0f) {
            for (i2 = n2 - 2; i2 > 0; --i2) {
                for (i12 = 0; i12 < n1; ++i12) {
                    float[] fArray = y[i2];
                    int n = i12;
                    fArray[n] = fArray[n] + b * y[i2 + 1][i12];
                }
            }
            for (i1 = 0; i1 < n1; ++i1) {
                y[0][i1] = (y[0][i1] + b * y[1][i1]) / ss;
            }
            for (i2 = 1; i2 < n2; ++i2) {
                for (i12 = 0; i12 < n1; ++i12) {
                    float[] fArray = y[i2];
                    int n = i12;
                    fArray[n] = fArray[n] + b * y[i2 - 1][i12];
                }
            }
        } else {
            Check.state(false, "filter is invertible");
        }
    }

    public void applyInverse1(final float[][][] x, final float[][][] y) {
        int n = x.length;
        Parallel.loop(n, new Parallel.LoopInt(){

            @Override
            public void compute(int i) {
                SymmetricTridiagonalFilter.this.applyInverse1(x[i], y[i]);
            }
        });
    }

    public void applyInverse2(final float[][][] x, final float[][][] y) {
        int n = x.length;
        Parallel.loop(n, new Parallel.LoopInt(){

            @Override
            public void compute(int i) {
                SymmetricTridiagonalFilter.this.applyInverse2(x[i], y[i]);
            }
        });
    }

    public void applyInverse3(float[][][] x, float[][][] y) {
        int n2 = x[0].length;
        int n3 = x.length;
        float[][][] xt = new float[n2][n3][];
        float[][][] yt = new float[n2][n3][];
        for (int i2 = 0; i2 < n2; ++i2) {
            for (int i3 = 0; i3 < n3; ++i3) {
                xt[i2][i3] = x[i3][i2];
                yt[i2][i3] = y[i3][i2];
            }
        }
        this.applyInverse2(xt, yt);
    }

    private void checkInvertible() {
        Check.state(ArrayMath.abs(this._ai) >= 2.0 * ArrayMath.abs(this._b), "filter is invertible");
    }

    private static void trace(String s) {
        System.out.println(s);
    }

    public static void test1Simple() {
        SymmetricTridiagonalFilter.trace("test1Simple");
        int n = 5;
        double al = 0.75;
        double af = 0.75;
        double ai = 0.5;
        double b = 0.25;
        SymmetricTridiagonalFilter f = new SymmetricTridiagonalFilter(af, ai, al, b);
        float[] x = ArrayMath.zerofloat(n);
        float[] y = ArrayMath.zerofloat(n);
        float[] z = ArrayMath.zerofloat(n);
        ArrayMath.fill(1.0f, x);
        f.apply(x, y);
        f.applyInverse(y, z);
        SymmetricTridiagonalFilter.assertEqual(x, z);
    }

    public static void test2Simple() {
        SymmetricTridiagonalFilter.trace("test2Simple");
        int n1 = 5;
        int n2 = 4;
        double al = 0.75;
        double af = 0.75;
        double ai = 0.5;
        double b = 0.25;
        SymmetricTridiagonalFilter f = new SymmetricTridiagonalFilter(af, ai, al, b);
        float[][] x = ArrayMath.zerofloat(n1, n2);
        float[][] y = ArrayMath.zerofloat(n1, n2);
        float[][] z = ArrayMath.zerofloat(n1, n2);
        ArrayMath.fill(1.0f, x);
        f.apply1(x, y);
        f.apply2(y, y);
        f.applyInverse1(y, z);
        f.applyInverse2(z, z);
        SymmetricTridiagonalFilter.assertEqual(x, z);
    }

    public static void test3Simple() {
        SymmetricTridiagonalFilter.trace("test3Simple");
        int n1 = 11;
        int n2 = 12;
        int n3 = 13;
        float[][][] r = ArrayMath.randfloat(n1, n2, n3);
        float[][][] x = ArrayMath.copy(r);
        float[][][] y = ArrayMath.copy(r);
        SymmetricTridiagonalFilter stf = new SymmetricTridiagonalFilter(2.6, 2.5, 2.7, 1.2);
        stf.apply1(x, x);
        stf.apply2(x, x);
        stf.apply3(x, x);
        stf.apply1(y, y);
        y = SymmetricTridiagonalFilter.transpose12(y);
        stf.apply1(y, y);
        y = SymmetricTridiagonalFilter.transpose12(y);
        y = SymmetricTridiagonalFilter.transpose23(y);
        stf.apply2(y, y);
        y = SymmetricTridiagonalFilter.transpose23(y);
        SymmetricTridiagonalFilter.assertEqual(x, y);
    }

    private static float[][][] transpose12(float[][][] x) {
        int n1 = x[0][0].length;
        int n2 = x[0].length;
        int n3 = x.length;
        float[][][] y = new float[n3][n1][n2];
        for (int i3 = 0; i3 < n3; ++i3) {
            for (int i2 = 0; i2 < n2; ++i2) {
                for (int i1 = 0; i1 < n1; ++i1) {
                    y[i3][i1][i2] = x[i3][i2][i1];
                }
            }
        }
        return y;
    }

    private static float[][][] transpose23(float[][][] x) {
        int n1 = x[0][0].length;
        int n2 = x[0].length;
        int n3 = x.length;
        float[][][] y = new float[n2][n3][n1];
        for (int i3 = 0; i3 < n3; ++i3) {
            for (int i2 = 0; i2 < n2; ++i2) {
                for (int i1 = 0; i1 < n1; ++i1) {
                    y[i2][i3][i1] = x[i3][i2][i1];
                }
            }
        }
        return y;
    }

    private static SymmetricTridiagonalFilter makeRandomFilter() {
        Random r = new Random();
        boolean aeq2b = r.nextBoolean();
        boolean abneg = r.nextBoolean();
        boolean afzs = r.nextBoolean();
        boolean alzs = r.nextBoolean();
        if (aeq2b && afzs && alzs) {
            if (r.nextBoolean()) {
                afzs = false;
            } else {
                alzs = false;
            }
        }
        float b = r.nextFloat();
        float ai = 2.0f * b;
        if (!aeq2b) {
            ai = (float)((double)ai + ArrayMath.max(0.001, (double)r.nextFloat()) * (double)b);
        }
        if (abneg) {
            ai = -ai;
        }
        float af = ai;
        float al = ai;
        if (afzs) {
            af = ai + b;
        }
        if (alzs) {
            al = ai + b;
        }
        return new SymmetricTridiagonalFilter(af, ai, al, b);
    }

    public static void test1Random() {
        SymmetricTridiagonalFilter.trace("test1Random");
        Random r = new Random();
        int ntest = 1000;
        for (int itest = 0; itest < ntest; ++itest) {
            SymmetricTridiagonalFilter stf = SymmetricTridiagonalFilter.makeRandomFilter();
            boolean inplace = r.nextBoolean();
            int n = 2 + r.nextInt(10);
            float[] t = ArrayMath.randfloat(r, n);
            float[] x = ArrayMath.copy(t);
            float[] y = inplace ? x : ArrayMath.zerofloat(n);
            float[] z = inplace ? x : ArrayMath.zerofloat(n);
            stf.apply(x, y);
            stf.applyInverse(y, z);
            SymmetricTridiagonalFilter.assertEqual(t, x);
            SymmetricTridiagonalFilter.assertEqual(t, z);
        }
    }

    public static void test2Random() {
        SymmetricTridiagonalFilter.trace("test2Random");
        Random r = new Random();
        int ntest = 1000;
        for (int itest = 0; itest < ntest; ++itest) {
            SymmetricTridiagonalFilter stf = SymmetricTridiagonalFilter.makeRandomFilter();
            boolean inplace = r.nextBoolean();
            int n1 = 2 + r.nextInt(11);
            int n2 = 2 + r.nextInt(12);
            float[][] t = ArrayMath.randfloat(r, n1, n2);
            float[][] x = ArrayMath.copy(t);
            float[][] y = inplace ? x : ArrayMath.zerofloat(n1, n2);
            float[][] z = inplace ? x : ArrayMath.zerofloat(n1, n2);
            stf.apply1(x, y);
            stf.applyInverse1(y, z);
            SymmetricTridiagonalFilter.assertEqual(t, x);
            SymmetricTridiagonalFilter.assertEqual(t, z);
            stf.apply2(x, y);
            stf.applyInverse2(y, z);
            SymmetricTridiagonalFilter.assertEqual(t, x);
            SymmetricTridiagonalFilter.assertEqual(t, z);
        }
    }

    public static void test3Random() {
        SymmetricTridiagonalFilter.trace("test3Random");
        Random r = new Random();
        int ntest = 1000;
        for (int itest = 0; itest < ntest; ++itest) {
            SymmetricTridiagonalFilter stf = SymmetricTridiagonalFilter.makeRandomFilter();
            boolean inplace = r.nextBoolean();
            int n1 = 2 + r.nextInt(11);
            int n2 = 2 + r.nextInt(12);
            int n3 = 2 + r.nextInt(13);
            float[][][] t = ArrayMath.randfloat(r, n1, n2, n3);
            float[][][] x = ArrayMath.copy(t);
            float[][][] y = inplace ? x : ArrayMath.zerofloat(n1, n2, n3);
            float[][][] z = inplace ? x : ArrayMath.zerofloat(n1, n2, n3);
            stf.apply1(x, y);
            stf.applyInverse1(y, z);
            SymmetricTridiagonalFilter.assertEqual(t, x);
            SymmetricTridiagonalFilter.assertEqual(t, z);
            stf.apply2(x, y);
            stf.applyInverse2(y, z);
            SymmetricTridiagonalFilter.assertEqual(t, x);
            SymmetricTridiagonalFilter.assertEqual(t, z);
            stf.apply3(x, y);
            stf.applyInverse3(y, z);
            SymmetricTridiagonalFilter.assertEqual(t, x);
            SymmetricTridiagonalFilter.assertEqual(t, z);
        }
    }

    private static void assertEqual(float[] e, float[] a) {
        float tol = 0.001f * ArrayMath.max(ArrayMath.abs(e));
        SymmetricTridiagonalFilter.assertEqual(e, a, tol);
    }

    private static void assertEqual(float[][] e, float[][] a) {
        float tol = 0.001f * ArrayMath.max(ArrayMath.abs(e));
        SymmetricTridiagonalFilter.assertEqual(e, a, tol);
    }

    private static void assertEqual(float[][][] e, float[][][] a) {
        float tol = 0.001f * ArrayMath.max(ArrayMath.abs(e));
        SymmetricTridiagonalFilter.assertEqual(e, a, tol);
    }

    private static void assertEqual(float[] e, float[] a, float tol) {
        int n = e.length;
        for (int i = 0; i < n; ++i) {
            float error = ArrayMath.abs(e[i] - a[i]);
            if (error > tol) {
                SymmetricTridiagonalFilter.trace("expected=" + e[i] + " actual=" + a[i]);
            }
            assert (error < tol);
        }
    }

    private static void assertEqual(float[][] e, float[][] a, float tol) {
        int n = e.length;
        for (int i = 0; i < n; ++i) {
            SymmetricTridiagonalFilter.assertEqual(e[i], a[i], tol);
        }
    }

    private static void assertEqual(float[][][] e, float[][][] a, float tol) {
        int n = e.length;
        for (int i = 0; i < n; ++i) {
            SymmetricTridiagonalFilter.assertEqual(e[i], a[i], tol);
        }
    }

    public static void main(String[] args) {
        SymmetricTridiagonalFilter.test1Simple();
        SymmetricTridiagonalFilter.test2Simple();
        SymmetricTridiagonalFilter.test3Simple();
        SymmetricTridiagonalFilter.test1Random();
        SymmetricTridiagonalFilter.test2Random();
        SymmetricTridiagonalFilter.test3Random();
    }
}

