/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.img.imageplus;

import net.imglib2.Dimensions;
import net.imglib2.exception.IncompatibleTypeException;
import net.imglib2.img.ImgFactory;
import net.imglib2.img.NativeImg;
import net.imglib2.img.NativeImgFactory;
import net.imglib2.img.basictypeaccess.array.ByteArray;
import net.imglib2.img.basictypeaccess.array.CharArray;
import net.imglib2.img.basictypeaccess.array.DoubleArray;
import net.imglib2.img.basictypeaccess.array.FloatArray;
import net.imglib2.img.basictypeaccess.array.IntArray;
import net.imglib2.img.basictypeaccess.array.LongArray;
import net.imglib2.img.basictypeaccess.array.ShortArray;
import net.imglib2.img.imageplus.ByteImagePlus;
import net.imglib2.img.imageplus.FloatImagePlus;
import net.imglib2.img.imageplus.ImagePlusImg;
import net.imglib2.img.imageplus.IntImagePlus;
import net.imglib2.img.imageplus.ShortImagePlus;
import net.imglib2.img.planar.PlanarImgFactory;
import net.imglib2.type.NativeType;
import net.imglib2.util.Fraction;

public class ImagePlusImgFactory<T extends NativeType<T>>
extends PlanarImgFactory<T> {
    public ImagePlusImg<T, ?> create(long[] dim, T type) {
        return (ImagePlusImg)type.createSuitableNativeImg((NativeImgFactory)this, dim);
    }

    public ImagePlusImg<T, ?> create(Dimensions dim, T type) {
        long[] size = new long[dim.numDimensions()];
        dim.dimensions(size);
        return this.create(size, (NativeType)type);
    }

    public NativeImg<T, ByteArray> createByteInstance(long[] dimensions, Fraction entitiesPerPixel) {
        if (dimensions.length > 5) {
            throw new RuntimeException("Unsupported dimensionality: " + dimensions.length);
        }
        return new ByteImagePlus(dimensions, entitiesPerPixel);
    }

    public NativeImg<T, CharArray> createCharInstance(long[] dimensions, Fraction entitiesPerPixel) {
        if (dimensions.length > 5) {
            throw new RuntimeException("Unsupported dimensionality: " + dimensions.length);
        }
        return new ImagePlusImg(new CharArray(1), dimensions, entitiesPerPixel);
    }

    public NativeImg<T, DoubleArray> createDoubleInstance(long[] dimensions, Fraction entitiesPerPixel) {
        if (dimensions.length > 5) {
            throw new RuntimeException("Unsupported dimensionality: " + dimensions.length);
        }
        return new ImagePlusImg(new DoubleArray(1), dimensions, entitiesPerPixel);
    }

    public NativeImg<T, FloatArray> createFloatInstance(long[] dimensions, Fraction entitiesPerPixel) {
        if (dimensions.length > 5) {
            throw new RuntimeException("Unsupported dimensionality: " + dimensions.length);
        }
        return new FloatImagePlus(dimensions, entitiesPerPixel);
    }

    public NativeImg<T, IntArray> createIntInstance(long[] dimensions, Fraction entitiesPerPixel) {
        if (dimensions.length > 5) {
            throw new RuntimeException("Unsupported dimensionality: " + dimensions.length);
        }
        return new IntImagePlus(dimensions, entitiesPerPixel);
    }

    public NativeImg<T, LongArray> createLongInstance(long[] dimensions, Fraction entitiesPerPixel) {
        if (dimensions.length > 5) {
            throw new RuntimeException("Unsupported dimensionality: " + dimensions.length);
        }
        return new ImagePlusImg(new LongArray(1), dimensions, entitiesPerPixel);
    }

    public NativeImg<T, ShortArray> createShortInstance(long[] dimensions, Fraction entitiesPerPixel) {
        if (dimensions.length > 5) {
            throw new RuntimeException("Unsupported dimensionality: " + dimensions.length);
        }
        return new ShortImagePlus(dimensions, entitiesPerPixel);
    }

    public <S> ImgFactory<S> imgFactory(S type) throws IncompatibleTypeException {
        if (NativeType.class.isInstance(type)) {
            return new ImagePlusImgFactory<T>();
        }
        throw new IncompatibleTypeException((Object)this, type.getClass().getCanonicalName() + " does not implement NativeType.");
    }
}

