/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.img.display.imagej;

import ij.VirtualStack;
import ij.process.ByteProcessor;
import ij.process.ColorProcessor;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import ij.process.ShortProcessor;
import net.imglib2.Cursor;
import net.imglib2.Interval;
import net.imglib2.RandomAccessible;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.converter.Converter;
import net.imglib2.display.projector.IterableIntervalProjector2D;
import net.imglib2.img.array.ArrayCursor;
import net.imglib2.img.array.ArrayImg;
import net.imglib2.img.array.ArrayImgFactory;
import net.imglib2.img.basictypeaccess.array.ArrayDataAccess;
import net.imglib2.type.NativeType;
import net.imglib2.type.numeric.RealType;
import net.imglib2.util.IntervalIndexer;
import net.imglib2.view.IntervalView;
import net.imglib2.view.Views;

public abstract class ImageJVirtualStack<S, T extends NativeType<T>>
extends VirtualStack {
    private final IterableIntervalProjector2D<S, T> projector;
    private final int size;
    private final int numDimensions;
    private final long[] higherSourceDimensions;
    private final int bitDepth;
    private final RandomAccessibleInterval<S> source;
    private final ArrayImg<T, ?> img;
    protected final ImageProcessor imageProcessor;
    private boolean isWritable = false;

    protected ImageJVirtualStack(RandomAccessibleInterval<S> source, Converter<S, T> converter, T type, int ijtype) {
        super((int)source.dimension(0), ImageJVirtualStack.getDimension1Size(source), null, null);
        this.source = source;
        assert (source.numDimensions() > 1);
        int tmpsize = 1;
        for (int d = 2; d < source.numDimensions(); ++d) {
            tmpsize *= (int)source.dimension(d);
        }
        this.size = tmpsize;
        int sizeX = (int)source.dimension(0);
        int sizeY = ImageJVirtualStack.getDimension1Size(source);
        this.img = new ArrayImgFactory().create(new long[]{sizeX, sizeY}, type);
        this.higherSourceDimensions = new long[3];
        this.higherSourceDimensions[0] = source.numDimensions() > 2 ? source.dimension(2) : 1L;
        this.higherSourceDimensions[1] = source.numDimensions() > 3 ? source.dimension(3) : 1L;
        this.higherSourceDimensions[2] = source.numDimensions() > 4 ? source.dimension(4) : 1L;
        this.numDimensions = source.numDimensions();
        this.projector = new IterableIntervalProjector2D(0, 1, (RandomAccessible)(Views.isZeroMin(source) ? source : Views.zeroMin(source)), this.img, converter);
        switch (ijtype) {
            case 0: {
                this.bitDepth = 8;
                this.imageProcessor = new ByteProcessor(sizeX, sizeY, (byte[])((ArrayDataAccess)this.img.update(null)).getCurrentStorageArray(), null);
                break;
            }
            case 1: {
                this.bitDepth = 16;
                this.imageProcessor = new ShortProcessor(sizeX, sizeY, (short[])((ArrayDataAccess)this.img.update(null)).getCurrentStorageArray(), null);
                break;
            }
            case 4: {
                this.bitDepth = 24;
                this.imageProcessor = new ColorProcessor(sizeX, sizeY, (int[])((ArrayDataAccess)this.img.update(null)).getCurrentStorageArray());
                break;
            }
            case 2: {
                this.bitDepth = 32;
                this.imageProcessor = new FloatProcessor(sizeX, sizeY, (float[])((ArrayDataAccess)this.img.update(null)).getCurrentStorageArray(), null);
                break;
            }
            default: {
                throw new IllegalArgumentException("unsupported color type " + ijtype);
            }
        }
    }

    protected static int getDimension1Size(Interval interval) {
        if (interval.numDimensions() == 1) {
            return 1;
        }
        return (int)interval.dimension(1);
    }

    public void setWritable(boolean writable) {
        this.isWritable = writable;
    }

    public boolean isWritable() {
        return this.isWritable;
    }

    public ImageProcessor getProcessor(int n) {
        if (this.numDimensions > 2) {
            int[] position = new int[3];
            IntervalIndexer.indexToPosition((long)(n - 1), (long[])this.higherSourceDimensions, (int[])position);
            this.projector.setPosition(position[0], 2);
            if (this.numDimensions > 3) {
                this.projector.setPosition(position[1], 3);
            }
            if (this.numDimensions > 4) {
                this.projector.setPosition(position[2], 4);
            }
        }
        this.projector.map();
        return this.imageProcessor;
    }

    public int getBitDepth() {
        return this.bitDepth;
    }

    public void addUnsignedShortSlice(String sliceLabel, Object pixels) {
    }

    public void addSlice(String sliceLabel, ImageProcessor ip) {
    }

    public void addSlice(String sliceLabel, ImageProcessor ip, int n) {
    }

    public void deleteSlice(int n) {
    }

    public void deleteLastSlice() {
    }

    public void update(ImageProcessor ip) {
    }

    public Object getPixels(int n) {
        return this.getProcessor(n).getPixels();
    }

    public void setPixels(Object pixels, int n) {
        if (this.isWritable()) {
            if (!(this.source.randomAccess().get() instanceof RealType) || !(this.img.firstElement() instanceof RealType)) {
                return;
            }
            IntervalView origin = this.source;
            if (this.numDimensions > 2) {
                int[] position = new int[3];
                IntervalIndexer.indexToPosition((long)(n - 1), (long[])this.higherSourceDimensions, (int[])position);
                origin = Views.hyperSlice(this.source, (int)2, (long)position[0]);
                if (this.numDimensions > 3) {
                    origin = Views.hyperSlice((RandomAccessibleInterval)origin, (int)2, (long)position[1]);
                }
                if (this.numDimensions > 4) {
                    origin = Views.hyperSlice((RandomAccessibleInterval)origin, (int)2, (long)position[2]);
                }
            }
            Cursor originCursor = Views.iterable(origin).cursor();
            ArrayCursor cursor = this.img.cursor();
            while (originCursor.hasNext()) {
                ((RealType)originCursor.next()).setReal(((RealType)cursor.next()).getRealDouble());
            }
        }
    }

    public Object[] getImageArray() {
        return null;
    }

    public String[] getSliceLabels() {
        return null;
    }

    public String getSliceLabel(int n) {
        return "" + n;
    }

    public String getShortSliceLabel(int n) {
        return this.getSliceLabel(n);
    }

    public void setSliceLabel(String label, int n) {
    }

    public boolean isRGB() {
        return false;
    }

    public boolean isHSB() {
        return false;
    }

    public boolean isVirtual() {
        return true;
    }

    public void trim() {
    }

    public int getSize() {
        return this.size;
    }

    public void setBitDepth(int bitDepth) {
    }

    public String getDirectory() {
        return null;
    }

    public String getFileName(int n) {
        return null;
    }
}

