/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beaker.jvm.serialization;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twosigma.beaker.jvm.serialization.BeakerObjectConverter;
import com.twosigma.beaker.jvm.serialization.ObjectDeserializer;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import javax.imageio.ImageIO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BufferedImageDeserializer
implements ObjectDeserializer {
    private static final Logger logger = LoggerFactory.getLogger((String)BufferedImageDeserializer.class.getName());

    public BufferedImageDeserializer(BeakerObjectConverter p) {
        p.addKnownBeakerType("ImageIcon");
    }

    @Override
    public boolean canBeUsed(JsonNode n) {
        return n.has("type") && n.get("type").asText().equals("ImageIcon");
    }

    @Override
    public Object deserialize(JsonNode n, ObjectMapper mapper) {
        BufferedImage o = null;
        try {
            if (n.has("imageData")) {
                byte[] data = n.get("imageData").binaryValue();
                ByteArrayInputStream bais = new ByteArrayInputStream(data);
                o = ImageIO.read(bais);
            }
        }
        catch (Exception e) {
            logger.error("exception deserializing ImageIcon ", (Throwable)e);
        }
        return o;
    }
}

