/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beaker.easyform;

import com.twosigma.beaker.easyform.formitem.EasyFormListener;
import com.twosigma.beaker.widgets.DOMWidget;
import java.util.LinkedList;
import java.util.List;

public abstract class EasyFormComponent<T extends DOMWidget> {
    private boolean enabled = true;
    private List<EasyFormListener> onChangeListeners = new LinkedList<EasyFormListener>();
    private List<EasyFormListener> onInitListeners = new LinkedList<EasyFormListener>();

    public abstract T getWidget();

    public abstract String getLabel();

    public abstract void setLabel(String var1);

    public abstract String getValue();

    public abstract void setValue(String var1);

    public void fireInit() {
        for (EasyFormListener listener : this.onInitListeners) {
            listener.execute(this.getValue());
        }
    }

    public EasyFormComponent onInit(EasyFormListener listener) {
        this.addOnInitListener(listener);
        return this;
    }

    public void addOnInitListener(EasyFormListener listener) {
        if (listener != null) {
            this.onInitListeners.add(listener);
        }
    }

    public void removeOnInitListener(EasyFormListener listener) {
        if (this.onInitListeners.contains(listener)) {
            this.onInitListeners.remove(listener);
        }
    }

    public EasyFormComponent onChange(EasyFormListener listener) {
        this.addOnChangeListener(listener);
        return this;
    }

    public void fireChanged() {
        for (EasyFormListener listener : this.onChangeListeners) {
            listener.execute(this.getValue());
        }
    }

    public void addOnChangeListener(EasyFormListener listener) {
        if (listener != null) {
            this.onChangeListeners.add(listener);
        }
    }

    public void removeOnChangeListener(EasyFormListener listener) {
        if (this.onChangeListeners.contains(listener)) {
            this.onChangeListeners.remove(listener);
        }
    }

    public void clearListeners() {
        this.onChangeListeners.clear();
        this.onInitListeners.clear();
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public String formatValue(Object value) {
        return (String)String.class.cast(value);
    }

    protected boolean checkValue(Object value) {
        return true;
    }

    public boolean isButton() {
        return false;
    }
}

