/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.plugins.scripting.beanshell;

import bsh.EvalError;
import bsh.Interpreter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.io.Writer;
import javax.script.ScriptContext;
import javax.script.ScriptException;
import org.scijava.plugins.scripting.beanshell.BeanshellBindings;
import org.scijava.script.AbstractScriptEngine;
import org.scijava.util.LineOutputStream;

public class BeanshellScriptEngine
extends AbstractScriptEngine {
    protected final Interpreter interpreter = new Interpreter();

    public BeanshellScriptEngine() {
        this.engineScopeBindings = new BeanshellBindings(this.interpreter);
    }

    public Object eval(String script) throws ScriptException {
        this.setup();
        try {
            return this.interpreter.eval(script);
        }
        catch (EvalError e) {
            throw new ScriptException((Exception)((Object)e));
        }
    }

    public Object eval(Reader reader) throws ScriptException {
        this.setup();
        try {
            String filename = (String)this.get("javax.script.filename");
            return this.interpreter.eval(reader, this.interpreter.getNameSpace(), filename);
        }
        catch (EvalError e) {
            throw new ScriptException((Exception)((Object)e));
        }
    }

    protected void setup() {
        Writer errorWriter;
        Writer writer;
        ScriptContext context = this.getContext();
        Reader reader = context.getReader();
        if (reader != null) {
            this.log().warn((Object)"Beanshell does not support redirecting the input");
        }
        if ((writer = context.getWriter()) != null) {
            this.interpreter.setOut(new PrintStream((OutputStream)((Object)new WriterOutputStream(writer))));
        }
        if ((errorWriter = context.getErrorWriter()) != null) {
            this.interpreter.setErr(new PrintStream((OutputStream)((Object)new WriterOutputStream(errorWriter))));
        }
    }

    private static class WriterOutputStream
    extends LineOutputStream {
        private Writer writer;

        public WriterOutputStream(Writer writer) {
            this.writer = writer;
        }

        public void println(String line) throws IOException {
            this.writer.write(line);
            this.writer.write(10);
        }
    }
}

