/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.realtransform;

import net.imglib2.RealLocalizable;
import net.imglib2.RealPositionable;
import net.imglib2.realtransform.AbstractRealTransformSequence;
import net.imglib2.realtransform.InverseRealTransform;
import net.imglib2.realtransform.InvertibleRealTransform;

public class InvertibleRealTransformSequence
extends AbstractRealTransformSequence<InvertibleRealTransform>
implements InvertibleRealTransform {
    @Override
    public void applyInverse(double[] source, double[] target) {
        assert (source.length >= this.nSource && target.length >= this.nTarget) : "Input dimensions too small.";
        int s = this.transforms.size() - 1;
        if (s > -1) {
            if (s > 0) {
                ((InvertibleRealTransform)this.transforms.get(s)).applyInverse(this.tmp, target);
                for (int i = s - 1; i > 0; --i) {
                    ((InvertibleRealTransform)this.transforms.get(i)).applyInverse(this.tmp, this.tmp);
                }
                ((InvertibleRealTransform)this.transforms.get(0)).applyInverse(source, this.tmp);
            } else {
                ((InvertibleRealTransform)this.transforms.get(0)).applyInverse(source, target);
            }
        }
    }

    @Override
    public void applyInverse(float[] source, float[] target) {
        assert (source.length >= this.nSource && target.length >= this.nTarget) : "Input dimensions too small.";
        int s = this.transforms.size() - 1;
        if (s > -1) {
            int d;
            for (d = 0; d < this.nTarget; ++d) {
                this.tmp[d] = target[d];
            }
            for (int i = s; i > -1; --i) {
                ((InvertibleRealTransform)this.transforms.get(i)).applyInverse(this.tmp, this.tmp);
            }
            for (d = 0; d < this.nSource; ++d) {
                source[d] = (float)this.tmp[d];
            }
        }
    }

    @Override
    public void applyInverse(RealPositionable source, RealLocalizable target) {
        assert (source.numDimensions() >= this.nSource && target.numDimensions() >= this.nTarget) : "Input dimensions too small.";
        int s = this.transforms.size() - 1;
        if (s > -1) {
            if (s > 0) {
                ((InvertibleRealTransform)this.transforms.get(s)).applyInverse((RealPositionable)this.ptmp, target);
                for (int i = s - 1; i > 0; --i) {
                    ((InvertibleRealTransform)this.transforms.get(i)).applyInverse(this.tmp, this.tmp);
                }
                ((InvertibleRealTransform)this.transforms.get(0)).applyInverse(source, (RealLocalizable)this.ptmp);
            } else {
                ((InvertibleRealTransform)this.transforms.get(0)).applyInverse(source, target);
            }
        }
    }

    @Override
    public InvertibleRealTransform inverse() {
        return new InverseRealTransform(this);
    }

    @Override
    public InvertibleRealTransformSequence copy() {
        InvertibleRealTransformSequence copy = new InvertibleRealTransformSequence();
        for (InvertibleRealTransform t : this.transforms) {
            copy.add(t.copy());
        }
        return copy;
    }
}

