/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.realtransform;

import Jama.Matrix;
import net.imglib2.RealLocalizable;
import net.imglib2.RealPositionable;
import net.imglib2.concatenate.Concatenable;
import net.imglib2.concatenate.PreConcatenable;
import net.imglib2.realtransform.AbstractAffineTransform;
import net.imglib2.realtransform.AffineGet;

public class AffineTransform
extends AbstractAffineTransform
implements Concatenable<AffineGet>,
PreConcatenable<AffineGet> {
    protected final AffineTransform inverse;

    public AffineTransform(int n) {
        super(n);
        this.inverse = new AffineTransform(this);
        this.invert();
        this.inverse.updateDs();
    }

    protected AffineTransform(Matrix a, double[] t) {
        super(a, t);
        this.inverse = new AffineTransform(this);
        this.invert();
        this.inverse.updateDs();
    }

    public AffineTransform(Matrix matrix) {
        super(matrix);
        this.inverse = new AffineTransform(this);
        this.invert();
        this.inverse.updateDs();
    }

    protected AffineTransform(AffineTransform inverse) {
        super(inverse.n);
        this.inverse = inverse;
    }

    protected void invertT() {
        for (int r = 0; r < this.n; ++r) {
            double tir = -this.inverse.a.get(r, 0) * this.t[0];
            for (int c = 1; c < this.n; ++c) {
                tir -= this.inverse.a.get(r, c) * this.t[c];
            }
            this.inverse.t[r] = tir;
        }
    }

    protected void invert() {
        Matrix ii = this.a.inverse();
        this.inverse.a.setMatrix(0, this.n - 1, 0, this.n - 1, ii);
        this.invertT();
    }

    @Override
    public void applyInverse(double[] source, double[] target) {
        assert (source.length >= this.n && target.length >= this.n) : "Source or target vector dimensions do not match with the transformation.";
        this.inverse.apply(target, source);
    }

    @Override
    public void applyInverse(float[] source, float[] target) {
        assert (source.length >= this.n && target.length >= this.n) : "Source or target vector dimensions do not match with the transformation.";
        this.inverse.apply(target, source);
    }

    @Override
    public void applyInverse(RealPositionable source, RealLocalizable target) {
        assert (source.numDimensions() >= this.n && target.numDimensions() >= this.n) : "Source or target vector dimensions do not match with the transformation.";
        this.inverse.apply(target, source);
    }

    @Override
    public AffineTransform inverse() {
        return this.inverse;
    }

    public void set(AffineGet affine) {
        assert (this.n == affine.numSourceDimensions()) : "Dimensions do not match.";
        for (int r = 0; r < this.n; ++r) {
            for (int c = 0; c < this.n; ++c) {
                this.a.set(r, c, affine.get(r, c));
            }
            this.t[r] = affine.get(r, this.n);
        }
        this.updateDs();
        this.invert();
        this.inverse.updateDs();
    }

    @Override
    public void set(double[][] affine) {
        assert (this.n == affine.length) : "Dimensions do not match.";
        for (int r = 0; r < this.n; ++r) {
            assert (this.n + 1 == affine[r].length) : "Dimensions do not match.";
            for (int c = 0; c < this.n; ++c) {
                this.a.set(r, c, affine[r][c]);
            }
            this.t[r] = affine[r][this.n];
        }
        this.updateDs();
        this.invert();
        this.inverse.updateDs();
    }

    public AffineTransform concatenate(AffineGet affine) {
        assert (affine.numSourceDimensions() == this.n) : "Dimensions do not match.";
        Matrix matrix = new Matrix(this.n, this.n);
        double[] translation = new double[this.n];
        for (int r = 0; r < this.n; ++r) {
            for (int c = 0; c < this.n; ++c) {
                double ar = this.get(r, 0) * affine.get(0, c);
                for (int k = 1; k < this.n; ++k) {
                    ar += this.get(r, k) * affine.get(k, c);
                }
                matrix.set(r, c, ar);
            }
            double tr = this.get(r, this.n) + this.get(r, 0) * affine.get(0, this.n);
            for (int k = 1; k < this.n; ++k) {
                tr += this.get(r, k) * affine.get(k, this.n);
            }
            translation[r] = tr;
        }
        this.a.setMatrix(0, this.n - 1, 0, this.n - 1, matrix);
        System.arraycopy(translation, 0, this.t, 0, this.t.length);
        this.updateDs();
        this.invert();
        this.inverse.updateDs();
        return this;
    }

    public Class<AffineGet> getConcatenableClass() {
        return AffineGet.class;
    }

    public AffineTransform preConcatenate(AffineGet affine) {
        assert (affine.numSourceDimensions() == this.n) : "Dimensions do not match.";
        Matrix matrix = new Matrix(this.n, this.n);
        double[] translation = new double[this.n];
        for (int r = 0; r < this.n; ++r) {
            for (int c = 0; c < this.n; ++c) {
                double ar = affine.get(r, 0) * this.get(0, c);
                for (int k = 1; k < this.n; ++k) {
                    ar += affine.get(r, k) * this.get(k, c);
                }
                matrix.set(r, c, ar);
            }
            double tr = affine.get(r, this.n) + affine.get(r, 0) * this.get(0, this.n);
            for (int k = 1; k < this.n; ++k) {
                tr += affine.get(r, k) * this.get(k, this.n);
            }
            translation[r] = tr;
        }
        this.a.setMatrix(0, this.n - 1, 0, this.n - 1, matrix);
        System.arraycopy(translation, 0, this.t, 0, this.t.length);
        this.updateDs();
        this.invert();
        this.inverse.updateDs();
        return this;
    }

    public Class<AffineGet> getPreConcatenableClass() {
        return AffineGet.class;
    }

    @Override
    public void set(double value, int row, int column) {
        if (column == this.n) {
            this.t[row] = value;
        } else {
            this.a.set(row, column, value);
        }
        this.updateDs();
        this.invert();
        this.inverse.updateDs();
    }

    @Override
    public void set(double ... values) {
        assert (values.length == this.n * this.n + this.n) : "Input dimensions do not match dimensions of this affine transform.";
        int i = 0;
        for (int r = 0; r < this.n; ++r) {
            int c = 0;
            while (c < this.n) {
                this.a.set(r, c, values[i]);
                ++c;
                ++i;
            }
            this.t[r] = values[i++];
        }
        this.updateDs();
        this.invert();
        this.inverse.updateDs();
    }

    @Override
    public AffineTransform copy() {
        AffineTransform copy = new AffineTransform(this.n);
        copy.set(this);
        return copy;
    }
}

