/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import org.jruby.CompatVersion;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyMethod;
import org.jruby.RubyModule;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.runtime.Block;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

@JRubyClass(name={"UnboundMethod"}, parent="Method")
public class RubyUnboundMethod
extends RubyMethod {
    protected RubyUnboundMethod(Ruby runtime) {
        super(runtime, runtime.getUnboundMethod());
    }

    public static RubyUnboundMethod newUnboundMethod(RubyModule implementationModule, String methodName, RubyModule originModule, String originName, DynamicMethod method2) {
        RubyUnboundMethod newMethod = new RubyUnboundMethod(implementationModule.getRuntime());
        newMethod.implementationModule = implementationModule;
        newMethod.methodName = methodName;
        newMethod.originModule = originModule;
        newMethod.originName = originName;
        newMethod.method = method2;
        return newMethod;
    }

    public static RubyClass defineUnboundMethodClass(Ruby runtime) {
        RubyClass newClass = runtime.defineClass("UnboundMethod", runtime.getMethod(), ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR);
        runtime.setUnboundMethod(newClass);
        newClass.index = 36;
        newClass.setReifiedClass(RubyUnboundMethod.class);
        newClass.defineAnnotatedMethods(RubyUnboundMethod.class);
        return newClass;
    }

    @Override
    @JRubyMethod(name={"call", "[]"}, rest=true)
    public IRubyObject call(ThreadContext context, IRubyObject[] args2, Block block) {
        throw context.runtime.newTypeError("you cannot call unbound method; bind first");
    }

    @Override
    @JRubyMethod
    public RubyUnboundMethod unbind() {
        return this;
    }

    @JRubyMethod
    public RubyMethod bind(ThreadContext context, IRubyObject aReceiver) {
        RubyClass receiverClass = aReceiver.getMetaClass();
        receiverClass.checkValidBindTargetFrom(context, this.originModule);
        return RubyMethod.newMethod(this.implementationModule, this.methodName, receiverClass, this.originName, this.method, aReceiver);
    }

    @Override
    @JRubyMethod(name={"clone"})
    public RubyMethod rbClone() {
        return RubyUnboundMethod.newUnboundMethod(this.implementationModule, this.methodName, this.originModule, this.originName, this.method);
    }

    @Override
    @JRubyMethod
    public IRubyObject to_proc(ThreadContext context, Block unusedBlock) {
        return super.to_proc(context, unusedBlock);
    }

    @Override
    @JRubyMethod(compat=CompatVersion.RUBY1_8)
    public IRubyObject name(ThreadContext context) {
        return context.runtime.newString(this.methodName);
    }

    @Override
    @JRubyMethod(name={"name"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject name19(ThreadContext context) {
        return context.runtime.newSymbol(this.methodName);
    }

    @Override
    @JRubyMethod(name={"owner"})
    public IRubyObject owner(ThreadContext context) {
        return this.implementationModule;
    }
}

