/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.roi.labeling;

import gnu.trove.list.array.TIntArrayList;
import java.util.ArrayList;
import net.imglib2.AbstractLocalizable;
import net.imglib2.Interval;
import net.imglib2.Localizable;
import net.imglib2.Positionable;
import net.imglib2.RandomAccess;
import net.imglib2.RealLocalizable;
import net.imglib2.RealPoint;
import net.imglib2.RealPositionable;
import net.imglib2.outofbounds.OutOfBoundsConstantValue;
import net.imglib2.roi.PositionableIterableRegion;
import net.imglib2.roi.labeling.LabelRegionCursor;
import net.imglib2.roi.labeling.LabelRegionRandomAccess;
import net.imglib2.roi.labeling.LabelRegions;
import net.imglib2.type.Type;
import net.imglib2.type.logic.BoolType;
import net.imglib2.util.Intervals;

public class LabelRegion<T>
extends AbstractLocalizable
implements PositionableIterableRegion<BoolType> {
    final LabelRegions<T> regions;
    private final LabelRegions.LabelRegionProperties regionProperties;
    private final T label;
    private final ArrayList<TIntArrayList> itcodes;
    private final long[] currentOffset;
    private final long[] currentMin;
    private final long[] currentMax;
    private long size;
    private final RealPoint centerOfMass;
    private final Origin origin;
    private int expectedGeneration;

    public LabelRegion(LabelRegions<T> regions, LabelRegions.LabelRegionProperties regionProperties, T label) {
        super(regions.numDimensions());
        this.regions = regions;
        this.regionProperties = regionProperties;
        this.label = label;
        this.expectedGeneration = regionProperties.update();
        this.currentOffset = new long[this.n];
        this.currentMin = new long[this.n];
        this.currentMax = new long[this.n];
        long[] bbmin = regionProperties.getBoundingBoxMin();
        long[] bbmax = regionProperties.getBoundingBoxMax();
        for (int d = 0; d < this.n; ++d) {
            this.currentMin[d] = this.currentOffset[d] + bbmin[d];
            this.currentMax[d] = this.currentOffset[d] + bbmax[d];
        }
        this.size = regionProperties.getSize();
        this.itcodes = regionProperties.getItcodes();
        this.centerOfMass = RealPoint.wrap((double[])regionProperties.getCenterOfMass());
        this.origin = new Origin();
    }

    public LabelRegion<T> copy() {
        LabelRegion<T> r = new LabelRegion<T>(this.regions, this.regionProperties, this.label);
        System.arraycopy(this.position, 0, r.position, 0, this.n);
        System.arraycopy(this.currentOffset, 0, r.currentOffset, 0, this.n);
        System.arraycopy(this.currentMin, 0, r.currentMin, 0, this.n);
        System.arraycopy(this.currentMax, 0, r.currentMax, 0, this.n);
        r.expectedGeneration = this.expectedGeneration;
        return r;
    }

    public Origin origin() {
        this.update();
        return this.origin;
    }

    public T getLabel() {
        return this.label;
    }

    private void update() {
        int generation = this.regionProperties.update();
        if (generation != this.expectedGeneration) {
            this.expectedGeneration = generation;
            long[] bbmin = this.regionProperties.getBoundingBoxMin();
            long[] bbmax = this.regionProperties.getBoundingBoxMax();
            for (int d = 0; d < this.n; ++d) {
                this.currentMin[d] = this.currentOffset[d] + bbmin[d];
                this.currentMax[d] = this.currentOffset[d] + bbmax[d];
            }
            this.size = this.regionProperties.getSize();
        }
    }

    public RealLocalizable getCenterOfMass() {
        this.update();
        return this.centerOfMass;
    }

    public LabelRegionRandomAccess<T> randomAccess() {
        this.update();
        return new LabelRegionRandomAccess(this);
    }

    public RandomAccess<BoolType> randomAccess(Interval interval) {
        this.update();
        if (Intervals.contains((Interval)this, (Interval)interval)) {
            return this.randomAccess();
        }
        return new OutOfBoundsConstantValue((Interval)this, (Type)new BoolType(false));
    }

    public LabelRegionCursor cursor() {
        this.update();
        return new LabelRegionCursor(this.itcodes, this.currentOffset);
    }

    public LabelRegionCursor localizingCursor() {
        return this.cursor();
    }

    public long size() {
        this.update();
        return this.size;
    }

    public Void firstElement() {
        return null;
    }

    public Object iterationOrder() {
        return this;
    }

    public LabelRegionCursor iterator() {
        return this.cursor();
    }

    public void fwd(int d) {
        int n = d;
        this.position[n] = this.position[n] + 1L;
        int n2 = d;
        this.currentOffset[n2] = this.currentOffset[n2] + 1L;
        int n3 = d;
        this.currentMin[n3] = this.currentMin[n3] + 1L;
        int n4 = d;
        this.currentMax[n4] = this.currentMax[n4] + 1L;
    }

    public void bck(int d) {
        int n = d;
        this.position[n] = this.position[n] - 1L;
        int n2 = d;
        this.currentOffset[n2] = this.currentOffset[n2] - 1L;
        int n3 = d;
        this.currentMin[n3] = this.currentMin[n3] - 1L;
        int n4 = d;
        this.currentMax[n4] = this.currentMax[n4] - 1L;
    }

    public void move(int distance, int d) {
        int n = d;
        this.position[n] = this.position[n] + (long)distance;
        int n2 = d;
        this.currentOffset[n2] = this.currentOffset[n2] + (long)distance;
        int n3 = d;
        this.currentMin[n3] = this.currentMin[n3] + (long)distance;
        int n4 = d;
        this.currentMax[n4] = this.currentMax[n4] + (long)distance;
    }

    public void move(long distance, int d) {
        int n = d;
        this.position[n] = this.position[n] + distance;
        int n2 = d;
        this.currentOffset[n2] = this.currentOffset[n2] + distance;
        int n3 = d;
        this.currentMin[n3] = this.currentMin[n3] + distance;
        int n4 = d;
        this.currentMax[n4] = this.currentMax[n4] + distance;
    }

    public void move(Localizable localizable) {
        int d = 0;
        while (d < this.n) {
            long distance = localizable.getLongPosition(d);
            int n = d;
            this.position[n] = this.position[n] + distance;
            int n2 = d;
            this.currentOffset[n2] = this.currentOffset[n2] + distance;
            int n3 = d;
            this.currentMin[n3] = this.currentMin[n3] + distance;
            int n4 = d++;
            this.currentMax[n4] = this.currentMax[n4] + distance;
        }
    }

    public void move(int[] distance) {
        for (int d = 0; d < this.n; ++d) {
            int n = d;
            this.position[n] = this.position[n] + (long)distance[d];
            int n2 = d;
            this.currentOffset[n2] = this.currentOffset[n2] + (long)distance[d];
            int n3 = d;
            this.currentMin[n3] = this.currentMin[n3] + (long)distance[d];
            int n4 = d;
            this.currentMax[n4] = this.currentMax[n4] + (long)distance[d];
        }
    }

    public void move(long[] distance) {
        for (int d = 0; d < this.n; ++d) {
            int n = d;
            this.position[n] = this.position[n] + distance[d];
            int n2 = d;
            this.currentOffset[n2] = this.currentOffset[n2] + distance[d];
            int n3 = d;
            this.currentMin[n3] = this.currentMin[n3] + distance[d];
            int n4 = d;
            this.currentMax[n4] = this.currentMax[n4] + distance[d];
        }
    }

    public void setPosition(Localizable localizable) {
        int d = 0;
        while (d < this.n) {
            long distance = localizable.getLongPosition(d) - this.position[d];
            int n = d;
            this.position[n] = this.position[n] + distance;
            int n2 = d;
            this.currentOffset[n2] = this.currentOffset[n2] + distance;
            int n3 = d;
            this.currentMin[n3] = this.currentMin[n3] + distance;
            int n4 = d++;
            this.currentMax[n4] = this.currentMax[n4] + distance;
        }
    }

    public void setPosition(int[] pos) {
        int d = 0;
        while (d < this.n) {
            long distance = (long)pos[d] - this.position[d];
            int n = d;
            this.position[n] = this.position[n] + distance;
            int n2 = d;
            this.currentOffset[n2] = this.currentOffset[n2] + distance;
            int n3 = d;
            this.currentMin[n3] = this.currentMin[n3] + distance;
            int n4 = d++;
            this.currentMax[n4] = this.currentMax[n4] + distance;
        }
    }

    public void setPosition(long[] pos) {
        int d = 0;
        while (d < this.n) {
            long distance = pos[d] - this.position[d];
            int n = d;
            this.position[n] = this.position[n] + distance;
            int n2 = d;
            this.currentOffset[n2] = this.currentOffset[n2] + distance;
            int n3 = d;
            this.currentMin[n3] = this.currentMin[n3] + distance;
            int n4 = d++;
            this.currentMax[n4] = this.currentMax[n4] + distance;
        }
    }

    public void setPosition(int pos, int d) {
        long distance = (long)pos - this.position[d];
        int n = d;
        this.position[n] = this.position[n] + distance;
        int n2 = d;
        this.currentOffset[n2] = this.currentOffset[n2] + distance;
        int n3 = d;
        this.currentMin[n3] = this.currentMin[n3] + distance;
        int n4 = d;
        this.currentMax[n4] = this.currentMax[n4] + distance;
    }

    public void setPosition(long pos, int d) {
        long distance = pos - this.position[d];
        int n = d;
        this.position[n] = this.position[n] + distance;
        int n2 = d;
        this.currentOffset[n2] = this.currentOffset[n2] + distance;
        int n3 = d;
        this.currentMin[n3] = this.currentMin[n3] + distance;
        int n4 = d;
        this.currentMax[n4] = this.currentMax[n4] + distance;
    }

    public double realMin(int d) {
        this.update();
        return this.currentMin[d];
    }

    public void realMin(double[] min) {
        this.update();
        for (int d = 0; d < this.n; ++d) {
            min[d] = this.currentMin[d];
        }
    }

    public void realMin(RealPositionable min) {
        this.update();
        for (int d = 0; d < this.n; ++d) {
            min.setPosition(this.currentMin[d], d);
        }
    }

    public double realMax(int d) {
        this.update();
        return this.currentMax[d];
    }

    public void realMax(double[] max) {
        this.update();
        for (int d = 0; d < this.n; ++d) {
            max[d] = this.currentMax[d];
        }
    }

    public void realMax(RealPositionable max) {
        this.update();
        for (int d = 0; d < this.n; ++d) {
            max.setPosition(this.currentMax[d], d);
        }
    }

    public long min(int d) {
        this.update();
        return this.currentMin[d];
    }

    public void min(long[] min) {
        this.update();
        for (int d = 0; d < this.n; ++d) {
            min[d] = this.currentMin[d];
        }
    }

    public void min(Positionable min) {
        this.update();
        for (int d = 0; d < this.n; ++d) {
            min.setPosition(this.currentMin[d], d);
        }
    }

    public long max(int d) {
        this.update();
        return this.currentMax[d];
    }

    public void max(long[] max) {
        this.update();
        for (int d = 0; d < this.n; ++d) {
            max[d] = this.currentMax[d];
        }
    }

    public void max(Positionable max) {
        this.update();
        for (int d = 0; d < this.n; ++d) {
            max.setPosition(this.currentMax[d], d);
        }
    }

    public void dimensions(long[] dimensions) {
        this.update();
        for (int d = 0; d < this.n; ++d) {
            dimensions[d] = this.currentMax[d] - this.currentMin[d] + 1L;
        }
    }

    public long dimension(int d) {
        this.update();
        return this.currentMax[d] - this.currentMin[d] + 1L;
    }

    public class Origin
    implements Localizable,
    Positionable {
        public int numDimensions() {
            return LabelRegion.this.n;
        }

        public void localize(float[] pos) {
            for (int d = 0; d < LabelRegion.this.n; ++d) {
                pos[d] = LabelRegion.this.position[d] - LabelRegion.this.currentOffset[d];
            }
        }

        public void localize(double[] pos) {
            for (int d = 0; d < LabelRegion.this.n; ++d) {
                pos[d] = LabelRegion.this.position[d] - LabelRegion.this.currentOffset[d];
            }
        }

        public float getFloatPosition(int d) {
            return LabelRegion.this.position[d] - LabelRegion.this.currentOffset[d];
        }

        public double getDoublePosition(int d) {
            return LabelRegion.this.position[d] - LabelRegion.this.currentOffset[d];
        }

        public void localize(int[] pos) {
            for (int d = 0; d < LabelRegion.this.n; ++d) {
                pos[d] = (int)(LabelRegion.this.position[d] - LabelRegion.this.currentOffset[d]);
            }
        }

        public void localize(long[] pos) {
            for (int d = 0; d < LabelRegion.this.n; ++d) {
                pos[d] = LabelRegion.this.position[d] - LabelRegion.this.currentOffset[d];
            }
        }

        public int getIntPosition(int d) {
            return (int)(LabelRegion.this.position[d] - LabelRegion.this.currentOffset[d]);
        }

        public long getLongPosition(int d) {
            return LabelRegion.this.position[d] - LabelRegion.this.currentOffset[d];
        }

        public void fwd(int d) {
            long[] lArray = LabelRegion.this.currentOffset;
            int n = d;
            lArray[n] = lArray[n] + 1L;
            long[] lArray2 = LabelRegion.this.currentMin;
            int n2 = d;
            lArray2[n2] = lArray2[n2] + 1L;
            long[] lArray3 = LabelRegion.this.currentMax;
            int n3 = d;
            lArray3[n3] = lArray3[n3] + 1L;
        }

        public void bck(int d) {
            long[] lArray = LabelRegion.this.currentOffset;
            int n = d;
            lArray[n] = lArray[n] - 1L;
            long[] lArray2 = LabelRegion.this.currentMin;
            int n2 = d;
            lArray2[n2] = lArray2[n2] - 1L;
            long[] lArray3 = LabelRegion.this.currentMax;
            int n3 = d;
            lArray3[n3] = lArray3[n3] - 1L;
        }

        public void move(int distance, int d) {
            this.move((long)distance, d);
        }

        public void move(long distance, int d) {
            long[] lArray = LabelRegion.this.currentOffset;
            int n = d;
            lArray[n] = lArray[n] + distance;
            long[] lArray2 = LabelRegion.this.currentMin;
            int n2 = d;
            lArray2[n2] = lArray2[n2] + distance;
            long[] lArray3 = LabelRegion.this.currentMax;
            int n3 = d;
            lArray3[n3] = lArray3[n3] + distance;
        }

        public void move(Localizable localizable) {
            for (int d = 0; d < LabelRegion.this.n; ++d) {
                this.move(localizable.getLongPosition(d), d);
            }
        }

        public void move(int[] distance) {
            for (int d = 0; d < LabelRegion.this.n; ++d) {
                this.move(distance[d], d);
            }
        }

        public void move(long[] distance) {
            for (int d = 0; d < LabelRegion.this.n; ++d) {
                this.move(distance[d], d);
            }
        }

        public void setPosition(Localizable localizable) {
            for (int d = 0; d < LabelRegion.this.n; ++d) {
                this.setPosition(localizable.getLongPosition(d), d);
            }
        }

        public void setPosition(int[] pos) {
            for (int d = 0; d < LabelRegion.this.n; ++d) {
                this.setPosition(pos[d], d);
            }
        }

        public void setPosition(long[] pos) {
            for (int d = 0; d < LabelRegion.this.n; ++d) {
                this.setPosition(pos[d], d);
            }
        }

        public void setPosition(int pos, int d) {
            this.setPosition((long)pos, d);
        }

        public void setPosition(long pos, int d) {
            long distance = LabelRegion.this.position[d] - LabelRegion.this.currentOffset[d] - pos;
            this.move(distance, d);
        }
    }
}

