/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.ops.stats;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.imagej.ops.Ops;
import net.imagej.ops.stats.AbstractStatsOp;
import net.imglib2.type.numeric.RealType;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;

@Plugin(type=Ops.Stats.Quantile.class, label="Statistics: Quantile")
public class DefaultQuantile<I extends RealType<I>, O extends RealType<O>>
extends AbstractStatsOp<Iterable<I>, O>
implements Ops.Stats.Quantile {
    @Parameter(min="0.0", max="1.0")
    private double quantile;

    @Override
    public void compute(Iterable<I> input, O output) {
        ArrayList<Double> statistics = new ArrayList<Double>();
        Iterator<I> it = input.iterator();
        while (it.hasNext()) {
            statistics.add(((RealType)it.next()).getRealDouble());
        }
        output.setReal(this.select(statistics, 0, statistics.size() - 1, (int)((double)statistics.size() * this.quantile)));
    }

    private double select(ArrayList<Double> array, int inLeft, int inRight, int k) {
        int left = inLeft;
        int right = inRight;
        while (true) {
            if (right <= left + 1) {
                if (right == left + 1 && array.get(right) < array.get(left)) {
                    this.swap(array, left, right);
                }
                return array.get(k);
            }
            int middle = left + right >>> 1;
            this.swap(array, middle, left + 1);
            if (array.get(left) > array.get(right)) {
                this.swap(array, left, right);
            }
            if (array.get(left + 1) > array.get(right)) {
                this.swap(array, left + 1, right);
            }
            if (array.get(left) > array.get(left + 1)) {
                this.swap(array, left, left + 1);
            }
            int i = left + 1;
            int j = right;
            double pivot = array.get(left + 1);
            while (true) {
                if (array.get(++i) < pivot) {
                    continue;
                }
                while (array.get(--j) > pivot) {
                }
                if (j < i) break;
                this.swap(array, i, j);
            }
            array.set(left + 1, array.get(j));
            array.set(j, pivot);
            if (j >= k) {
                right = j - 1;
            }
            if (j > k) continue;
            left = i;
        }
    }

    private void swap(List<Double> array, int a, int b) {
        double temp = array.get(a);
        array.set(a, array.get(b));
        array.set(b, temp);
    }
}

