/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.ops.image.distancetransform;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import net.imagej.ops.Contingent;
import net.imagej.ops.Ops;
import net.imagej.ops.create.img.CreateImgFromDimsAndType;
import net.imagej.ops.image.distancetransform.InitPhase;
import net.imagej.ops.image.distancetransform.NextPhase;
import net.imagej.ops.special.function.Functions;
import net.imagej.ops.special.function.UnaryFunctionOp;
import net.imagej.ops.special.hybrid.AbstractUnaryHybridCF;
import net.imglib2.FinalInterval;
import net.imglib2.Interval;
import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.type.BooleanType;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.numeric.real.FloatType;
import net.imglib2.util.IntervalIndexer;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.scijava.thread.ThreadService;

@Plugin(type=Ops.Image.DistanceTransform.class, priority=-Infinity)
public class DefaultDistanceTransform<B extends BooleanType<B>, T extends RealType<T>>
extends AbstractUnaryHybridCF<RandomAccessibleInterval<B>, RandomAccessibleInterval<T>>
implements Ops.Image.DistanceTransform,
Contingent {
    @Parameter
    private ThreadService ts;
    private UnaryFunctionOp<FinalInterval, RandomAccessibleInterval> createOp;
    private ExecutorService es;

    @Override
    public boolean conforms() {
        long max_dist = 0L;
        for (int i = 0; i < ((RandomAccessibleInterval)this.in()).numDimensions(); ++i) {
            max_dist += ((RandomAccessibleInterval)this.in()).dimension(i) * ((RandomAccessibleInterval)this.in()).dimension(i);
        }
        return max_dist <= Integer.MAX_VALUE;
    }

    @Override
    public void initialize() {
        this.es = this.ts.getExecutorService();
        this.createOp = Functions.unary(this.ops(), CreateImgFromDimsAndType.class, RandomAccessibleInterval.class, new FinalInterval((Interval)this.in()), new FloatType());
    }

    @Override
    public RandomAccessibleInterval<T> createOutput(RandomAccessibleInterval<B> in) {
        return this.createOp.calculate(new FinalInterval(in));
    }

    @Override
    public void compute(RandomAccessibleInterval<B> in, RandomAccessibleInterval<T> out) {
        int[] dimensSizes = new int[in.numDimensions()];
        int[] positions = new int[in.numDimensions()];
        int numPoints = 1;
        for (int i = 0; i < in.numDimensions(); ++i) {
            numPoints = (int)((long)numPoints * in.dimension(i));
            dimensSizes[i] = (int)in.dimension(i);
            positions[i] = 0;
        }
        int[] actualValues = new int[numPoints];
        ArrayList<Callable<Void>> list = new ArrayList<Callable<Void>>();
        int index = dimensSizes.length - 1;
        list.add(new InitPhase(actualValues, in, dimensSizes, (int[])positions.clone()));
        while (index > 0) {
            if (positions[index] < dimensSizes[index] - 1) {
                int n = index;
                positions[n] = positions[n] + 1;
                index = positions.length - 1;
                list.add(new InitPhase(actualValues, in, dimensSizes, (int[])positions.clone()));
                continue;
            }
            positions[index] = 0;
            --index;
        }
        try {
            this.es.invokeAll(list);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        list.clear();
        for (int i = 0; i < actualValues.length; ++i) {
            int n = i;
            actualValues[n] = actualValues[n] * actualValues[i];
        }
        for (int actualDimension = 1; actualDimension < in.numDimensions(); ++actualDimension) {
            Arrays.fill(positions, 0);
            positions[actualDimension] = -1;
            index = positions.length - 1;
            list.add(new NextPhase(actualValues, dimensSizes, (int[])positions.clone(), actualDimension));
            while (index >= 0) {
                if (positions[index] == -1) {
                    --index;
                    continue;
                }
                if (positions[index] < dimensSizes[index] - 1) {
                    int n = index;
                    positions[n] = positions[n] + 1;
                    index = positions.length - 1;
                    list.add(new NextPhase(actualValues, dimensSizes, (int[])positions.clone(), actualDimension));
                    continue;
                }
                positions[index] = 0;
                --index;
            }
            try {
                this.es.invokeAll(list);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            list.clear();
        }
        Arrays.fill(positions, 0);
        RandomAccess raOut = out.randomAccess();
        raOut.setPosition(positions);
        ((RealType)raOut.get()).setReal(Math.sqrt(actualValues[IntervalIndexer.positionToIndex((int[])positions, (int[])dimensSizes)]));
        index = dimensSizes.length - 1;
        while (index >= 0) {
            if (positions[index] < dimensSizes[index] - 1) {
                int n = index;
                positions[n] = positions[n] + 1;
                index = positions.length - 1;
                raOut.setPosition(positions);
                ((RealType)raOut.get()).setReal(Math.sqrt(actualValues[IntervalIndexer.positionToIndex((int[])positions, (int[])dimensSizes)]));
                continue;
            }
            positions[index] = 0;
            --index;
        }
    }
}

