/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.ops.geom.geom3d;

import net.imagej.ops.Contingent;
import net.imagej.ops.Ops;
import net.imagej.ops.geom.geom3d.mesh.Mesh;
import net.imagej.ops.special.function.Functions;
import net.imagej.ops.special.function.UnaryFunctionOp;
import net.imagej.ops.special.hybrid.AbstractUnaryHybridCF;
import net.imglib2.type.numeric.real.DoubleType;
import org.apache.commons.math3.linear.EigenDecomposition;
import org.apache.commons.math3.linear.RealMatrix;
import org.scijava.plugin.Plugin;

@Plugin(type=Ops.Geometric.Spareness.class, label="Geometric (3D): Spareness", priority=10000.0)
public class DefaultSparenessMesh
extends AbstractUnaryHybridCF<Mesh, DoubleType>
implements Ops.Geometric.Spareness,
Contingent {
    private UnaryFunctionOp<Mesh, RealMatrix> inertiaTensor;
    private UnaryFunctionOp<Mesh, DoubleType> volume;

    @Override
    public void initialize() {
        this.inertiaTensor = Functions.unary(this.ops(), Ops.Geometric.SecondMoment.class, RealMatrix.class, this.in(), new Object[0]);
        this.volume = Functions.unary(this.ops(), Ops.Geometric.Size.class, DoubleType.class, this.in(), new Object[0]);
    }

    @Override
    public void compute(Mesh input, DoubleType output) {
        RealMatrix it = this.inertiaTensor.calculate(input);
        EigenDecomposition ed = new EigenDecomposition(it);
        double l1 = ed.getRealEigenvalue(0) - ed.getRealEigenvalue(2) + ed.getRealEigenvalue(1);
        double l2 = ed.getRealEigenvalue(0) - ed.getRealEigenvalue(1) + ed.getRealEigenvalue(2);
        double l3 = ed.getRealEigenvalue(2) - ed.getRealEigenvalue(0) + ed.getRealEigenvalue(1);
        double g = 0.5968310365946076;
        double a = Math.pow(0.5968310365946076 * l1 * l1 / Math.sqrt(l2 * l3), 0.2);
        double b = Math.pow(0.5968310365946076 * l2 * l2 / Math.sqrt(l1 * l3), 0.2);
        double c = Math.pow(0.5968310365946076 * l3 * l3 / Math.sqrt(l1 * l2), 0.2);
        double volumeEllipsoid = 4.1887902047863905 * a * b * c;
        output.set(this.volume.calculate(input).get() / volumeEllipsoid);
    }

    @Override
    public DoubleType createOutput(Mesh input) {
        return new DoubleType();
    }

    @Override
    public boolean conforms() {
        return this.in() != null;
    }
}

