/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.ops.geom.geom3d;

import net.imagej.ops.Ops;
import net.imagej.ops.geom.geom3d.mesh.Mesh;
import net.imagej.ops.special.function.Functions;
import net.imagej.ops.special.function.UnaryFunctionOp;
import net.imagej.ops.special.hybrid.AbstractUnaryHybridCF;
import net.imglib2.type.numeric.real.DoubleType;
import org.scijava.plugin.Plugin;

@Plugin(type=Ops.Geometric.Compactness.class, label="Geometric (3D): Compactness", priority=10000.0)
public class DefaultCompactness
extends AbstractUnaryHybridCF<Mesh, DoubleType>
implements Ops.Geometric.Compactness {
    private UnaryFunctionOp<Mesh, DoubleType> surfaceArea;
    private UnaryFunctionOp<Mesh, DoubleType> volume;

    @Override
    public void initialize() {
        this.surfaceArea = Functions.unary(this.ops(), Ops.Geometric.BoundarySize.class, DoubleType.class, this.in(), new Object[0]);
        this.volume = Functions.unary(this.ops(), Ops.Geometric.Size.class, DoubleType.class, this.in(), new Object[0]);
    }

    @Override
    public void compute(Mesh input, DoubleType output) {
        double s3 = Math.pow(this.surfaceArea.calculate(input).get(), 3.0);
        double v2 = Math.pow(this.volume.calculate(input).get(), 2.0);
        double c = s3 / v2;
        output.set(113.09733552923255 / c);
    }

    @Override
    public DoubleType createOutput(Mesh input) {
        return new DoubleType();
    }
}

