/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.ops.geom.geom2d;

import java.lang.reflect.Type;
import net.imagej.ops.OpEnvironment;
import net.imagej.ops.OpService;
import net.imagej.ops.Ops;
import net.imagej.ops.special.function.Functions;
import net.imagej.ops.special.function.UnaryFunctionOp;
import net.imglib2.roi.geometric.Polygon;
import net.imglib2.roi.labeling.LabelRegion;
import org.scijava.convert.AbstractConverter;
import org.scijava.convert.ConversionRequest;
import org.scijava.convert.Converter;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;

@Plugin(type=Converter.class, priority=10000.0)
public class LabelRegionToPolygonConverter
extends AbstractConverter<LabelRegion, Polygon> {
    @Parameter(required=false)
    private OpService ops;
    private UnaryFunctionOp<Object, Object> contourFunc;

    public <T> T convert(Object src, Class<T> dest) {
        if (this.contourFunc == null) {
            this.contourFunc = Functions.unary((OpEnvironment)this.ops, Ops.Geometric.Contour.class, dest, src, true);
        }
        Polygon p = (Polygon)this.contourFunc.calculate(src);
        return (T)p;
    }

    public Class<Polygon> getOutputType() {
        return Polygon.class;
    }

    public Class<LabelRegion> getInputType() {
        return LabelRegion.class;
    }

    public boolean supports(ConversionRequest request) {
        if (this.ops == null) {
            return false;
        }
        Object sourceObject = request.sourceObject();
        if (sourceObject == null || !(sourceObject instanceof LabelRegion)) {
            return false;
        }
        if (((LabelRegion)sourceObject).numDimensions() != 2) {
            return false;
        }
        Class destClass = request.destClass();
        Type destType = request.destType();
        if (destClass != null && destClass != Polygon.class) {
            return false;
        }
        return destType == null || destType == Polygon.class;
    }
}

