/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.ops.filter.pad;

import net.imagej.ops.Ops;
import net.imagej.ops.filter.fft.FFTMethodsUtility;
import net.imagej.ops.filter.pad.PaddingIntervalCentered;
import net.imagej.ops.special.function.AbstractBinaryFunctionOp;
import net.imagej.ops.special.function.BinaryFunctionOp;
import net.imagej.ops.special.function.Functions;
import net.imglib2.Dimensions;
import net.imglib2.Interval;
import net.imglib2.RandomAccessible;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.outofbounds.OutOfBoundsConstantValueFactory;
import net.imglib2.outofbounds.OutOfBoundsFactory;
import net.imglib2.type.numeric.ComplexType;
import net.imglib2.util.Util;
import net.imglib2.view.Views;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;

@Plugin(type=Ops.Filter.PadFFTInput.class, priority=100.0)
public class PadInputFFTMethods<T extends ComplexType<T>, I extends RandomAccessibleInterval<T>, O extends RandomAccessibleInterval<T>>
extends AbstractBinaryFunctionOp<I, Dimensions, O>
implements Ops.Filter.PadFFTInput {
    @Parameter(required=false)
    private boolean fast = true;
    private BinaryFunctionOp<I, Dimensions, O> paddingIntervalCentered;
    @Parameter(required=false)
    private OutOfBoundsFactory<T, RandomAccessibleInterval<T>> obf;

    @Override
    public void initialize() {
        super.initialize();
        this.paddingIntervalCentered = (BinaryFunctionOp)Functions.unary(this.ops(), PaddingIntervalCentered.class, Interval.class, RandomAccessibleInterval.class, new Object[]{Dimensions.class});
    }

    @Override
    public O calculate(I input, Dimensions paddedDimensions) {
        Dimensions paddedFFTMethodsInputDimensions = FFTMethodsUtility.getPaddedInputDimensionsRealToComplex(this.fast, paddedDimensions);
        if (this.obf == null) {
            this.obf = new OutOfBoundsConstantValueFactory(((ComplexType)Util.getTypeFromInterval(input)).createVariable());
        }
        Interval inputInterval = (Interval)this.paddingIntervalCentered.calculate(input, paddedFFTMethodsInputDimensions);
        return (O)Views.interval((RandomAccessible)Views.extend(input, this.obf), (Interval)inputInterval);
    }
}

