/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.ops.deconvolve;

import java.util.ArrayList;
import net.imagej.ops.Ops;
import net.imagej.ops.deconvolve.RichardsonLucyCorrection;
import net.imagej.ops.deconvolve.RichardsonLucyUpdate;
import net.imagej.ops.filter.AbstractIterativeFFTFilterC;
import net.imagej.ops.filter.convolve.ConvolveFFTC;
import net.imagej.ops.filter.fft.FFTMethodsOpC;
import net.imagej.ops.special.computer.BinaryComputerOp;
import net.imagej.ops.special.computer.Computers;
import net.imagej.ops.special.computer.UnaryComputerOp;
import net.imagej.ops.special.function.Functions;
import net.imagej.ops.special.function.UnaryFunctionOp;
import net.imagej.ops.special.hybrid.Hybrids;
import net.imagej.ops.special.inplace.UnaryInplaceOp;
import net.imglib2.Dimensions;
import net.imglib2.FinalInterval;
import net.imglib2.Interval;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.img.Img;
import net.imglib2.type.numeric.ComplexType;
import net.imglib2.type.numeric.RealType;
import net.imglib2.util.Util;
import net.imglib2.view.IntervalView;
import net.imglib2.view.Views;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;

@Plugin(type=Ops.Deconvolve.RichardsonLucy.class, priority=100.0)
public class RichardsonLucyC<I extends RealType<I>, O extends RealType<O>, K extends RealType<K>, C extends ComplexType<C>>
extends AbstractIterativeFFTFilterC<I, O, K, C>
implements Ops.Deconvolve.RichardsonLucy {
    @Parameter(required=false)
    private UnaryComputerOp<RandomAccessibleInterval<O>, RandomAccessibleInterval<O>> update = null;
    @Parameter(required=false)
    private RandomAccessibleInterval<O> raiExtendedEstimate;
    @Parameter(required=false)
    private ArrayList<UnaryInplaceOp<RandomAccessibleInterval<O>, RandomAccessibleInterval<O>>> iterativePostProcessing = null;
    private BinaryComputerOp<RandomAccessibleInterval<I>, RandomAccessibleInterval<O>, RandomAccessibleInterval<O>> rlCorrection;
    private UnaryFunctionOp<Interval, Img<O>> create;
    private UnaryComputerOp<RandomAccessibleInterval<K>, RandomAccessibleInterval<C>> fftKernel;
    private BinaryComputerOp<RandomAccessibleInterval<O>, RandomAccessibleInterval<K>, RandomAccessibleInterval<O>> convolver;
    private UnaryComputerOp<RandomAccessibleInterval<I>, RandomAccessibleInterval<O>> copy;
    private UnaryComputerOp<RandomAccessibleInterval<O>, RandomAccessibleInterval<O>> copy2;
    private RandomAccessibleInterval<O> raiExtendedReblurred;

    @Override
    public void initialize() {
        super.initialize();
        if (this.update == null) {
            this.update = Computers.unary(this.ops(), RichardsonLucyUpdate.class, RandomAccessibleInterval.class, RandomAccessibleInterval.class, new Object[0]);
        }
        this.rlCorrection = Computers.binary(this.ops(), RichardsonLucyCorrection.class, RandomAccessibleInterval.class, RandomAccessibleInterval.class, RandomAccessibleInterval.class, new Object[]{this.getFFTInput(), this.getFFTKernel()});
        this.fftKernel = Computers.unary(this.ops(), FFTMethodsOpC.class, this.getFFTKernel(), RandomAccessibleInterval.class, new Object[0]);
        this.copy = Hybrids.unaryCF(this.ops(), Ops.Copy.RAI.class, RandomAccessibleInterval.class, IntervalView.class, new Object[0]);
        this.copy2 = Hybrids.unaryCF(this.ops(), Ops.Copy.RAI.class, RandomAccessibleInterval.class, IntervalView.class, new Object[0]);
        this.create = Functions.unary(this.ops(), Ops.Create.Img.class, Img.class, Dimensions.class, new Object[]{Util.getTypeFromInterval((Interval)((Interval)this.out()))});
        this.convolver = Computers.binary(this.ops(), ConvolveFFTC.class, RandomAccessibleInterval.class, RandomAccessibleInterval.class, RandomAccessibleInterval.class, new Object[]{this.getFFTInput(), this.getFFTKernel(), true, false});
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void compute(RandomAccessibleInterval<I> in, RandomAccessibleInterval<K> kernel, RandomAccessibleInterval<O> out) {
        void var6_9;
        if (this.raiExtendedEstimate == null) {
            this.raiExtendedEstimate = (RandomAccessibleInterval)this.create.calculate(this.getImgConvolutionInterval());
            this.copy.compute(in, this.raiExtendedEstimate);
        }
        this.raiExtendedReblurred = (RandomAccessibleInterval)this.create.calculate(this.getImgConvolutionInterval());
        this.fftKernel.compute(kernel, (RandomAccessibleInterval<C>)this.getFFTKernel());
        for (int i = 0; i < this.getMaxIterations(); ++i) {
            if (this.status != null) {
                this.status.showProgress(i, this.getMaxIterations());
            }
            this.convolver.compute(this.raiExtendedEstimate, this.raiExtendedReblurred);
            this.rlCorrection.compute(in, this.raiExtendedReblurred, this.raiExtendedReblurred);
            this.update.compute(this.raiExtendedReblurred, this.raiExtendedEstimate);
            if (this.iterativePostProcessing != null) {
                for (UnaryInplaceOp<RandomAccessibleInterval<RandomAccessibleInterval<O>>, RandomAccessibleInterval<RandomAccessibleInterval<O>>> unaryInplaceOp : this.iterativePostProcessing) {
                    unaryInplaceOp.mutate(this.raiExtendedEstimate);
                }
            }
            if (this.getAccelerator() == null) continue;
            this.getAccelerator().mutate(this.raiExtendedEstimate);
        }
        long[] start = new long[out.numDimensions()];
        long[] end = new long[out.numDimensions()];
        boolean bl = false;
        while (var6_9 < out.numDimensions()) {
            start[var6_9] = 0L;
            end[var6_9] = start[var6_9] + out.dimension((int)var6_9) - 1L;
            ++var6_9;
        }
        this.copy2.compute((RandomAccessibleInterval<RandomAccessibleInterval<O>>)Views.interval(this.raiExtendedEstimate, (Interval)new FinalInterval(start, end)), (RandomAccessibleInterval<RandomAccessibleInterval<O>>)out);
    }
}

