/*
 * Decompiled with CFR 0.152.
 */
package io.scif.util;

import io.scif.FormatException;
import io.scif.Metadata;
import io.scif.filters.MetadataWrapper;
import io.scif.io.RandomAccessOutputStream;
import io.scif.util.FormatTools;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import net.imagej.axis.Axes;
import net.imagej.axis.AxisType;
import net.imagej.axis.CalibratedAxis;

public class SCIFIOMetadataTools {
    private SCIFIOMetadataTools() {
    }

    public static boolean wholePlane(int imageIndex, Metadata meta, long[] planeMin, long[] planeMax) {
        boolean wholePlane = SCIFIOMetadataTools.wholeRow(imageIndex, meta, planeMin, planeMax);
        int yIndex = meta.get(imageIndex).getAxisIndex(Axes.Y);
        return wholePlane && planeMin[yIndex] == 0L && planeMax[yIndex] == meta.get(imageIndex).getAxisLength(Axes.Y);
    }

    public static boolean wholeRow(int imageIndex, Metadata meta, long[] planeMin, long[] planeMax) {
        boolean wholeRow = true;
        int yIndex = meta.get(imageIndex).getAxisIndex(Axes.Y);
        for (int i = 0; wholeRow && i < planeMin.length; ++i) {
            if (i == yIndex || planeMin[i] == 0L && planeMax[i] == meta.get(imageIndex).getAxisLength(i)) continue;
            wholeRow = false;
        }
        return wholeRow;
    }

    public static long[] modifyPlanar(int imageIndex, Metadata meta, long ... values) {
        AxisValue[] axes = new AxisValue[values.length];
        List<CalibratedAxis> axisTypes = meta.get(imageIndex).getAxes();
        for (int i = 0; i < axes.length && i < axisTypes.size(); ++i) {
            axes[i] = new AxisValue(axisTypes.get(i).type(), values[i]);
        }
        return SCIFIOMetadataTools.modifyPlanar(imageIndex, meta, axes);
    }

    public static long[] modifyPlanar(int imageIndex, Metadata meta, AxisValue ... axes) {
        long[] planarAxes = meta.get(imageIndex).getAxesLengthsPlanar();
        for (AxisValue v : axes) {
            planarAxes[meta.get((int)imageIndex).getAxisIndex((AxisType)v.getType())] = v.getLength();
        }
        return planarAxes;
    }

    public static <M extends Metadata> M castMeta(Metadata meta) {
        return (M)meta;
    }

    public static Metadata unwrapMetadata(Metadata meta) {
        Metadata unwrappedMeta = meta;
        while (unwrappedMeta instanceof MetadataWrapper) {
            unwrappedMeta = ((MetadataWrapper)unwrappedMeta).unwrap();
        }
        return unwrappedMeta;
    }

    public static void verifyMinimumPopulated(Metadata src, RandomAccessOutputStream out) throws FormatException {
        SCIFIOMetadataTools.verifyMinimumPopulated(src, out, 0);
    }

    public static void verifyMinimumPopulated(Metadata src, RandomAccessOutputStream out, int imageIndex) throws FormatException {
        if (src == null) {
            throw new FormatException("Metadata object is null; call Writer.setMetadata() first");
        }
        if (out == null) {
            throw new FormatException("RandomAccessOutputStream object is null; call Writer.setSource(<String/File/RandomAccessOutputStream>) first");
        }
        if (src.get(imageIndex).getAxes().size() == 0) {
            throw new FormatException("Axiscount #" + imageIndex + " is 0");
        }
    }

    public static int guessPlanarAxisCount(List<CalibratedAxis> axes) {
        int d;
        boolean xFound = false;
        boolean yFound = false;
        for (d = 0; !(d >= axes.size() || xFound && yFound); ++d) {
            AxisType type = axes.get(d).type();
            if (type == Axes.X) {
                xFound = true;
                continue;
            }
            if (type != Axes.Y) continue;
            yFound = true;
        }
        return d;
    }

    public static int guessInterleavedAxisCount(List<CalibratedAxis> axes) {
        for (int d = 0; d < axes.size(); ++d) {
            AxisType type = axes.get(d).type();
            if (type != Axes.X && type != Axes.Y) continue;
            return d;
        }
        return axes.size();
    }

    public static void merge(Map<String, Object> src, Map<String, Object> dest, String prefix) {
        for (String key : src.keySet()) {
            dest.put(prefix + key, src.get(key));
        }
    }

    public static String[] keys(Hashtable<String, Object> meta) {
        Object[] keys = new String[meta.size()];
        meta.keySet().toArray(keys);
        Arrays.sort(keys);
        return keys;
    }

    public static class AxisValue {
        private CalibratedAxis type;
        private long length;

        public AxisValue(AxisType type, long length) {
            this.type = FormatTools.createAxis(type);
            this.length = length;
        }

        public long getLength() {
            return this.length;
        }

        public void setLength(long length) {
            this.length = length;
        }

        public AxisType getType() {
            return this.type.type();
        }

        public void setType(CalibratedAxis type) {
            this.type = type;
        }
    }
}

