/*
 * Decompiled with CFR 0.152.
 */
package io.scif.services;

import io.scif.FormatException;
import io.scif.ImageMetadata;
import io.scif.Metadata;
import io.scif.config.SCIFIOConfig;
import io.scif.img.ImgIOException;
import io.scif.img.ImgOpener;
import io.scif.img.ImgSaver;
import io.scif.img.SCIFIOImgPlus;
import io.scif.services.DatasetIOService;
import io.scif.services.FormatService;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.imagej.Dataset;
import net.imagej.DatasetService;
import net.imagej.ImgPlus;
import net.imagej.axis.Axes;
import net.imagej.axis.CalibratedAxis;
import net.imglib2.exception.IncompatibleTypeException;
import net.imglib2.img.Img;
import org.scijava.log.LogService;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.scijava.service.AbstractService;
import org.scijava.service.Service;

@Plugin(type=Service.class)
public class DefaultDatasetIOService
extends AbstractService
implements DatasetIOService {
    @Parameter
    private FormatService formatService;
    @Parameter
    private DatasetService datasetService;
    @Parameter
    private LogService log;

    @Override
    public boolean canOpen(String source) {
        try {
            return this.formatService.getFormat(source, new SCIFIOConfig().checkerSetOpen(true)) != null;
        }
        catch (FormatException exc) {
            this.log.error((Throwable)exc);
            return false;
        }
    }

    @Override
    public boolean canSave(String destination) {
        try {
            return this.formatService.getWriterByExtension(destination) != null;
        }
        catch (FormatException exc) {
            this.log.error((Throwable)exc);
            return false;
        }
    }

    @Override
    public Dataset open(String source) throws IOException {
        SCIFIOConfig config = new SCIFIOConfig();
        config.imgOpenerSetIndex(0);
        config.imgOpenerSetComputeMinMax(false);
        config.imgOpenerSetImgModes(SCIFIOConfig.ImgMode.PLANAR);
        return this.open(source, config);
    }

    @Override
    public Dataset open(String source, SCIFIOConfig config) throws IOException {
        ImgOpener imageOpener = new ImgOpener(this.getContext());
        try {
            SCIFIOImgPlus<?> imgPlus = imageOpener.openImgs(source, config).get(0);
            Dataset dataset = this.datasetService.create(imgPlus);
            ImageMetadata imageMeta = imgPlus.getImageMetadata();
            this.updateDataset(dataset, imageMeta);
            return dataset;
        }
        catch (ImgIOException exc) {
            throw new IOException((Throwable)((Object)exc));
        }
    }

    @Override
    public List<Dataset> openAll(String source) throws IOException {
        SCIFIOConfig config = new SCIFIOConfig();
        config.imgOpenerSetImgModes(SCIFIOConfig.ImgMode.PLANAR);
        return this.openAll(source, config);
    }

    @Override
    public List<Dataset> openAll(String source, SCIFIOConfig config) throws IOException {
        ArrayList<Dataset> datasetList = new ArrayList<Dataset>();
        ImgOpener imageOpener = new ImgOpener(this.getContext());
        try {
            List<SCIFIOImgPlus<?>> openImgs = imageOpener.openImgs(source, config);
            for (int imgId = 0; imgId != openImgs.size(); ++imgId) {
                SCIFIOImgPlus<?> imgPlus = openImgs.get(imgId);
                Dataset dataset = this.datasetService.create(imgPlus);
                ImageMetadata imageMeta = imgPlus.getImageMetadata();
                this.updateDataset(dataset, imageMeta);
                datasetList.add(dataset);
            }
        }
        catch (ImgIOException exc) {
            throw new IOException((Throwable)((Object)exc));
        }
        return datasetList;
    }

    @Override
    public Metadata save(Dataset dataset, String destination) throws IOException {
        return this.save(dataset, destination, new SCIFIOConfig());
    }

    @Override
    public Metadata save(Dataset dataset, String destination, SCIFIOConfig config) throws IOException {
        Metadata metadata;
        ImgPlus img = dataset.getImgPlus();
        ImgSaver imageSaver = new ImgSaver(this.getContext());
        try {
            metadata = imageSaver.saveImg(destination, (Img<?>)img, config);
        }
        catch (ImgIOException exc) {
            throw new IOException((Throwable)((Object)exc));
        }
        catch (IncompatibleTypeException exc) {
            throw new IOException(exc);
        }
        String name = new File(destination).getName();
        dataset.setName(name);
        dataset.setDirty(false);
        return metadata;
    }

    @Override
    public void revert(Dataset dataset) throws IOException {
        String source = dataset.getSource();
        if (source == null || source.isEmpty()) {
            throw new IOException("Cannot revert image of unknown origin");
        }
        Dataset revertedDataset = this.open(source);
        revertedDataset.copyInto(dataset);
    }

    private void updateDataset(Dataset dataset, ImageMetadata imageMeta) {
        boolean rgbMerged = false;
        for (CalibratedAxis axis : imageMeta.getAxesPlanar()) {
            if (!axis.type().equals(Axes.CHANNEL)) continue;
            rgbMerged = true;
        }
        dataset.setRGBMerged(rgbMerged);
    }
}

