/*
 * Decompiled with CFR 0.152.
 */
package io.scif.io;

import io.scif.AbstractSCIFIOPlugin;
import io.scif.io.HandleException;
import io.scif.io.IStreamAccess;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.scijava.Context;
import org.scijava.util.Bytes;

public abstract class StreamHandle
extends AbstractSCIFIOPlugin
implements IStreamAccess {
    private String file;
    private DataInputStream stream;
    private DataOutputStream outStream;
    private long length;
    private long fp;
    private long mark;
    private ByteOrder order;

    public StreamHandle() {
        this(null);
    }

    public StreamHandle(Context context) {
        if (context != null) {
            this.setContext(context);
        }
        this.fp = 0L;
        this.order = ByteOrder.BIG_ENDIAN;
        this.file = null;
        this.stream = null;
        this.outStream = null;
        this.length = 0L;
        this.mark = 0L;
    }

    public String getFile() {
        return this.file;
    }

    public DataInputStream getStream() {
        return this.stream;
    }

    public void setStream(DataInputStream stream) {
        this.stream = stream;
    }

    public DataOutputStream getOutStream() {
        return this.outStream;
    }

    public void setOutStream(DataOutputStream outStream) {
        this.outStream = outStream;
    }

    public long getLength() {
        return this.length;
    }

    public void setLength(long length) {
        this.length = length;
    }

    public long getFp() {
        return this.fp;
    }

    public void setFp(long fp) {
        this.fp = fp;
    }

    public long getMark() {
        return this.mark;
    }

    public void setMark(long mark) {
        this.mark = mark;
    }

    @Override
    public void setFile(String file) throws IOException {
        this.file = file;
    }

    @Override
    public void close() throws IOException {
        this.mark = 0L;
        this.fp = 0L;
        this.length = 0L;
        if (this.stream != null) {
            this.stream.close();
        }
        if (this.outStream != null) {
            this.outStream.close();
        }
        this.stream = null;
        this.outStream = null;
        this.file = null;
    }

    @Override
    public long getFilePointer() throws IOException {
        return this.fp;
    }

    @Override
    public long length() throws IOException {
        return this.length;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int n = this.stream.read(b, off, len);
        if (n >= 0) {
            this.fp += (long)n;
        } else {
            n = 0;
        }
        this.markManager();
        while (n < len && this.fp < this.length()) {
            int s = this.stream.read(b, off + n, len - n);
            this.fp += (long)s;
            n += s;
        }
        return n == -1 ? 0 : n;
    }

    @Override
    public int read(ByteBuffer buffer) throws IOException {
        return this.read(buffer, 0, buffer.capacity());
    }

    @Override
    public int read(ByteBuffer buffer, int off, int len) throws IOException {
        if (buffer.hasArray()) {
            return this.read(buffer.array(), off, len);
        }
        byte[] b = new byte[len];
        int n = this.read(b);
        buffer.put(b, off, len);
        return n;
    }

    @Override
    public void seek(long pos) throws IOException {
        int n;
        long diff = pos - this.fp;
        this.fp = pos;
        if (diff < 0L) {
            this.resetStream();
            diff = this.fp;
        }
        int skipped = this.stream.skipBytes((int)diff);
        while ((long)skipped < diff && (n = this.stream.skipBytes((int)(diff - (long)skipped))) != 0) {
            skipped += n;
        }
    }

    @Override
    public void write(ByteBuffer buf) throws IOException {
        this.write(buf, 0, buf.capacity());
    }

    @Override
    public void write(ByteBuffer buf, int off, int len) throws IOException {
        buf.position(off);
        if (buf.hasArray()) {
            this.write(buf.array(), off, len);
        } else {
            byte[] b = new byte[len];
            buf.get(b);
            this.write(b);
        }
    }

    @Override
    public ByteOrder getOrder() {
        return this.order;
    }

    @Override
    public void setOrder(ByteOrder order) {
        this.order = order;
    }

    @Override
    public boolean readBoolean() throws IOException {
        ++this.fp;
        return this.stream.readBoolean();
    }

    @Override
    public byte readByte() throws IOException {
        ++this.fp;
        return this.stream.readByte();
    }

    @Override
    public char readChar() throws IOException {
        ++this.fp;
        return this.stream.readChar();
    }

    @Override
    public double readDouble() throws IOException {
        this.fp += 8L;
        double v = this.stream.readDouble();
        return this.order.equals(ByteOrder.LITTLE_ENDIAN) ? Bytes.swap((double)v) : v;
    }

    @Override
    public float readFloat() throws IOException {
        this.fp += 4L;
        float v = this.stream.readFloat();
        return this.order.equals(ByteOrder.LITTLE_ENDIAN) ? Bytes.swap((float)v) : v;
    }

    @Override
    public void readFully(byte[] b) throws IOException {
        this.stream.readFully(b);
        this.fp += (long)b.length;
    }

    @Override
    public void readFully(byte[] b, int off, int len) throws IOException {
        this.stream.readFully(b, off, len);
        this.fp += (long)len;
    }

    @Override
    public int readInt() throws IOException {
        this.fp += 4L;
        int v = this.stream.readInt();
        return this.order.equals(ByteOrder.LITTLE_ENDIAN) ? Bytes.swap((int)v) : v;
    }

    @Override
    public String readLine() throws IOException {
        throw new IOException("Unimplemented");
    }

    @Override
    public long readLong() throws IOException {
        this.fp += 8L;
        long v = this.stream.readLong();
        return this.order.equals(ByteOrder.LITTLE_ENDIAN) ? Bytes.swap((long)v) : v;
    }

    @Override
    public short readShort() throws IOException {
        this.fp += 2L;
        short v = this.stream.readShort();
        return this.order.equals(ByteOrder.LITTLE_ENDIAN) ? Bytes.swap((short)v) : v;
    }

    @Override
    public int readUnsignedByte() throws IOException {
        ++this.fp;
        return this.stream.readUnsignedByte();
    }

    @Override
    public int readUnsignedShort() throws IOException {
        return this.readShort() & 0xFFFF;
    }

    @Override
    public String readUTF() throws IOException {
        String s = this.stream.readUTF();
        this.fp += (long)s.length();
        return s;
    }

    @Override
    public int skipBytes(int n) throws IOException {
        int skipped = 0;
        try {
            for (int i = 0; i < n; ++i) {
                if (this.readUnsignedByte() != -1) {
                    ++skipped;
                }
                this.markManager();
            }
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        return skipped;
    }

    @Override
    public void write(byte[] b) throws IOException {
        if (this.outStream == null) {
            throw new HandleException("This stream is read-only.");
        }
        this.outStream.write(b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (this.outStream == null) {
            throw new HandleException("This stream is read-only.");
        }
        this.outStream.write(b, off, len);
    }

    @Override
    public void write(int b) throws IOException {
        if (this.outStream == null) {
            throw new HandleException("This stream is read-only.");
        }
        if (this.order.equals(ByteOrder.LITTLE_ENDIAN)) {
            b = Bytes.swap((int)b);
        }
        this.outStream.write(b);
    }

    @Override
    public void writeBoolean(boolean v) throws IOException {
        if (this.outStream == null) {
            throw new HandleException("This stream is read-only.");
        }
        this.outStream.writeBoolean(v);
    }

    @Override
    public void writeByte(int v) throws IOException {
        if (this.outStream == null) {
            throw new HandleException("This stream is read-only.");
        }
        if (this.order.equals(ByteOrder.LITTLE_ENDIAN)) {
            v = Bytes.swap((int)v);
        }
        this.outStream.writeByte(v);
    }

    @Override
    public void writeBytes(String s) throws IOException {
        if (this.outStream == null) {
            throw new HandleException("This stream is read-only.");
        }
        this.outStream.writeBytes(s);
    }

    @Override
    public void writeChar(int v) throws IOException {
        if (this.outStream == null) {
            throw new HandleException("This stream is read-only.");
        }
        if (this.order.equals(ByteOrder.LITTLE_ENDIAN)) {
            v = Bytes.swap((int)v);
        }
        this.outStream.writeChar(v);
    }

    @Override
    public void writeChars(String s) throws IOException {
        if (this.outStream == null) {
            throw new HandleException("This stream is read-only.");
        }
        this.outStream.writeChars(s);
    }

    @Override
    public void writeDouble(double v) throws IOException {
        if (this.outStream == null) {
            throw new HandleException("This stream is read-only.");
        }
        if (this.order.equals(ByteOrder.LITTLE_ENDIAN)) {
            v = Bytes.swap((double)v);
        }
        this.outStream.writeDouble(v);
    }

    @Override
    public void writeFloat(float v) throws IOException {
        if (this.outStream == null) {
            throw new HandleException("This stream is read-only.");
        }
        if (this.order.equals(ByteOrder.LITTLE_ENDIAN)) {
            v = Bytes.swap((float)v);
        }
        this.outStream.writeFloat(v);
    }

    @Override
    public void writeInt(int v) throws IOException {
        if (this.outStream == null) {
            throw new HandleException("This stream is read-only.");
        }
        if (this.order.equals(ByteOrder.LITTLE_ENDIAN)) {
            v = Bytes.swap((int)v);
        }
        this.outStream.writeInt(v);
    }

    @Override
    public void writeLong(long v) throws IOException {
        if (this.outStream == null) {
            throw new HandleException("This stream is read-only.");
        }
        if (this.order.equals(ByteOrder.LITTLE_ENDIAN)) {
            v = Bytes.swap((long)v);
        }
        this.outStream.writeLong(v);
    }

    @Override
    public void writeShort(int v) throws IOException {
        if (this.outStream == null) {
            throw new HandleException("This stream is read-only.");
        }
        if (this.order.equals(ByteOrder.LITTLE_ENDIAN)) {
            v = Bytes.swap((int)v);
        }
        this.outStream.writeShort(v);
    }

    @Override
    public void writeUTF(String str) throws IOException {
        if (this.outStream == null) {
            throw new HandleException("This stream is read-only.");
        }
        this.outStream.writeUTF(str);
    }

    private void markManager() {
        if (this.fp >= this.mark + 0x100000L - 1L) {
            this.mark = this.fp;
            this.stream.mark(0x100000);
        }
    }
}

