/*
 * Decompiled with CFR 0.152.
 */
package io.scif.img.cell;

import io.scif.img.cell.SCIFIOCell;
import io.scif.img.cell.cache.CacheService;
import io.scif.img.cell.loaders.SCIFIOArrayLoader;
import io.scif.refs.RefManagerService;
import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.imglib2.img.basictypeaccess.array.ArrayDataAccess;
import org.scijava.Context;
import org.scijava.log.LogService;
import org.scijava.plugin.Parameter;
import org.scijava.thread.ThreadService;

public class SCIFIOCellCache<A extends ArrayDataAccess<A>> {
    @Parameter
    private CacheService<SCIFIOCell<?>> cacheService;
    @Parameter
    private RefManagerService refManagerService;
    @Parameter
    private ThreadService threadService;
    @Parameter
    private LogService logService;
    private final SCIFIOArrayLoader<A> loader;
    private final String cacheId = this.toString();
    private final Map<Integer, WeakReference<SCIFIOCell<A>>> map = new ConcurrentHashMap<Integer, WeakReference<SCIFIOCell<A>>>();

    public SCIFIOCellCache(Context context, SCIFIOArrayLoader<A> loader) {
        this.loader = loader;
        context.inject((Object)this);
        this.cacheService.addCache(this.cacheId);
        this.refManagerService.manage(this, new Object[0]);
    }

    public SCIFIOCell<A> get(int index) {
        SCIFIOCell<A> cell = this.checkCache(this.cacheId, index);
        if (cell != null) {
            return cell;
        }
        return null;
    }

    public SCIFIOCell<A> load(int index, int[] cellDims, long[] cellMin) {
        SCIFIOCell<Object> cell = this.checkCache(this.cacheId, index);
        if (cell != null) {
            return cell;
        }
        cell = new SCIFIOCell<ArrayDataAccess>(this.cacheService, this.cacheId, index, cellDims, cellMin, (ArrayDataAccess)this.loader.loadArray(cellDims, cellMin));
        this.refManagerService.manage(cell, new Object[0]);
        this.cache(this.cacheService.getKey(this.cacheId, index), cell);
        return cell;
    }

    public String getCacheId() {
        return this.cacheId;
    }

    private void cache(Integer k, SCIFIOCell<A> cell) {
        this.map.put(k, new WeakReference<SCIFIOCell<A>>(cell));
        this.refManagerService.manage(cell, new Object[]{k, this.map});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SCIFIOCell<A> checkCache(String id, int index) {
        SCIFIOCell<?> cell = null;
        Integer k = this.cacheService.getKey(id, index);
        WeakReference<SCIFIOCell<A>> ref = null;
        Map<Integer, WeakReference<SCIFIOCell<A>>> map = this.map;
        synchronized (map) {
            ref = this.map.get(k);
        }
        if (ref != null) {
            cell = (SCIFIOCell<?>)((Object)ref.get());
        } else {
            map = this.map;
            synchronized (map) {
                this.map.remove(k);
            }
        }
        if (cell == null && (cell = this.cacheService.retrieve(id, index)) != null) {
            this.cache(k, cell);
        }
        return cell;
    }
}

