/*
 * Decompiled with CFR 0.152.
 */
package io.scif.formats.qt;

import io.scif.AbstractFormat;
import io.scif.AbstractMetadata;
import io.scif.AbstractParser;
import io.scif.ByteArrayPlane;
import io.scif.ByteArrayReader;
import io.scif.Format;
import io.scif.FormatException;
import io.scif.HasColorTable;
import io.scif.ImageMetadata;
import io.scif.codec.CodecOptions;
import io.scif.codec.CodecService;
import io.scif.codec.JPEGCodec;
import io.scif.codec.PackbitsCodec;
import io.scif.config.SCIFIOConfig;
import io.scif.formats.qt.QTJavaService;
import io.scif.gui.AWTImageTools;
import io.scif.io.ByteArrayHandle;
import io.scif.io.RandomAccessInputStream;
import java.io.IOException;
import java.util.Vector;
import net.imagej.axis.Axes;
import net.imagej.axis.CalibratedAxis;
import net.imagej.axis.DefaultLinearAxis;
import net.imglib2.display.ColorTable;
import net.imglib2.display.ColorTable8;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.scijava.util.Bytes;

@Plugin(type=Format.class, name="PICT")
public class PICTFormat
extends AbstractFormat {
    private static final int PICT_CLIP_RGN = 1;
    private static final int PICT_BITSRECT = 144;
    private static final int PICT_BITSRGN = 145;
    private static final int PICT_PACKBITSRECT = 152;
    private static final int PICT_PACKBITSRGN = 153;
    private static final int PICT_9A = 154;
    private static final int PICT_END = 255;
    private static final int PICT_LONGCOMMENT = 161;
    private static final int PICT_JPEG = 24;
    private static final int PICT_TYPE_1 = 2719;
    private static final int PICT_TYPE_2 = 37264;
    private static final byte[] EXPANSION_TABLE = new byte[2048];
    private boolean legacy;

    public void setLegacy(boolean legacy) {
        this.legacy = legacy;
    }

    public boolean isLegacy() {
        return this.legacy;
    }

    @Override
    protected String[] makeSuffixArray() {
        return new String[]{"pict", "pct"};
    }

    static {
        for (int i = 0; i < 256; ++i) {
            for (int j = 0; j < 8; ++j) {
                PICTFormat.EXPANSION_TABLE[i * 8 + j] = (byte)((i & (int)Math.pow(2.0, 7 - j)) >> 7 - j);
            }
        }
    }

    public static class Reader
    extends ByteArrayReader<Metadata> {
        @Parameter
        private QTJavaService qtJavaService;
        @Parameter
        private CodecService codecService;

        @Override
        protected String[] createDomainArray() {
            return new String[]{"Graphics"};
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ByteArrayPlane openPlane(int imageIndex, long planeIndex, ByteArrayPlane plane, long[] planeMin, long[] planeMax, SCIFIOConfig config) throws FormatException, IOException {
            Metadata meta = (Metadata)this.getMetadata();
            plane.setColorTable(meta.getColorTable(imageIndex, planeIndex));
            byte[] buf = plane.getBytes();
            if (meta.getJpegOffsets().size() > 0) {
                ByteArrayHandle v = new ByteArrayHandle();
                this.getStream().seek(meta.getJpegOffsets().get(0));
                byte[] b = new byte[(int)(this.getStream().length() - this.getStream().getFilePointer())];
                this.getStream().read(b);
                RandomAccessInputStream s = new RandomAccessInputStream(this.getContext(), b);
                for (long jpegOffset : meta.getJpegOffsets()) {
                    s.seek(jpegOffset - meta.getJpegOffsets().get(0));
                    CodecOptions options = new CodecOptions();
                    options.interleaved = meta.get(0).getInterleavedAxisCount() > 0;
                    options.littleEndian = meta.get(0).isLittleEndian();
                    JPEGCodec codec = this.codecService.getCodec(JPEGCodec.class);
                    v.write(codec.decompress(s, options));
                }
                s.close();
                s = new RandomAccessInputStream(this.getContext(), v);
                s.seek(0L);
                try {
                    this.readPlane(s, imageIndex, planeMin, planeMax, plane);
                }
                finally {
                    s.close();
                }
                return plane;
            }
            if (((PICTFormat)this.getFormat()).isLegacy() || meta.getStrips().size() == 0) {
                this.getStream().seek(512L);
                byte[] pix = new byte[(int)(this.getStream().length() - this.getStream().getFilePointer())];
                this.getStream().read(pix);
                byte[][] b = AWTImageTools.getBytes(AWTImageTools.makeBuffered(this.qtJavaService.pictToImage(pix)));
                pix = null;
                for (int i = 0; i < b.length; ++i) {
                    System.arraycopy(b[i], 0, buf, i * b[i].length, b[i].length);
                }
                b = null;
                return plane;
            }
            if (meta.get(0).getAxisLength(Axes.Y) * 4L < (long)meta.getStrips().size() && (long)(meta.getStrips().size() / 3) % meta.get(0).getAxisLength(Axes.Y) != 0L) {
                meta.get(0).setAxisLength(Axes.Y, (long)meta.getStrips().size());
            }
            int xAxis = meta.get(imageIndex).getAxisIndex(Axes.X);
            int yAxis = meta.get(imageIndex).getAxisIndex(Axes.Y);
            int x = (int)planeMin[xAxis];
            int y = (int)planeMin[yAxis];
            int w = (int)planeMax[xAxis];
            int h = (int)planeMax[yAxis];
            int planeSize = w * h;
            if (meta.getLookup() != null) {
                for (int i = y; i < y + h; ++i) {
                    byte[] row = (byte[])meta.getStrips().get(i);
                    int len = Math.min(row.length, w);
                    System.arraycopy(row, x, buf, (i - y) * w, len);
                }
            } else if (meta.get(0).getAxisLength(Axes.Y) * 3L == (long)meta.getStrips().size() || meta.get(0).getAxisLength(Axes.Y) * 4L == (long)meta.getStrips().size()) {
                int nc = meta.getStrips().size() / (int)meta.get(0).getAxisLength(Axes.Y);
                byte[] c0 = null;
                byte[] c1 = null;
                byte[] c2 = null;
                for (int i = y; i < h + y; ++i) {
                    c0 = (byte[])meta.getStrips().get(i * nc + nc - 3);
                    c1 = (byte[])meta.getStrips().get(i * nc + nc - 2);
                    c2 = (byte[])meta.getStrips().get(i * nc + nc - 1);
                    int baseOffset = (i - y) * w;
                    System.arraycopy(c0, x, buf, baseOffset, w);
                    System.arraycopy(c1, x, buf, planeSize + baseOffset, w);
                    System.arraycopy(c2, x, buf, 2 * planeSize + baseOffset, w);
                }
            } else {
                int[] row = null;
                for (int i = y; i < h + y; ++i) {
                    row = (int[])meta.getStrips().get(i);
                    for (int j = x; j < w + x; ++j) {
                        int base = (i - y) * w + (j - x);
                        buf[base] = (byte)((row[j] & 0x7C00) >> 10);
                        buf[planeSize + base] = (byte)((row[j] & 0x3E0) >> 5);
                        buf[2 * planeSize + base] = (byte)(row[j] & 0x1F);
                    }
                }
            }
            return plane;
        }
    }

    public static class Parser
    extends AbstractParser<Metadata> {
        @Parameter
        private CodecService codecService;

        @Override
        protected void typedParse(RandomAccessInputStream stream, Metadata meta, SCIFIOConfig config) throws IOException, FormatException {
            int opcode;
            meta.createImageMetadata(1);
            ImageMetadata iMeta = meta.get(0);
            stream.seek(518L);
            short sizeY = stream.readShort();
            short sizeX = stream.readShort();
            Vector<Object> strips = new Vector<Object>();
            byte[][] lookup = null;
            boolean versionOne = false;
            meta.setStrips(strips);
            meta.setLookup(lookup);
            meta.setRowBytes(0);
            int verOpcode = stream.read();
            int verNumber = stream.read();
            if (verOpcode == 17 && verNumber == 1) {
                versionOne = true;
            } else if (verOpcode == 0 && verNumber == 17) {
                versionOne = false;
                short verNumber2 = stream.readShort();
                if (verNumber2 != 767) {
                    throw new FormatException("Invalid PICT file : " + verNumber2);
                }
                stream.skipBytes(6);
                int pixelsPerInchX = stream.readInt();
                int pixelsPerInchY = stream.readInt();
                iMeta.addAxis((CalibratedAxis)new DefaultLinearAxis(Axes.X, "in", (double)pixelsPerInchX));
                iMeta.addAxis((CalibratedAxis)new DefaultLinearAxis(Axes.Y, "in", (double)pixelsPerInchY));
                stream.skipBytes(4);
                short y = stream.readShort();
                short x = stream.readShort();
                if (x > 0) {
                    sizeX = x;
                }
                if (y > 0) {
                    sizeY = y;
                }
                stream.skipBytes(4);
            } else {
                throw new FormatException("Invalid PICT file");
            }
            iMeta.setAxisLength(Axes.X, (long)sizeX);
            iMeta.setAxisLength(Axes.Y, (long)sizeY);
            meta.getTable().put("Version", versionOne ? 1 : 2);
            meta.setVersionOne(versionOne);
            do {
                if (versionOne) {
                    opcode = stream.read();
                    continue;
                }
                if ((stream.getFilePointer() & 1L) != 0L) {
                    stream.skipBytes(1);
                }
                if (stream.getFilePointer() + 2L >= stream.length()) break;
                opcode = stream.readShort() & 0xFFFF;
            } while (this.drivePictDecoder(meta, opcode));
        }

        private boolean drivePictDecoder(Metadata meta, int opcode) throws FormatException, IOException {
            this.log().debug((Object)("drivePictDecoder(" + opcode + ") @ " + this.getSource().getFilePointer()));
            switch (opcode) {
                case 144: 
                case 145: 
                case 152: 
                case 153: {
                    meta.setRowBytes(this.getSource().readShort());
                    if (meta.isVersionOne() || (meta.getRowBytes() & 0x8000) == 0) {
                        this.handleBitmap(meta, opcode);
                        break;
                    }
                    this.handlePixmap(meta, opcode);
                    break;
                }
                case 154: {
                    this.handlePixmap(meta, opcode);
                    break;
                }
                case 1: {
                    short x = this.getSource().readShort();
                    this.getSource().skipBytes(x - 2);
                    break;
                }
                case 161: {
                    this.getSource().skipBytes(2);
                    short x = this.getSource().readShort();
                    this.getSource().skipBytes(x);
                    break;
                }
                case 255: {
                    return false;
                }
                case 2719: 
                case 37264: {
                    int x = this.getSource().read();
                    this.getSource().skipBytes(x);
                    break;
                }
                case 24: {
                    meta.getJpegOffsets().add(this.getSource().getFilePointer() + 2L);
                    meta.get(0).setAxisLength(Axes.CHANNEL, 3L);
                    while ((this.getSource().readShort() & 0xFFFF) != 65497 && this.getSource().getFilePointer() < this.getSource().length()) {
                    }
                    while (this.getSource().getFilePointer() < this.getSource().length()) {
                        while ((this.getSource().readShort() & 0xFFFF) != 65496 && this.getSource().getFilePointer() < this.getSource().length()) {
                        }
                        if (this.getSource().getFilePointer() >= this.getSource().length()) continue;
                        meta.getJpegOffsets().add(this.getSource().getFilePointer() - 2L);
                    }
                    meta.get(0).setAxisTypes(Axes.CHANNEL, Axes.X, Axes.Y);
                    break;
                }
                default: {
                    if (opcode >= 0) break;
                    this.log().warn((Object)("Invalid opcode: " + opcode));
                }
            }
            return this.getSource().getFilePointer() < this.getSource().length();
        }

        private void handleBitmap(Metadata meta, int opcode) throws FormatException, IOException {
            this.readImageHeader(meta, opcode);
            this.handlePixmap(meta, 1, 1);
        }

        private void handlePixmap(Metadata meta, int opcode) throws FormatException, IOException {
            short compCount;
            short pixelSize;
            block7: {
                block6: {
                    this.readImageHeader(meta, opcode);
                    this.log().debug((Object)("handlePixmap(" + opcode + ")"));
                    pixelSize = this.getSource().readShort();
                    compCount = this.getSource().readShort();
                    this.getSource().skipBytes(14);
                    if (opcode != 154) break block6;
                    switch (pixelSize) {
                        case 32: {
                            meta.setRowBytes((int)meta.get(0).getAxisLength(Axes.X) * compCount);
                            break block7;
                        }
                        case 16: {
                            meta.setRowBytes((int)meta.get(0).getAxisLength(Axes.X) * 2);
                            break block7;
                        }
                        default: {
                            throw new FormatException("Sorry, vector data not supported.");
                        }
                    }
                }
                this.getSource().skipBytes(4);
                this.getSource().readShort();
                int count = this.getSource().readShort();
                byte[][] lookup = new byte[3][++count];
                for (int i = 0; i < count; ++i) {
                    this.getSource().skipBytes(2);
                    lookup[0][i] = this.getSource().readByte();
                    this.getSource().skipBytes(1);
                    lookup[1][i] = this.getSource().readByte();
                    this.getSource().skipBytes(1);
                    lookup[2][i] = this.getSource().readByte();
                    this.getSource().skipBytes(1);
                }
                meta.setLookup(lookup);
            }
            this.getSource().skipBytes(18);
            if (opcode == 145 || opcode == 153) {
                this.getSource().skipBytes(2);
            }
            this.handlePixmap(meta, pixelSize, compCount);
        }

        private void handlePixmap(Metadata meta, int pixelSize, int compCount) throws FormatException, IOException {
            this.log().debug((Object)("handlePixmap(" + meta.getRowBytes() + ", " + pixelSize + ", " + compCount + ")"));
            byte[] uBuf = null;
            int[] uBufI = null;
            int bufSize = meta.getRowBytes();
            int outBufSize = (int)meta.get(0).getAxisLength(Axes.X);
            byte[] outBuf = null;
            boolean compressed = meta.getRowBytes() >= 8 || pixelSize == 32;
            switch (pixelSize) {
                case 32: {
                    if (!compressed) {
                        uBufI = new int[(int)meta.get(0).getAxisLength(Axes.X)];
                        break;
                    }
                    uBuf = new byte[bufSize];
                    break;
                }
                case 16: {
                    uBufI = new int[(int)meta.get(0).getAxisLength(Axes.X)];
                    break;
                }
                case 8: {
                    uBuf = new byte[bufSize];
                    break;
                }
                default: {
                    outBuf = new byte[outBufSize];
                    uBuf = new byte[bufSize];
                }
            }
            if (!compressed) {
                this.log().debug((Object)("Pixel data is uncompressed (pixelSize=" + pixelSize + ")."));
                byte[] buf = new byte[bufSize];
                int row = 0;
                while ((long)row < meta.get(0).getAxisLength(Axes.X)) {
                    this.getSource().read(buf, 0, meta.getRowBytes());
                    switch (pixelSize) {
                        case 16: {
                            int i = 0;
                            while ((long)i < meta.get(0).getAxisLength(Axes.X)) {
                                uBufI[i] = Bytes.toShort((byte[])buf, (int)(i * 2), (int)2, (boolean)false);
                                ++i;
                            }
                            meta.getStrips().add(uBufI);
                            buf = null;
                            meta.get(0).setAxisLength(Axes.CHANNEL, 3L);
                            break;
                        }
                        case 8: {
                            meta.getStrips().add(buf);
                            break;
                        }
                        default: {
                            this.expandPixels(pixelSize, buf, outBuf, outBuf.length);
                            meta.getStrips().add(outBuf);
                            buf = null;
                        }
                    }
                    ++row;
                }
            } else {
                this.log().debug((Object)("Pixel data is compressed (pixelSize=" + pixelSize + "; compCount=" + compCount + ")."));
                byte[] buf = new byte[bufSize + 1 + bufSize / 128];
                int row = 0;
                while ((long)row < meta.get(0).getAxisLength(Axes.Y)) {
                    int rawLen = meta.getRowBytes() > 250 ? this.getSource().readShort() : this.getSource().read();
                    if (rawLen > buf.length) {
                        rawLen = buf.length;
                    }
                    if (this.getSource().length() - this.getSource().getFilePointer() <= (long)rawLen) {
                        rawLen = (int)(this.getSource().length() - this.getSource().getFilePointer() - 1L);
                    }
                    if (rawLen < 0) {
                        rawLen = 0;
                        this.getSource().seek(this.getSource().length() - 1L);
                    }
                    this.getSource().read(buf, 0, rawLen);
                    if (pixelSize == 16) {
                        uBufI = new int[(int)meta.get(0).getAxisLength(Axes.X)];
                        this.unpackBits(buf, uBufI);
                        meta.getStrips().add(uBufI);
                        meta.get(0).setAxisLength(Axes.CHANNEL, 3L);
                    } else {
                        PackbitsCodec c = this.codecService.getCodec(PackbitsCodec.class);
                        CodecOptions options = new CodecOptions();
                        options.maxBytes = (int)meta.get(0).getAxisLength(Axes.X) * 4;
                        uBuf = c.decompress(buf, options);
                    }
                    if (pixelSize < 8) {
                        this.expandPixels(pixelSize, uBuf, outBuf, outBuf.length);
                        meta.getStrips().add(outBuf);
                    } else if (pixelSize == 8) {
                        meta.getStrips().add(uBuf);
                    } else if (pixelSize == 24 || pixelSize == 32) {
                        byte[] newBuf = null;
                        for (int q = 0; q < compCount; ++q) {
                            int offset = q * (int)meta.get(0).getAxisLength(Axes.X);
                            int len = Math.min((int)meta.get(0).getAxisLength(Axes.X), uBuf.length - offset);
                            newBuf = new byte[(int)meta.get(0).getAxisLength(Axes.X)];
                            if (offset < uBuf.length) {
                                System.arraycopy(uBuf, offset, newBuf, 0, len);
                            }
                            meta.getStrips().add(newBuf);
                        }
                        meta.get(0).setAxisLength(Axes.CHANNEL, 3L);
                    }
                    ++row;
                }
            }
        }

        private void readImageHeader(Metadata meta, int opcode) throws IOException {
            int rowBytes = meta.getRowBytes();
            if (opcode == 154) {
                this.getSource().skipBytes(6);
            } else {
                rowBytes &= 0x3FFF;
            }
            meta.setRowBytes(rowBytes);
            short tlY = this.getSource().readShort();
            short tlX = this.getSource().readShort();
            short brY = this.getSource().readShort();
            short brX = this.getSource().readShort();
            if (brX - tlX > 0) {
                meta.get(0).setAxisLength(Axes.X, (long)(brX - tlX));
            }
            if (brY - tlY > 0) {
                meta.get(0).setAxisLength(Axes.Y, (long)(brY - tlY));
            }
            this.getSource().skipBytes(18);
        }

        private void expandPixels(int bitSize, byte[] ib, byte[] ob, int outLen) throws FormatException {
            this.log().debug((Object)("expandPixels(" + bitSize + ", " + ib.length + ", " + ob.length + ", " + outLen + ")"));
            if (bitSize == 1) {
                int remainder = outLen % 8;
                int max = outLen / 8;
                for (int i = 0; i < max; ++i) {
                    if (i < ib.length) {
                        int look = (ib[i] & 0xFF) * 8;
                        System.arraycopy(EXPANSION_TABLE, look, ob, i * 8, 8);
                        continue;
                    }
                    i = max;
                }
                if (remainder != 0 && max < ib.length) {
                    System.arraycopy(EXPANSION_TABLE, (ib[max] & 0xFF) * 8, ob, max * 8, remainder);
                }
                return;
            }
            int count = 8 / bitSize;
            int maskshift = bitSize;
            int pixelshift = 8 - bitSize;
            int tpixelshift = 0;
            int pixelshiftdelta = bitSize;
            if (bitSize != 1 && bitSize != 2 && bitSize != 4) {
                throw new FormatException("Can only expand 1, 2, and 4 bit values");
            }
            int mask = (int)Math.pow(2.0, bitSize) - 1 << 8 - bitSize;
            int i = 0;
            int o = 0;
            while (o < ob.length) {
                int tmask = mask;
                tpixelshift = pixelshift;
                byte v = ib[i];
                for (int t = 0; t < count && o < ob.length; ++t, ++o) {
                    ob[o] = (byte)((v & tmask) >>> tpixelshift & 0xFF);
                    tmask = (byte)((tmask & 0xFF) >>> maskshift);
                    tpixelshift -= pixelshiftdelta;
                }
                ++i;
            }
        }

        private void unpackBits(byte[] ib, int[] ob) {
            this.log().debug((Object)"unpackBits(...)");
            int i = 0;
            int o = 0;
            while (o < ob.length) {
                if (i + 1 < ib.length) {
                    int end;
                    byte b;
                    if ((b = ib[i++]) >= 0) {
                        end = o + b + 1;
                        while (o < end && o < ob.length && i + 1 < ib.length) {
                            ob[o++] = Bytes.toShort((byte[])ib, (int)i, (int)2, (boolean)false);
                            i += 2;
                        }
                        continue;
                    }
                    if (b == -128) continue;
                    short rep = Bytes.toShort((byte[])ib, (int)i, (int)2, (boolean)false);
                    i += 2;
                    end = o - b + 1;
                    while (o < end && o < ob.length) {
                        ob[o++] = rep;
                    }
                    continue;
                }
                o = ob.length;
            }
        }
    }

    public static class Metadata
    extends AbstractMetadata
    implements HasColorTable {
        private int rowBytes;
        private Vector<Object> strips;
        private boolean versionOne;
        private byte[][] lookup;
        private Vector<Long> jpegOffsets = new Vector();

        public int getRowBytes() {
            return this.rowBytes;
        }

        public void setRowBytes(int rowBytes) {
            this.rowBytes = rowBytes;
        }

        public Vector<Object> getStrips() {
            return this.strips;
        }

        public void setStrips(Vector<Object> strips) {
            this.strips = strips;
        }

        public boolean isVersionOne() {
            return this.versionOne;
        }

        public void setVersionOne(boolean versionOne) {
            this.versionOne = versionOne;
        }

        public byte[][] getLookup() {
            return this.lookup;
        }

        public void setLookup(byte[][] lookup) {
            this.lookup = lookup;
        }

        public Vector<Long> getJpegOffsets() {
            return this.jpegOffsets;
        }

        public void setJpegOffsets(Vector<Long> jpegOffsets) {
            this.jpegOffsets = jpegOffsets;
        }

        @Override
        public void populateImageMetadata() {
            ImageMetadata iMeta = this.get(0);
            int planarAxes = 2;
            if (iMeta.getAxisLength(Axes.CHANNEL) > 1L) {
                planarAxes = 3;
            }
            iMeta.setPlanarAxisCount(planarAxes);
            iMeta.setLittleEndian(false);
            iMeta.setFalseColor(false);
            iMeta.setMetadataComplete(true);
            iMeta.setPixelType(1);
            iMeta.setBitsPerPixel(8);
            iMeta.setIndexed(!iMeta.isMultichannel() && this.lookup != null);
        }

        @Override
        public void close(boolean fileOnly) throws IOException {
            super.close(fileOnly);
            if (!fileOnly) {
                this.rowBytes = 0;
                this.strips = null;
                this.versionOne = false;
                this.lookup = null;
                if (this.jpegOffsets != null) {
                    this.jpegOffsets.clear();
                } else {
                    this.jpegOffsets = new Vector();
                }
            }
        }

        @Override
        public ColorTable getColorTable(int imageIndex, long planeIndex) {
            return this.lookup == null ? null : new ColorTable8(this.lookup);
        }
    }
}

