/*
 * Decompiled with CFR 0.152.
 */
package io.scif.codec;

import io.scif.FormatException;
import io.scif.codec.AbstractCodec;
import io.scif.codec.Codec;
import io.scif.codec.CodecOptions;
import io.scif.codec.CodecService;
import io.scif.codec.LosslessJPEGCodec;
import io.scif.gui.AWTImageTools;
import io.scif.io.RandomAccessInputStream;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import javax.imageio.ImageIO;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.scijava.util.Bytes;

@Plugin(type=Codec.class)
public class JPEGCodec
extends AbstractCodec {
    @Parameter
    private CodecService codecService;

    @Override
    public byte[] compress(byte[] data, CodecOptions options) throws FormatException {
        if (data == null || data.length == 0) {
            return data;
        }
        if (options == null) {
            options = CodecOptions.getDefaultOptions();
        }
        if (options.bitsPerSample > 8) {
            throw new FormatException("> 8 bit data cannot be compressed with JPEG.");
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        BufferedImage img = AWTImageTools.makeImage(data, options.width, options.height, options.channels, options.interleaved, options.bitsPerSample / 8, false, options.littleEndian, options.signed);
        try {
            ImageIO.write((RenderedImage)img, "jpeg", out);
        }
        catch (IOException e) {
            throw new FormatException("Could not write JPEG data", e);
        }
        return out.toByteArray();
    }

    @Override
    public byte[] decompress(RandomAccessInputStream in, CodecOptions options) throws FormatException, IOException {
        int i;
        BufferedImage b;
        long fp = in.getFilePointer();
        try {
            try {
                while (in.read() != -1 || in.read() != -40) {
                }
                in.seek(in.getFilePointer() - 2L);
            }
            catch (EOFException e) {
                in.seek(fp);
            }
            b = ImageIO.read(new BufferedInputStream(new DataInputStream(in), 8192));
        }
        catch (IOException exc) {
            in.seek(fp);
            LosslessJPEGCodec codec = this.codecService.getCodec(LosslessJPEGCodec.class);
            return codec.decompress(in, options);
        }
        if (options == null) {
            options = CodecOptions.getDefaultOptions();
        }
        byte[][] buf = AWTImageTools.getPixelBytes(b, options.littleEndian);
        if (options.ycbcr && buf.length == 3) {
            int nBytes = buf[0].length / (b.getWidth() * b.getHeight());
            int mask = (int)(Math.pow(2.0, nBytes * 8) - 1.0);
            for (i = 0; i < buf[0].length; i += nBytes) {
                int y = Bytes.toInt((byte[])buf[0], (int)i, (int)nBytes, (boolean)options.littleEndian);
                int cb = Bytes.toInt((byte[])buf[1], (int)i, (int)nBytes, (boolean)options.littleEndian);
                int cr = Bytes.toInt((byte[])buf[2], (int)i, (int)nBytes, (boolean)options.littleEndian);
                cb = Math.max(0, cb - 128);
                cr = Math.max(0, cr - 128);
                int red = (int)((double)y + 1.402 * (double)cr) & mask;
                int green = (int)((double)y - 0.34414 * (double)cb - 0.71414 * (double)cr) & mask;
                int blue = (int)((double)y + 1.772 * (double)cb) & mask;
                Bytes.unpack((long)red, (byte[])buf[0], (int)i, (int)nBytes, (boolean)options.littleEndian);
                Bytes.unpack((long)green, (byte[])buf[1], (int)i, (int)nBytes, (boolean)options.littleEndian);
                Bytes.unpack((long)blue, (byte[])buf[2], (int)i, (int)nBytes, (boolean)options.littleEndian);
            }
        }
        byte[] rtn = new byte[buf.length * buf[0].length];
        if (buf.length == 1) {
            rtn = buf[0];
        } else if (options.interleaved) {
            int next = 0;
            for (i = 0; i < buf[0].length; ++i) {
                for (int j = 0; j < buf.length; ++j) {
                    rtn[next++] = buf[j][i];
                }
            }
        } else {
            for (int i2 = 0; i2 < buf.length; ++i2) {
                System.arraycopy(buf[i2], 0, rtn, i2 * buf[0].length, buf[i2].length);
            }
        }
        return rtn;
    }
}

