/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.plugins.commands.imglib;

import java.util.ArrayList;
import net.imagej.Dataset;
import net.imagej.ImgPlus;
import net.imagej.ImgPlusMetadata;
import net.imagej.axis.Axes;
import net.imagej.display.ImageDisplay;
import net.imagej.display.ImageDisplayService;
import net.imagej.display.OverlayService;
import net.imagej.overlay.Overlay;
import net.imagej.overlay.ThresholdOverlay;
import net.imglib2.Cursor;
import net.imglib2.RandomAccess;
import net.imglib2.img.Img;
import net.imglib2.type.numeric.RealType;
import org.scijava.ItemIO;
import org.scijava.command.Command;
import org.scijava.command.ContextCommand;
import org.scijava.plugin.Attr;
import org.scijava.plugin.Menu;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.scijava.util.RealRect;

@Plugin(type=Command.class, menu={@Menu(label="Image", weight=2.0, mnemonic=105), @Menu(label="Crop", accelerator="shift ^X")}, headless=true, attrs={@Attr(name="no-legacy")})
public class CropImage
extends ContextCommand {
    @Parameter
    private ImageDisplayService imageDisplayService;
    @Parameter
    private OverlayService overlayService;
    @Parameter(type=ItemIO.BOTH)
    private ImageDisplay display;
    private Img inputImage;
    private long minX;
    private long maxX;
    private long minY;
    private long maxY;
    private int xIndex;
    private int yIndex;
    private Img<? extends RealType<?>> outputImage;

    public void run() {
        Dataset dataset = this.imageDisplayService.getActiveDataset(this.display);
        RealRect bounds = this.overlayService.getSelectionBounds(this.display);
        if (bounds.width == 0.0) {
            bounds.width = 1.0;
        }
        if (bounds.height == 0.0) {
            bounds.height = 1.0;
        }
        ImgPlus<? extends RealType<?>> croppedData = this.generateCroppedData(dataset, bounds);
        double[] toNewOrigin = new double[]{-bounds.x, -bounds.y};
        ArrayList<Overlay> newOverlays = new ArrayList<Overlay>();
        for (Overlay overlay : this.overlayService.getOverlays(this.display)) {
            Overlay newOverlay = null;
            if (!(overlay instanceof ThresholdOverlay) && this.overlayContained(overlay, bounds)) {
                newOverlay = overlay.duplicate();
                newOverlay.move(toNewOrigin);
                newOverlays.add(newOverlay);
            }
            if (overlay instanceof ThresholdOverlay) continue;
            this.overlayService.removeOverlay(this.display, overlay);
        }
        dataset.setImgPlus(croppedData);
        this.overlayService.addOverlays(this.display, newOverlays);
    }

    public void setDisplay(ImageDisplay disp) {
        this.display = disp;
    }

    public ImageDisplay getDisplay() {
        return this.display;
    }

    private ImgPlus<? extends RealType<?>> generateCroppedData(Dataset ds, RealRect bounds) {
        this.setup(ds, bounds);
        this.copyPixels();
        ImgPlus newImgPlus = ImgPlus.wrap(this.outputImage, (ImgPlusMetadata)ds);
        this.copyColorTables(ds, newImgPlus);
        return newImgPlus;
    }

    private void setup(Dataset dataset, RealRect bounds) {
        this.inputImage = dataset.getImgPlus();
        this.minX = (long)bounds.x;
        this.minY = (long)bounds.y;
        this.maxX = (long)(bounds.x + bounds.width - 1.0);
        this.maxY = (long)(bounds.y + bounds.height - 1.0);
        this.xIndex = dataset.dimensionIndex(Axes.X);
        this.yIndex = dataset.dimensionIndex(Axes.Y);
        long[] newDimensions = new long[this.inputImage.numDimensions()];
        this.inputImage.dimensions(newDimensions);
        newDimensions[this.xIndex] = this.maxX - this.minX + 1L;
        newDimensions[this.yIndex] = this.maxY - this.minY + 1L;
        this.outputImage = this.inputImage.factory().create(newDimensions, this.inputImage.firstElement());
    }

    private void copyPixels() {
        RandomAccess inputAccessor = this.inputImage.randomAccess();
        Cursor outputCursor = this.outputImage.localizingCursor();
        long[] tmpPosition = new long[this.outputImage.numDimensions()];
        while (outputCursor.hasNext()) {
            outputCursor.next();
            outputCursor.localize(tmpPosition);
            int n = this.xIndex;
            tmpPosition[n] = tmpPosition[n] + this.minX;
            int n2 = this.yIndex;
            tmpPosition[n2] = tmpPosition[n2] + this.minY;
            inputAccessor.setPosition(tmpPosition);
            double value = ((RealType)inputAccessor.get()).getRealDouble();
            ((RealType)outputCursor.get()).setReal(value);
        }
    }

    private void copyColorTables(Dataset input, ImgPlus<?> output) {
        int count = input.getColorTableCount();
        output.initializeColorTables(count);
        for (int i = 0; i < count; ++i) {
            output.setColorTable(input.getColorTable(i), i);
        }
    }

    private boolean overlayContained(Overlay overlay, RealRect bounds) {
        if (overlay.realMin(0) < bounds.x) {
            return false;
        }
        if (overlay.realMin(1) < bounds.y) {
            return false;
        }
        if (overlay.realMax(0) > bounds.x + bounds.width) {
            return false;
        }
        return !(overlay.realMax(1) > bounds.y + bounds.height);
    }
}

