/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.ui.swing.updater;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import net.imagej.ui.swing.updater.DiffFile;
import net.imagej.ui.swing.updater.FileDetails;
import net.imagej.ui.swing.updater.FileTable;
import net.imagej.ui.swing.updater.ProgressDialog;
import net.imagej.ui.swing.updater.ResolveDependencies;
import net.imagej.ui.swing.updater.SitesDialog;
import net.imagej.ui.swing.updater.SwingTools;
import net.imagej.ui.swing.updater.ViewOptions;
import net.imagej.updater.Diff;
import net.imagej.updater.FileObject;
import net.imagej.updater.FilesCollection;
import net.imagej.updater.FilesUploader;
import net.imagej.updater.GroupAction;
import net.imagej.updater.Installer;
import net.imagej.updater.UploaderService;
import net.imagej.updater.action.InstallOrUpdate;
import net.imagej.updater.action.KeepAsIs;
import net.imagej.updater.action.Uninstall;
import net.imagej.updater.util.Progress;
import net.imagej.updater.util.UpdateCanceledException;
import net.imagej.updater.util.UpdaterUserInterface;
import net.imagej.updater.util.UpdaterUtil;
import org.scijava.Context;
import org.scijava.log.LogService;
import org.scijava.util.ProcessUtils;

public class UpdaterFrame
extends JFrame
implements TableModelListener,
ListSelectionListener {
    protected LogService log;
    private UploaderService uploaderService;
    protected FilesCollection files;
    protected JTextField searchTerm;
    protected JPanel searchPanel;
    protected ViewOptions viewOptions;
    protected JPanel viewOptionsPanel;
    protected JPanel chooseLabel;
    protected FileTable table;
    protected JLabel fileSummary;
    protected JPanel summaryPanel;
    protected JPanel rightPanel;
    protected FileDetails fileDetails;
    protected JPanel bottomPanel;
    protected JPanel bottomPanel2;
    protected JButton applyOrUpload;
    protected JButton cancel;
    protected JButton easy;
    protected JButton updateSites;
    protected boolean easyMode;
    protected JButton showChanges;
    protected JButton rebuildButton;
    protected boolean canUpload;
    protected static final String gitVersion;
    List<FileActionButton> fileActions = new ArrayList<FileActionButton>();
    private Thread filesChangedWorker;
    protected static final String[] units;

    public UpdaterFrame(final LogService log, UploaderService uploaderService, final FilesCollection files) {
        super("ImageJ Updater");
        this.setPreferredSize(new Dimension(780, 560));
        this.log = log;
        this.uploaderService = uploaderService;
        this.files = files;
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                UpdaterFrame.this.quit();
            }
        });
        JPanel leftPanel = new JPanel();
        GridBagLayout gb = new GridBagLayout();
        leftPanel.setLayout(gb);
        GridBagConstraints c = new GridBagConstraints(0, 0, 9, 1, 0.0, 0.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0);
        this.searchTerm = new JTextField();
        this.searchTerm.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                UpdaterFrame.this.updateFilesTable();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                UpdaterFrame.this.updateFilesTable();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                UpdaterFrame.this.updateFilesTable();
            }
        });
        this.searchPanel = SwingTools.labelComponentRigid("Search:", this.searchTerm);
        gb.setConstraints(this.searchPanel, c);
        leftPanel.add(this.searchPanel);
        Component box = Box.createRigidArea(new Dimension(0, 10));
        c.gridy = 1;
        gb.setConstraints(box, c);
        leftPanel.add(box);
        this.viewOptions = new ViewOptions();
        this.viewOptions.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UpdaterFrame.this.updateFilesTable();
            }
        });
        this.viewOptionsPanel = SwingTools.labelComponentRigid("View Options:", this.viewOptions);
        c.gridy = 2;
        gb.setConstraints(this.viewOptionsPanel, c);
        leftPanel.add(this.viewOptionsPanel);
        box = Box.createRigidArea(new Dimension(0, 10));
        c.gridy = 3;
        gb.setConstraints(box, c);
        leftPanel.add(box);
        this.chooseLabel = SwingTools.label("Please choose what you want to install/uninstall:", null);
        c.gridy = 4;
        gb.setConstraints(this.chooseLabel, c);
        leftPanel.add(this.chooseLabel);
        box = Box.createRigidArea(new Dimension(0, 5));
        c.gridy = 5;
        gb.setConstraints(box, c);
        leftPanel.add(box);
        this.fileSummary = new JLabel();
        this.summaryPanel = SwingTools.horizontalPanel();
        this.summaryPanel.add(this.fileSummary);
        this.summaryPanel.add(Box.createHorizontalGlue());
        this.table = new FileTable(this);
        this.table.getSelectionModel().addListSelectionListener(this);
        JScrollPane fileListScrollpane = new JScrollPane(this.table);
        fileListScrollpane.getViewport().setBackground(this.table.getBackground());
        c.gridy = 6;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 1;
        gb.setConstraints(fileListScrollpane, c);
        leftPanel.add(fileListScrollpane);
        box = Box.createRigidArea(new Dimension(0, 5));
        c.gridy = 7;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.fill = 2;
        gb.setConstraints(box, c);
        leftPanel.add(box);
        this.rightPanel = SwingTools.verticalPanel();
        this.rightPanel.add(Box.createVerticalGlue());
        this.fileDetails = new FileDetails(this);
        SwingTools.tab(this.fileDetails, "Details", "Individual file information", 350, 315, this.rightPanel);
        this.rightPanel.add(Box.createRigidArea(new Dimension(0, 25)));
        JPanel topPanel = SwingTools.horizontalPanel();
        topPanel.add(leftPanel);
        topPanel.add(Box.createRigidArea(new Dimension(15, 0)));
        topPanel.add(this.rightPanel);
        topPanel.setBorder(BorderFactory.createEmptyBorder(20, 15, 5, 15));
        this.bottomPanel2 = SwingTools.horizontalPanel();
        this.bottomPanel = SwingTools.horizontalPanel();
        this.bottomPanel.setBorder(BorderFactory.createEmptyBorder(5, 15, 15, 15));
        this.bottomPanel.add(new FileActionButton((GroupAction)new KeepAsIs()));
        this.bottomPanel.add(Box.createRigidArea(new Dimension(15, 0)));
        this.bottomPanel.add(new FileActionButton((GroupAction)new InstallOrUpdate()));
        this.bottomPanel.add(Box.createRigidArea(new Dimension(15, 0)));
        this.bottomPanel.add(new FileActionButton((GroupAction)new Uninstall()));
        this.bottomPanel.add(Box.createHorizontalGlue());
        final ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        SwingTools.invokeOnEDT(new Runnable(){

            @Override
            public void run() {
                if (contextClassLoader != null) {
                    Thread.currentThread().setContextClassLoader(contextClassLoader);
                }
            }
        });
        this.applyOrUpload = SwingTools.button("Apply changes", "Start installing/uninstalling/uploading files", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (files.hasUploadOrRemove()) {
                    new Thread(){

                        @Override
                        public void run() {
                            try {
                                UpdaterFrame.this.upload();
                            }
                            catch (InstantiationException e) {
                                log.error((Throwable)e);
                                UpdaterFrame.this.error("Could not upload (possibly unknown protocol)");
                            }
                        }
                    }.start();
                } else if (files.hasChanges()) {
                    UpdaterFrame.this.applyChanges();
                }
            }
        }, this.bottomPanel);
        this.enableApplyOrUpload();
        this.updateSites = SwingTools.button("Manage update sites", "Manage multiple update sites for updating and uploading", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                new SitesDialog(UpdaterFrame.this, UpdaterFrame.this.files).setVisible(true);
            }
        }, this.bottomPanel2);
        this.bottomPanel2.add(Box.createRigidArea(new Dimension(15, 0)));
        if (gitVersion != null) {
            this.bottomPanel2.add(Box.createRigidArea(new Dimension(15, 0)));
            this.showChanges = SwingTools.button("Show changes", "Show the differences to the uploaded version", new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    new Thread(){

                        @Override
                        public void run() {
                            for (FileObject file : UpdaterFrame.this.table.getSelectedFiles()) {
                                try {
                                    DiffFile diff = new DiffFile(files, file, Diff.Mode.LIST_FILES);
                                    diff.setLocationRelativeTo(UpdaterFrame.this);
                                    diff.setVisible(true);
                                }
                                catch (MalformedURLException e) {
                                    files.log.error((Throwable)e);
                                    UpdaterUserInterface.get().error("There was a problem obtaining the remote version of " + file.getLocalFilename(true));
                                }
                            }
                        }
                    }.start();
                }
            }, this.bottomPanel2);
        }
        this.bottomPanel2.add(Box.createHorizontalGlue());
        this.bottomPanel.add(Box.createRigidArea(new Dimension(15, 0)));
        this.easy = SwingTools.button("Toggle easy mode", "Toggle between easy and verbose mode", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UpdaterFrame.this.toggleEasyMode();
            }
        }, this.bottomPanel);
        this.bottomPanel.add(Box.createRigidArea(new Dimension(15, 0)));
        this.cancel = SwingTools.button("Close", "Exit Update Manager", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UpdaterFrame.this.quit();
            }
        }, this.bottomPanel);
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        this.getContentPane().add(topPanel);
        this.getContentPane().add(this.summaryPanel);
        this.getContentPane().add(this.bottomPanel);
        this.getContentPane().add(this.bottomPanel2);
        this.getRootPane().setDefaultButton(this.applyOrUpload);
        this.table.getModel().addTableModelListener(this);
        this.pack();
        SwingTools.addAccelerator(this.cancel, (JComponent)this.getContentPane(), this.cancel.getActionListeners()[0], 27, 0);
    }

    @Override
    public void setVisible(final boolean visible) {
        if (!SwingUtilities.isEventDispatchThread()) {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        UpdaterFrame.this.setVisible(visible);
                    }
                });
            }
            catch (InterruptedException interruptedException) {
            }
            catch (InvocationTargetException e) {
                this.log.error((Throwable)e);
            }
            return;
        }
        this.showOrHide();
        super.setVisible(visible);
        if (visible) {
            UpdaterUserInterface.get().addWindow((Frame)this);
            this.applyOrUpload.requestFocusInWindow();
        }
    }

    @Override
    public void dispose() {
        UpdaterUserInterface.get().removeWindow((Frame)this);
        super.dispose();
    }

    public Progress getProgress(String title) {
        return new ProgressDialog((Frame)this, title);
    }

    private void setClassLoaderIfNecessary() {
        ClassLoader thisLoader = this.getClass().getClassLoader();
        for (ClassLoader loader = Thread.currentThread().getContextClassLoader(); loader != null; loader = loader.getParent()) {
            if (thisLoader != loader) continue;
            return;
        }
        Thread.currentThread().setContextClassLoader(thisLoader);
    }

    public UploaderService getUploaderService() {
        if (this.uploaderService == null) {
            this.setClassLoaderIfNecessary();
            Context context = new Context(new Class[]{UploaderService.class});
            this.uploaderService = (UploaderService)context.getService(UploaderService.class);
        }
        return this.uploaderService;
    }

    @Override
    public void valueChanged(ListSelectionEvent event) {
        this.filesChanged();
    }

    public void addCustomViewOptions() {
        this.viewOptions.clearCustomOptions();
        Collection names = this.files.getUpdateSiteNames(false);
        if (names.size() > 1) {
            for (String name : names) {
                this.viewOptions.addCustomOption("View files of the '" + name + "' site", this.files.forUpdateSite(name));
            }
        }
    }

    public void setViewOption(final ViewOptions.Option option) {
        SwingTools.invokeOnEDT(new Runnable(){

            @Override
            public void run() {
                UpdaterFrame.this.viewOptions.setSelectedItem((Object)option);
                UpdaterFrame.this.updateFilesTable();
            }
        });
    }

    public void updateFilesTable() {
        SwingTools.invokeOnEDT(new Runnable(){

            @Override
            public void run() {
                Iterable view = UpdaterFrame.this.viewOptions.getView(UpdaterFrame.this.table);
                HashSet<FileObject> selected = new HashSet<FileObject>();
                for (FileObject file : UpdaterFrame.this.table.getSelectedFiles()) {
                    selected.add(file);
                }
                UpdaterFrame.this.table.clearSelection();
                String search = UpdaterFrame.this.searchTerm.getText().trim();
                if (!search.equals("")) {
                    view = FilesCollection.filter((String)search, view);
                }
                UpdaterFrame.this.table.setFiles(view);
                for (int i = 0; i < UpdaterFrame.this.table.getRowCount(); ++i) {
                    if (!selected.contains(UpdaterFrame.this.table.getFile(i))) continue;
                    UpdaterFrame.this.table.addRowSelectionInterval(i, i);
                }
            }
        });
    }

    public void applyChanges() {
        ResolveDependencies resolver = new ResolveDependencies(this, this.files);
        if (!resolver.resolve()) {
            return;
        }
        new Thread(){

            @Override
            public void run() {
                UpdaterFrame.this.install();
            }
        }.start();
    }

    private void quit() {
        if (this.files.hasChanges()) {
            if (!SwingTools.showQuestion(this, "Quit?", "You have specified changes. Are you sure you want to quit?")) {
                return;
            }
        } else {
            try {
                this.files.write();
            }
            catch (Exception e) {
                this.error("There was an error writing the local metadata cache: " + e);
            }
        }
        this.dispose();
    }

    public void setEasyMode(boolean easyMode) {
        this.easyMode = easyMode;
        this.showOrHide();
        if (this.isVisible()) {
            this.repaint();
        }
    }

    protected void showOrHide() {
        boolean uploadable;
        if (!this.easyMode && this.table.getRowCount() == 0 && this.viewOptions.getSelectedItem() == ViewOptions.Option.UPDATEABLE) {
            this.viewOptions.setSelectedItem((Object)ViewOptions.Option.ALL);
            ArrayList keys = new ArrayList();
            keys.add(new RowSorter.SortKey(1, SortOrder.ASCENDING));
            keys.add(new RowSorter.SortKey(2, SortOrder.ASCENDING));
            this.table.getRowSorter().setSortKeys(keys);
        }
        for (FileActionButton action : this.fileActions) {
            action.setVisible(!this.easyMode);
        }
        this.searchPanel.setVisible(!this.easyMode);
        this.viewOptionsPanel.setVisible(!this.easyMode);
        this.chooseLabel.setVisible(!this.easyMode);
        this.summaryPanel.setVisible(!this.easyMode);
        this.rightPanel.setVisible(!this.easyMode);
        if (this.easyMode) {
            this.bottomPanel.add((Component)this.updateSites, 0);
        } else {
            this.bottomPanel2.add((Component)this.updateSites, 0);
        }
        boolean bl = uploadable = !this.easyMode && this.files.hasUploadableSites();
        if (this.showChanges != null) {
            this.showChanges.setVisible(!this.easyMode && gitVersion != null);
        }
        if (this.rebuildButton != null) {
            this.rebuildButton.setVisible(uploadable);
        }
        this.easy.setText(this.easyMode ? "Advanced mode" : "Easy mode");
    }

    public void toggleEasyMode() {
        this.setEasyMode(!this.easyMode);
    }

    public void install() {
        Installer installer = new Installer(this.files, this.getProgress("Installing..."));
        try {
            installer.start();
            this.updateFilesTable();
            this.filesChanged();
            this.files.write();
            this.info("Updated successfully.  Please restart ImageJ!");
            this.dispose();
        }
        catch (UpdateCanceledException e) {
            this.error("Canceled");
            installer.done();
        }
        catch (Exception e) {
            this.log.error((Throwable)e);
            this.error("Installer failed: " + e);
            installer.done();
        }
    }

    public synchronized void filesChanged() {
        if (this.filesChangedWorker != null) {
            return;
        }
        this.filesChangedWorker = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                UpdaterFrame.this.filesChangedWorker();
                UpdaterFrame updaterFrame = UpdaterFrame.this;
                synchronized (updaterFrame) {
                    UpdaterFrame.this.filesChangedWorker = null;
                }
            }
        };
        SwingUtilities.invokeLater(this.filesChangedWorker);
    }

    private void filesChangedWorker() {
        this.fileDetails.reset();
        for (FileObject file : this.table.getSelectedFiles()) {
            this.fileDetails.showFileDetails(file);
        }
        if (this.fileDetails.getDocument().getLength() > 0 && this.table.areAllSelectedFilesUploadable()) {
            this.fileDetails.setEditableForDevelopers();
        }
        for (FileActionButton button : this.fileActions) {
            button.enableIfValid();
        }
        if (this.showChanges != null) {
            this.showChanges.setEnabled(this.table.getSelectedFiles().iterator().hasNext());
        }
        this.enableApplyOrUpload();
        this.cancel.setText(this.files.hasChanges() || this.files.hasUpdateSitesChanges() ? "Cancel" : "Close");
        int install = 0;
        int uninstall = 0;
        int upload = 0;
        long bytesToDownload = 0L;
        long bytesToUpload = 0L;
        for (FileObject file : this.files) {
            switch (file.getAction()) {
                case INSTALL: 
                case UPDATE: {
                    ++install;
                    bytesToDownload += file.filesize;
                    break;
                }
                case UNINSTALL: {
                    ++uninstall;
                    break;
                }
                case UPLOAD: {
                    ++upload;
                    bytesToUpload += file.filesize;
                    break;
                }
            }
        }
        int implicated = 0;
        FilesCollection.DependencyMap map = this.files.getDependencies(true);
        for (FileObject file : map.keySet()) {
            ++implicated;
            bytesToUpload += file.filesize;
        }
        String text = "";
        if (install > 0) {
            text = text + " install/update: " + install + (implicated > 0 ? "+" + implicated : "") + " (" + UpdaterFrame.sizeToString(bytesToDownload) + ")";
        }
        if (uninstall > 0) {
            text = text + " uninstall: " + uninstall;
        }
        if (this.files.hasUploadableSites() && upload > 0) {
            text = text + " upload: " + upload + " (" + UpdaterFrame.sizeToString(bytesToUpload) + ")";
        }
        this.fileSummary.setText(text);
    }

    public static String sizeToString(long size) {
        int i;
        for (i = 1; i < units.length && size >= 1L << 10 * i; ++i) {
        }
        if (--i == 0) {
            return "" + size + units[i];
        }
        size *= 100L;
        size >>= 10 * i;
        size += 5L;
        return "" + (size /= 10L) / 10L + "." + size % 10L + units[i];
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        this.filesChanged();
    }

    public void checkWritable() {
        if (UpdaterUtil.isProtectedLocation((File)this.files.prefix(""))) {
            this.error("<html><p width=400>Windows' security model for the directory '" + this.files.prefix("") + "' is incompatible with the ImageJ updater.</p><p>Please install ImageJ into a user-writable directory, e.g. onto the Desktop.</p></html>");
            return;
        }
        String list = null;
        for (FileObject object : this.files) {
            File file = this.files.prefix(object);
            if (!file.exists() || file.canWrite()) continue;
            if (list == null) {
                list = object.getFilename();
                continue;
            }
            list = list + ", " + object.getFilename();
        }
        if (list != null) {
            UpdaterUserInterface.get().info("WARNING: The following files are set to read-only: '" + list + "'", "Read-only files");
        }
    }

    void markUploadable() {
        this.canUpload = true;
        this.enableApplyOrUpload();
    }

    void enableApplyOrUpload() {
        if (this.files.hasUploadOrRemove()) {
            this.applyOrUpload.setEnabled(true);
            this.applyOrUpload.setText("Apply changes (upload)");
        } else {
            this.applyOrUpload.setText("Apply changes");
            this.applyOrUpload.setEnabled(this.files.hasChanges());
        }
    }

    protected void upload() throws InstantiationException {
        block13: {
            String updateSiteName;
            ResolveDependencies resolver = new ResolveDependencies(this, this.files, true);
            if (!resolver.resolve()) {
                return;
            }
            String errors = this.files.checkConsistency();
            if (errors != null) {
                this.error(errors);
                return;
            }
            ArrayList<String> possibleSites = new ArrayList<String>(this.files.getSiteNamesToUpload());
            if (possibleSites.size() == 0) {
                this.error("Huh? No upload site?");
                return;
            }
            if (possibleSites.size() == 1) {
                updateSiteName = (String)possibleSites.get(0);
            } else {
                updateSiteName = SwingTools.getChoice(this, possibleSites, "Which site do you want to upload to?", "Update site");
                if (updateSiteName == null) {
                    return;
                }
            }
            FilesUploader uploader = new FilesUploader(this.uploaderService, this.files, updateSiteName, this.getProgress(null));
            Progress progress = null;
            try {
                if (!uploader.login()) {
                    return;
                }
                progress = this.getProgress("Uploading...");
                uploader.upload(progress);
                for (FileObject file : this.files.toUploadOrRemove()) {
                    if (file.getAction() == FileObject.Action.UPLOAD) {
                        file.markUploaded();
                        file.setStatus(FileObject.Status.INSTALLED);
                        continue;
                    }
                    file.markRemoved(this.files);
                }
                this.updateFilesTable();
                this.canUpload = false;
                this.files.write();
                this.info("Uploaded successfully.");
                this.enableApplyOrUpload();
                this.dispose();
            }
            catch (UpdateCanceledException e) {
                this.error("Canceled");
                if (progress != null) {
                    progress.done();
                }
            }
            catch (Throwable e) {
                UpdaterUserInterface.get().handleException(e);
                this.error("Upload failed: " + e);
                if (progress == null) break block13;
                progress.done();
            }
        }
    }

    protected boolean initializeUpdateSite(String url, String sshHost, String uploadDirectory) throws InstantiationException {
        block7: {
            FilesUploader uploader = FilesUploader.initialUploader((UploaderService)this.uploaderService, (String)url, (String)sshHost, (String)uploadDirectory, (Progress)this.getProgress(null));
            Progress progress = null;
            try {
                if (!uploader.login()) {
                    return false;
                }
                progress = this.getProgress("Initializing Update Site...");
                uploader.upload(progress);
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                return true;
            }
            catch (UpdateCanceledException e) {
                if (progress != null) {
                    progress.done();
                }
            }
            catch (Throwable e) {
                UpdaterUserInterface.get().handleException(e);
                if (progress == null) break block7;
                progress.done();
            }
        }
        return false;
    }

    public void error(String message) {
        SwingTools.showMessageBox(this, message, 0);
    }

    public void warn(String message) {
        SwingTools.showMessageBox(this, message, 2);
    }

    public void info(String message) {
        SwingTools.showMessageBox(this, message, 1);
    }

    static {
        String version = null;
        try {
            version = ProcessUtils.exec(null, null, null, (String[])new String[]{"git", "--version"});
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        gitVersion = version;
        units = new String[]{"B", "kB", "MB", "GB", "TB"};
    }

    private class FileActionButton
    extends JButton
    implements ActionListener {
        private GroupAction goal;

        public FileActionButton(GroupAction goal) {
            super(goal.toString());
            this.goal = goal;
            this.addActionListener(this);
            UpdaterFrame.this.fileActions.add(this);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (UpdaterFrame.this.table.isEditing()) {
                UpdaterFrame.this.table.editingCanceled(null);
            }
            for (FileObject file : UpdaterFrame.this.table.getSelectedFiles()) {
                this.goal.setAction(UpdaterFrame.this.files, file);
                UpdaterFrame.this.table.fireFileChanged(file);
            }
            UpdaterFrame.this.filesChanged();
        }

        public void enableIfValid() {
            boolean enable = true;
            int count = 0;
            for (FileObject file : UpdaterFrame.this.table.getSelectedFiles()) {
                ++count;
                if (this.goal.isValid(UpdaterFrame.this.files, file)) continue;
                enable = false;
                break;
            }
            this.setText(this.goal.getLabel(UpdaterFrame.this.files, UpdaterFrame.this.table.getSelectedFiles()));
            this.setEnabled(count > 0 && enable);
        }
    }
}

