/*
 * Decompiled with CFR 0.152.
 */
package ij.text;

import ij.IJ;
import ij.ImageJ;
import ij.ImagePlus;
import ij.Menus;
import ij.Prefs;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.gui.Overlay;
import ij.gui.Roi;
import ij.io.SaveDialog;
import ij.macro.Interpreter;
import ij.measure.ResultsTable;
import ij.plugin.filter.Analyzer;
import ij.plugin.frame.Recorder;
import ij.text.TextCanvas;
import ij.text.TextWindow;
import ij.util.Tools;
import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Menu;
import java.awt.MenuItem;
import java.awt.Panel;
import java.awt.PopupMenu;
import java.awt.Scrollbar;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Vector;

public class TextPanel
extends Panel
implements AdjustmentListener,
MouseListener,
MouseMotionListener,
KeyListener,
ClipboardOwner,
ActionListener,
MouseWheelListener,
Runnable {
    static final int DOUBLE_CLICK_THRESHOLD = 650;
    int iGridWidth;
    int iGridHeight;
    int iX;
    int iY;
    String[] sColHead;
    Vector vData;
    int[] iColWidth;
    int iColCount;
    int iRowCount;
    int iRowHeight;
    int iFirstRow;
    Scrollbar sbHoriz;
    Scrollbar sbVert;
    int iSbWidth;
    int iSbHeight;
    boolean bDrag;
    int iXDrag;
    int iColDrag;
    boolean headings = true;
    String title = "";
    String labels;
    KeyListener keyListener;
    Cursor resizeCursor = new Cursor(11);
    Cursor defaultCursor = new Cursor(0);
    int selStart = -1;
    int selEnd = -1;
    int selOrigin = -1;
    int selLine = -1;
    TextCanvas tc = new TextCanvas(this);
    PopupMenu pm;
    boolean columnsManuallyAdjusted;
    long mouseDownTime;
    String filePath;
    ResultsTable rt;
    boolean unsavedLines;
    String searchString;
    Menu fileMenu;
    boolean menusExtended;
    boolean saveAsCSV;

    public TextPanel() {
        this.setLayout(new BorderLayout());
        this.add("Center", this.tc);
        this.sbHoriz = new Scrollbar(0);
        this.sbHoriz.addAdjustmentListener(this);
        this.sbHoriz.setFocusable(false);
        this.add("South", this.sbHoriz);
        this.sbVert = new Scrollbar(1);
        this.sbVert.addAdjustmentListener(this);
        this.sbVert.setFocusable(false);
        ImageJ ij = IJ.getInstance();
        if (ij != null) {
            this.sbHoriz.addKeyListener(ij);
            this.sbVert.addKeyListener(ij);
        }
        this.add("East", this.sbVert);
        this.addPopupMenu();
    }

    public TextPanel(String title) {
        this();
        this.title = title;
        if (title.equals("Results")) {
            this.pm.addSeparator();
            this.addPopupItem("Clear Results");
            this.addPopupItem("Summarize");
            this.addPopupItem("Distribution...");
            this.addPopupItem("Set Measurements...");
            this.addPopupItem("Rename...");
            this.addPopupItem("Duplicate...");
            this.menusExtended = true;
        }
    }

    void addPopupMenu() {
        this.pm = new PopupMenu();
        this.addPopupItem("Save As...");
        this.pm.addSeparator();
        this.addPopupItem("Cut");
        this.addPopupItem("Copy");
        this.addPopupItem("Clear");
        this.addPopupItem("Select All");
        this.add(this.pm);
    }

    void addPopupItem(String s) {
        MenuItem mi = new MenuItem(s);
        mi.addActionListener(this);
        this.pm.add(mi);
    }

    public synchronized void setColumnHeadings(String labels) {
        boolean sameLabels = labels.equals(this.labels);
        this.labels = labels;
        if (labels.equals("")) {
            this.iColCount = 1;
            this.sColHead = new String[1];
            this.sColHead[0] = "";
        } else {
            if (labels.endsWith("\t")) {
                this.labels = labels.substring(0, labels.length() - 1);
            }
            this.sColHead = Tools.split(this.labels, "\t");
            this.iColCount = this.sColHead.length;
        }
        this.flush();
        this.vData = new Vector();
        if (this.iColWidth == null || this.iColWidth.length != this.iColCount || !sameLabels || this.iColCount == 1) {
            this.iColWidth = new int[this.iColCount];
            this.columnsManuallyAdjusted = false;
        }
        this.iRowCount = 0;
        this.resetSelection();
        this.adjustHScroll();
        this.tc.repaint();
    }

    public String getColumnHeadings() {
        return this.labels == null ? "" : this.labels;
    }

    public synchronized void updateColumnHeadings(String labels) {
        this.labels = labels;
        if (labels.equals("")) {
            this.iColCount = 1;
            this.sColHead = new String[1];
            this.sColHead[0] = "";
        } else {
            if (labels.endsWith("\t")) {
                this.labels = labels.substring(0, labels.length() - 1);
            }
            this.sColHead = Tools.split(this.labels, "\t");
            this.iColCount = this.sColHead.length;
            this.iColWidth = new int[this.iColCount];
            this.columnsManuallyAdjusted = false;
        }
    }

    public void setFont(Font font, boolean antialiased) {
        this.tc.fFont = font;
        this.tc.iImage = null;
        this.tc.fMetrics = null;
        this.tc.antialiased = antialiased;
        this.iColWidth[0] = 0;
        if (this.isShowing()) {
            this.updateDisplay();
        }
    }

    public void appendLine(String text) {
        if (this.vData == null) {
            this.setColumnHeadings("");
        }
        char[] chars = text.toCharArray();
        this.vData.addElement(chars);
        ++this.iRowCount;
        if (this.isShowing()) {
            if (this.iColCount == 1 && this.tc.fMetrics != null) {
                this.iColWidth[0] = Math.max(this.iColWidth[0], this.tc.fMetrics.charsWidth(chars, 0, chars.length));
                this.adjustHScroll();
            }
            this.updateDisplay();
            this.unsavedLines = true;
        }
    }

    public void append(String text) {
        if (text == null) {
            text = "null";
        }
        if (this.vData == null) {
            this.setColumnHeadings("");
        }
        if (text.length() == 1 && text.equals("\n")) {
            text = "";
        }
        String[] lines = text.split("\n");
        for (int i = 0; i < lines.length; ++i) {
            this.appendWithoutUpdate(lines[i]);
        }
        if (this.isShowing()) {
            this.updateDisplay();
            this.unsavedLines = true;
        }
    }

    public void append(ArrayList list) {
        if (list == null) {
            return;
        }
        if (this.vData == null) {
            this.setColumnHeadings("");
        }
        for (int i = 0; i < list.size(); ++i) {
            this.appendWithoutUpdate((String)list.get(i));
        }
        if (this.isShowing()) {
            this.updateDisplay();
            this.unsavedLines = true;
        }
    }

    public void appendWithoutUpdate(String data) {
        if (this.vData != null) {
            char[] chars = data.toCharArray();
            this.vData.addElement(chars);
            ++this.iRowCount;
        }
    }

    public void updateDisplay() {
        this.iY = this.iRowHeight * (this.iRowCount + 1);
        this.adjustVScroll();
        if (this.iColCount > 1 && this.iRowCount <= 10 && !this.columnsManuallyAdjusted) {
            this.iColWidth[0] = 0;
        }
        this.tc.repaint();
    }

    String getCell(int column, int row) {
        if (column < 0 || column >= this.iColCount || row < 0 || row >= this.iRowCount) {
            return null;
        }
        return new String(this.tc.getChars(column, row));
    }

    synchronized void adjustVScroll() {
        if (this.iRowHeight == 0) {
            return;
        }
        Dimension d = this.tc.getSize();
        int value = this.iY / this.iRowHeight;
        int visible = d.height / this.iRowHeight;
        int maximum = this.iRowCount + 1;
        if (visible < 0) {
            visible = 0;
        }
        if (visible > maximum) {
            visible = maximum;
        }
        if (value > maximum - visible) {
            value = maximum - visible;
        }
        this.sbVert.setValues(value, visible, 0, maximum);
        this.iY = this.iRowHeight * value;
    }

    synchronized void adjustHScroll() {
        if (this.iRowHeight == 0) {
            return;
        }
        Dimension d = this.tc.getSize();
        int w = 0;
        for (int i = 0; i < this.iColCount; ++i) {
            w += this.iColWidth[i];
        }
        this.iGridWidth = w;
        this.sbHoriz.setValues(this.iX, d.width, 0, this.iGridWidth);
        this.iX = this.sbHoriz.getValue();
    }

    @Override
    public void adjustmentValueChanged(AdjustmentEvent e) {
        this.iX = this.sbHoriz.getValue();
        this.iY = this.iRowHeight * this.sbVert.getValue();
        this.tc.repaint();
    }

    @Override
    public void mousePressed(MouseEvent e) {
        int x = e.getX();
        int y = e.getY();
        if (e.isPopupTrigger() || e.isMetaDown()) {
            this.pm.show(e.getComponent(), x, y);
        } else if (e.isShiftDown()) {
            this.extendSelection(x, y);
        } else {
            this.select(x, y);
            this.handleDoubleClick();
        }
    }

    void handleDoubleClick() {
        boolean overlayList = "Overlay Elements".equals(this.title);
        if (this.selStart < 0 || this.selStart != this.selEnd || this.iColCount != 1 && !overlayList) {
            return;
        }
        boolean doubleClick = System.currentTimeMillis() - this.mouseDownTime <= 650L;
        this.mouseDownTime = System.currentTimeMillis();
        if (doubleClick) {
            char[] chars = (char[])this.vData.elementAt(this.selStart);
            String s = new String(chars);
            if (overlayList) {
                this.handleDoubleClickInOverlayList(s);
                return;
            }
            int index = s.indexOf(": ");
            if (index > -1 && !s.endsWith(": ")) {
                s = s.substring(index + 2);
            }
            if (s.indexOf(File.separator) != -1 || s.indexOf(".") != -1) {
                this.filePath = s;
                Thread thread = new Thread((Runnable)this, "Open");
                thread.setPriority(thread.getPriority() - 1);
                thread.start();
            }
        }
    }

    private void handleDoubleClickInOverlayList(String s) {
        ImagePlus imp = WindowManager.getCurrentImage();
        if (imp == null) {
            return;
        }
        Overlay overlay = imp.getOverlay();
        if (overlay == null) {
            return;
        }
        String[] columns = s.split("\t");
        int index = (int)Tools.parseDouble(columns[0]);
        Roi roi = overlay.get(index);
        imp.setRoi(roi);
    }

    @Override
    public void run() {
        if (this.filePath != null) {
            IJ.open(this.filePath);
        }
    }

    @Override
    public void mouseExited(MouseEvent e) {
        if (this.bDrag) {
            this.setCursor(this.defaultCursor);
            this.bDrag = false;
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        int x = e.getX();
        int y = e.getY();
        if (y <= this.iRowHeight) {
            int i;
            int xb = x;
            x = x + this.iX - this.iGridWidth;
            for (i = this.iColCount - 1; i >= 0 && (x <= -7 || x >= 7); x += this.iColWidth[i], --i) {
            }
            if (i >= 0) {
                if (!this.bDrag) {
                    this.setCursor(this.resizeCursor);
                    this.bDrag = true;
                    this.iXDrag = xb - this.iColWidth[i];
                    this.iColDrag = i;
                }
                return;
            }
        }
        if (this.bDrag) {
            this.setCursor(this.defaultCursor);
            this.bDrag = false;
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (e.isPopupTrigger() || e.isMetaDown()) {
            return;
        }
        int x = e.getX();
        int y = e.getY();
        if (this.bDrag && x < this.tc.getSize().width) {
            int w = x - this.iXDrag;
            if (w < 0) {
                w = 0;
            }
            this.iColWidth[this.iColDrag] = w;
            this.columnsManuallyAdjusted = true;
            this.adjustHScroll();
            this.tc.repaint();
        } else {
            this.extendSelection(x, y);
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mouseWheelMoved(MouseWheelEvent event) {
        TextPanel textPanel = this;
        synchronized (textPanel) {
            int rot = event.getWheelRotation();
            this.sbVert.setValue(this.sbVert.getValue() + rot);
            this.iY = this.iRowHeight * this.sbVert.getValue();
            this.tc.repaint();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scroll(int inc) {
        TextPanel textPanel = this;
        synchronized (textPanel) {
            this.sbVert.setValue(this.sbVert.getValue() + inc);
            this.iY = this.iRowHeight * this.sbVert.getValue();
            this.tc.repaint();
        }
    }

    @Override
    public void addKeyListener(KeyListener listener) {
        this.keyListener = listener;
    }

    @Override
    public void addMouseListener(MouseListener listener) {
        this.tc.addMouseListener(listener);
    }

    @Override
    public void keyPressed(KeyEvent e) {
        int key = e.getKeyCode();
        if (key == 8) {
            this.clearSelection();
        } else if (key == 38) {
            this.scroll(-1);
        } else if (key == 40) {
            this.scroll(1);
        } else if (this.keyListener != null && key != 83 && key != 67 && key != 88 && key != 65 && key != 70 && key != 71) {
            this.keyListener.keyPressed(e);
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
        if (this.keyListener != null) {
            this.keyListener.keyTyped(e);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        this.doCommand(cmd);
    }

    void doCommand(String cmd) {
        if (cmd == null) {
            return;
        }
        if (cmd.equals("Save As...")) {
            this.saveAs("");
        } else if (cmd.equals("Cut")) {
            this.cutSelection();
        } else if (cmd.equals("Copy")) {
            this.copySelection();
        } else if (cmd.equals("Clear")) {
            this.clearSelection();
        } else if (cmd.equals("Select All")) {
            this.selectAll();
        } else if (cmd.equals("Find...")) {
            this.find(null);
        } else if (cmd.equals("Find Next")) {
            this.find(this.searchString);
        } else if (cmd.equals("Rename...")) {
            this.rename(null);
        } else if (cmd.equals("Duplicate...")) {
            this.duplicate();
        } else if (cmd.equals("Summarize")) {
            IJ.doCommand("Summarize");
        } else if (cmd.equals("Distribution...")) {
            IJ.doCommand("Distribution...");
        } else if (cmd.equals("Clear Results")) {
            IJ.doCommand("Clear Results");
        } else if (cmd.equals("Set Measurements...")) {
            IJ.doCommand("Set Measurements...");
        } else if (cmd.equals("Options...")) {
            IJ.doCommand("Input/Output...");
        }
    }

    @Override
    public void lostOwnership(Clipboard clip, Transferable cont) {
    }

    private void find(String s) {
        int first = 0;
        if (s == null) {
            GenericDialog gd = new GenericDialog("Find...", this.getTextWindow());
            gd.addStringField("Find: ", this.searchString, 20);
            gd.showDialog();
            if (gd.wasCanceled()) {
                return;
            }
            s = gd.getNextString();
        } else if (this.selEnd >= 0 && this.selEnd < this.iRowCount - 1) {
            first = this.selEnd + 1;
        } else {
            IJ.beep();
            return;
        }
        if (s.equals("")) {
            return;
        }
        boolean found = false;
        for (int i = first; i < this.iRowCount; ++i) {
            String line = new String((char[])this.vData.elementAt(i));
            if (!line.contains(s)) continue;
            this.setSelection(i, i);
            found = true;
            first = i + 1;
            break;
        }
        if (!found) {
            IJ.beep();
            first = 0;
        }
        this.searchString = s;
    }

    private TextWindow getTextWindow() {
        Container comp = this.getParent();
        if (comp == null || !(comp instanceof TextWindow)) {
            return null;
        }
        return (TextWindow)comp;
    }

    void rename(String title2) {
        TextWindow tw;
        if (this.rt == null) {
            return;
        }
        if (title2 != null && title2.equals("")) {
            title2 = null;
        }
        if ((tw = this.getTextWindow()) == null) {
            return;
        }
        if (title2 == null) {
            GenericDialog gd = new GenericDialog("Rename", tw);
            gd.addStringField("Title:", this.getNewTitle(this.title), 20);
            gd.showDialog();
            if (gd.wasCanceled()) {
                return;
            }
            title2 = gd.getNextString();
        }
        String title1 = this.title;
        if (this.title != null && this.title.equals("Results")) {
            IJ.setTextPanel(null);
            Analyzer.setUnsavedMeasurements(false);
            Analyzer.setResultsTable(null);
            Analyzer.resetCounter();
        }
        if (title2.equals("Results")) {
            tw.dispose();
            WindowManager.removeWindow(tw);
            this.flush();
            this.rt.show("Results");
        } else {
            int mbSize;
            tw.setTitle(title2);
            int n = mbSize = tw.mb != null ? tw.mb.getMenuCount() : 0;
            if (mbSize > 0 && tw.mb.getMenu(mbSize - 1).getLabel().equals("Results")) {
                tw.mb.remove(mbSize - 1);
            }
            this.title = title2;
        }
        Menus.updateWindowMenuItem(title1, title2);
        if (Recorder.record) {
            Recorder.recordString("IJ.renameResults(\"" + title2 + "\");\n");
        }
    }

    void duplicate() {
        if (this.rt == null) {
            return;
        }
        ResultsTable rt2 = (ResultsTable)this.rt.clone();
        String title2 = IJ.getString("Title:", this.getNewTitle(this.title));
        if (!title2.equals("")) {
            if (title2.equals("Results")) {
                title2 = "Results2";
            }
            rt2.show(title2);
        }
    }

    private String getNewTitle(String oldTitle) {
        String title3;
        if (oldTitle == null) {
            return "Table2";
        }
        String title2 = oldTitle;
        if (title2.endsWith("-1") || title2.endsWith("-2")) {
            title2 = title2.substring(0, this.title.length() - 2);
        }
        if ((title3 = title2 + "-1").equals(oldTitle)) {
            title3 = title2 + "-2";
        }
        return title3;
    }

    void select(int x, int y) {
        Dimension d = this.tc.getSize();
        if (this.iRowHeight == 0 || x > d.width || y > d.height) {
            return;
        }
        int r = y / this.iRowHeight - 1 + this.iFirstRow;
        int lineWidth = this.iGridWidth;
        if (this.iColCount == 1 && this.tc.fMetrics != null && r >= 0 && r < this.iRowCount) {
            char[] chars = (char[])this.vData.elementAt(r);
            lineWidth = Math.max(this.tc.fMetrics.charsWidth(chars, 0, chars.length), this.iGridWidth);
        }
        if (r >= 0 && r < this.iRowCount && x < lineWidth) {
            this.selOrigin = r;
            this.selStart = r;
            this.selEnd = r;
        } else {
            this.resetSelection();
            this.selOrigin = r;
            if (r >= this.iRowCount) {
                this.selOrigin = this.iRowCount - 1;
            }
        }
        this.tc.repaint();
        this.selLine = r;
        Interpreter interp = Interpreter.getInstance();
        if (interp != null && this.title.equals("Debug")) {
            interp.showArrayInspector(r);
        }
    }

    void extendSelection(int x, int y) {
        Dimension d = this.tc.getSize();
        if (this.iRowHeight == 0 || x > d.width || y > d.height) {
            return;
        }
        int r = y / this.iRowHeight - 1 + this.iFirstRow;
        if (r >= 0 && r < this.iRowCount) {
            if (r < this.selOrigin) {
                this.selStart = r;
                this.selEnd = this.selOrigin;
            } else {
                this.selStart = this.selOrigin;
                this.selEnd = r;
            }
        }
        this.tc.repaint();
        this.selLine = r;
    }

    public int rowIndex(int y) {
        if (y > this.tc.getSize().height) {
            return -1;
        }
        return y / this.iRowHeight - 1 + this.iFirstRow;
    }

    public int copySelection() {
        if (Recorder.record && this.title.equals("Results")) {
            Recorder.record("String.copyResults");
        }
        if (this.selStart == -1 || this.selEnd == -1) {
            return this.copyAll();
        }
        StringBuffer sb = new StringBuffer();
        if (Prefs.copyColumnHeaders && this.labels != null && !this.labels.equals("") && this.selStart == 0 && this.selEnd == this.iRowCount - 1) {
            if (Prefs.noRowNumbers) {
                String s = this.labels;
                int index = s.indexOf("\t");
                if (index != -1) {
                    s = s.substring(index + 1, s.length());
                }
                sb.append(s);
            } else {
                sb.append(this.labels);
            }
            sb.append('\n');
        }
        for (int i = this.selStart; i <= this.selEnd; ++i) {
            char[] chars = (char[])this.vData.elementAt(i);
            String s = new String(chars);
            if (s.endsWith("\t")) {
                s = s.substring(0, s.length() - 1);
            }
            if (Prefs.noRowNumbers && this.labels != null && !this.labels.equals("")) {
                int index = s.indexOf("\t");
                if (index != -1) {
                    s = s.substring(index + 1, s.length());
                }
                sb.append(s);
            } else {
                sb.append(s);
            }
            if (i >= this.selEnd && this.selEnd <= this.selStart) continue;
            sb.append('\n');
        }
        String s = new String(sb);
        Clipboard clip = this.getToolkit().getSystemClipboard();
        if (clip == null) {
            return 0;
        }
        StringSelection cont = new StringSelection(s);
        clip.setContents(cont, this);
        if (s.length() > 0) {
            IJ.showStatus(this.selEnd - this.selStart + 1 + " lines copied to clipboard");
            if (this.getParent() instanceof ImageJ) {
                Analyzer.setUnsavedMeasurements(false);
            }
        }
        return s.length();
    }

    int copyAll() {
        this.selectAll();
        int count = this.selEnd - this.selStart + 1;
        if (count > 0) {
            this.copySelection();
        }
        this.resetSelection();
        this.unsavedLines = false;
        return count;
    }

    void cutSelection() {
        if (this.selStart == -1 || this.selEnd == -1) {
            this.selectAll();
        }
        this.copySelection();
        this.clearSelection();
    }

    public void clearSelection() {
        if (this.selStart == -1 || this.selEnd == -1) {
            if (this.getLineCount() > 0) {
                IJ.error("Selection required");
            }
            return;
        }
        if (Recorder.record) {
            Recorder.recordString("IJ.deleteRows(" + this.selStart + ", " + this.selEnd + ");\n");
        }
        int first = this.selStart;
        int last = this.selEnd;
        int rows = this.iRowCount;
        if (this.selStart == 0 && this.selEnd == this.iRowCount - 1) {
            this.vData.removeAllElements();
            this.iRowCount = 0;
            if (this.rt != null) {
                if (IJ.isResultsWindow() && IJ.getTextPanel() == this) {
                    Analyzer.setUnsavedMeasurements(false);
                    Analyzer.resetCounter();
                } else {
                    this.rt.reset();
                }
            }
        } else {
            int i;
            int rowCount = this.iRowCount;
            boolean atEnd = rowCount - this.selEnd < 8;
            int count = this.selEnd - this.selStart + 1;
            for (i = 0; i < count; ++i) {
                this.vData.removeElementAt(this.selStart);
                --this.iRowCount;
            }
            if (this.rt != null && rowCount == this.rt.getCounter()) {
                for (i = 0; i < count; ++i) {
                    this.rt.deleteRow(this.selStart);
                }
                this.rt.show(this.title);
                if (!atEnd) {
                    this.iY = 0;
                    this.tc.repaint();
                }
            }
        }
        this.clearOverlay(first, last, rows);
        this.selStart = -1;
        this.selEnd = -1;
        this.selOrigin = -1;
        this.selLine = -1;
        this.adjustVScroll();
        this.tc.repaint();
    }

    private void clearOverlay(int first, int last, int rows) {
        int i;
        ImagePlus imp = WindowManager.getCurrentImage();
        if (imp == null) {
            return;
        }
        Overlay overlay = imp.getOverlay();
        if (overlay == null) {
            return;
        }
        if (overlay.size() != rows) {
            return;
        }
        String name1 = overlay.get(0).getName();
        String name2 = overlay.get(overlay.size() - 1).getName();
        if (!"1".equals(name1) || !("" + rows).equals(name2)) {
            return;
        }
        int count = last - first + 1;
        if (overlay.size() == count) {
            if (count == 1 || IJ.showMessageWithCancel("ImageJ", "Delete the " + overlay.size() + " element overlay?  ")) {
                imp.setOverlay(null);
            }
            return;
        }
        for (i = 0; i < count; ++i) {
            overlay.remove(first);
        }
        for (i = first; i < overlay.size(); ++i) {
            overlay.get(i).setName("" + (i + 1));
        }
        imp.draw();
    }

    public synchronized void clear() {
        if (this.vData == null) {
            return;
        }
        this.vData.removeAllElements();
        this.iRowCount = 0;
        this.selStart = -1;
        this.selEnd = -1;
        this.selOrigin = -1;
        this.selLine = -1;
        this.adjustVScroll();
        this.tc.repaint();
    }

    public void selectAll() {
        if (this.selStart == 0 && this.selEnd == this.iRowCount - 1) {
            this.resetSelection();
            return;
        }
        this.selStart = 0;
        this.selEnd = this.iRowCount - 1;
        this.selOrigin = 0;
        this.tc.repaint();
        this.selLine = -1;
    }

    public void resetSelection() {
        this.selStart = -1;
        this.selEnd = -1;
        this.selOrigin = -1;
        this.selLine = -1;
        if (this.iRowCount > 0) {
            this.tc.repaint();
        }
    }

    public void setSelection(int startLine, int endLine) {
        if (startLine > endLine) {
            endLine = startLine;
        }
        if (startLine < 0) {
            startLine = 0;
        }
        if (endLine < 0) {
            endLine = 0;
        }
        if (startLine >= this.iRowCount) {
            startLine = this.iRowCount - 1;
        }
        if (endLine >= this.iRowCount) {
            endLine = this.iRowCount - 1;
        }
        this.selOrigin = startLine;
        this.selStart = startLine;
        this.selEnd = endLine;
        int vstart = this.sbVert.getValue();
        int visible = this.sbVert.getVisibleAmount() - 1;
        if (startLine < vstart) {
            this.sbVert.setValue(startLine);
            this.iY = this.iRowHeight * startLine;
        } else if (endLine >= vstart + visible) {
            vstart = endLine - visible + 1;
            if (vstart < 0) {
                vstart = 0;
            }
            this.sbVert.setValue(vstart);
            this.iY = this.iRowHeight * vstart;
        }
        this.tc.repaint();
    }

    public void save(PrintWriter pw) {
        this.resetSelection();
        if (this.labels != null && !this.labels.equals("")) {
            String labels2 = this.labels;
            if (this.saveAsCSV) {
                labels2 = labels2.replaceAll("\t", ",");
            }
            pw.println(labels2);
        }
        for (int i = 0; i < this.iRowCount; ++i) {
            char[] chars = (char[])this.vData.elementAt(i);
            String s = new String(chars);
            if (s.endsWith("\t")) {
                s = s.substring(0, s.length() - 1);
            }
            if (this.saveAsCSV) {
                s = s.replaceAll("\t", ",");
            }
            pw.println(s);
        }
        this.unsavedLines = false;
    }

    public boolean saveAs(String path) {
        boolean isResults = IJ.isResultsWindow() && IJ.getTextPanel() == this;
        boolean summarized = false;
        if (isResults) {
            String lastLine = this.iRowCount >= 2 ? this.getLine(this.iRowCount - 2) : null;
            summarized = lastLine != null && lastLine.startsWith("Max");
        }
        String fileName = null;
        if (this.rt != null && this.rt.getCounter() != 0 && !summarized) {
            if (path == null || path.equals("")) {
                IJ.wait(10);
                String name = isResults ? "Results" : this.title;
                SaveDialog sd = new SaveDialog("Save Results", name, Prefs.defaultResultsExtension());
                fileName = sd.getFileName();
                if (fileName == null) {
                    return false;
                }
                path = sd.getDirectory() + fileName;
            }
            this.rt.save(path);
            TextWindow tw = this.getTextWindow();
            if (fileName != null && tw != null && !"Results".equals(this.title)) {
                tw.setTitle(fileName);
                this.title = fileName;
            }
        } else {
            if (path.equals("")) {
                IJ.wait(10);
                boolean hasHeadings = !this.getColumnHeadings().equals("");
                String ext = isResults || hasHeadings ? Prefs.defaultResultsExtension() : ".txt";
                SaveDialog sd = new SaveDialog("Save as Text", this.title, ext);
                String file = sd.getFileName();
                if (file == null) {
                    return false;
                }
                path = sd.getDirectory() + file;
            }
            PrintWriter pw = null;
            try {
                FileOutputStream fos = new FileOutputStream(path);
                BufferedOutputStream bos = new BufferedOutputStream(fos);
                pw = new PrintWriter(bos);
            }
            catch (IOException e) {
                IJ.error("Save As>Text", e.getMessage());
                return true;
            }
            this.saveAsCSV = path.endsWith(".csv");
            this.save(pw);
            this.saveAsCSV = false;
            pw.close();
        }
        if (isResults) {
            Analyzer.setUnsavedMeasurements(false);
            if (Recorder.record && !IJ.isMacro()) {
                Recorder.record("saveAs", "Results", path);
            }
        } else if (this.rt != null) {
            if (Recorder.record && !IJ.isMacro()) {
                Recorder.record("saveAs", "Results", path);
            }
        } else if (Recorder.record && !IJ.isMacro()) {
            Recorder.record("saveAs", "Text", path);
        }
        IJ.showStatus("");
        return true;
    }

    public synchronized String getText() {
        if (this.vData == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        if (this.labels != null && !this.labels.equals("")) {
            sb.append(this.labels);
            sb.append('\n');
        }
        for (int i = 0; i < this.iRowCount && this.vData != null; ++i) {
            char[] chars = (char[])this.vData.elementAt(i);
            sb.append(chars);
            sb.append('\n');
        }
        return new String(sb);
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public int getLineCount() {
        return this.iRowCount;
    }

    public String getLine(int index) {
        if (index < 0 || index >= this.iRowCount) {
            throw new IllegalArgumentException("index out of range: " + index);
        }
        return new String((char[])this.vData.elementAt(index));
    }

    public void setLine(int index, String s) {
        if (index < 0 || index >= this.iRowCount) {
            throw new IllegalArgumentException("index out of range: " + index);
        }
        if (this.vData != null) {
            this.vData.setElementAt(s.toCharArray(), index);
            this.tc.repaint();
        }
    }

    public int getSelectionStart() {
        return this.selStart;
    }

    public int getSelectionEnd() {
        return this.selEnd;
    }

    public void setResultsTable(ResultsTable rt) {
        if (IJ.debugMode) {
            IJ.log("setResultsTable: " + rt);
        }
        this.rt = rt;
        if (!this.menusExtended) {
            this.extendMenus();
        }
    }

    public ResultsTable getResultsTable() {
        if (IJ.debugMode) {
            IJ.log("getResultsTable: " + this.rt);
        }
        return this.rt;
    }

    public ResultsTable getOrCreateResultsTable() {
        block6: {
            if (!(this.rt != null && this.rt.size() != 0 || this.iRowCount <= 0 || this.labels == null || this.labels.equals(""))) {
                String tmpDir = IJ.getDir("temp");
                if (tmpDir == null) {
                    if (IJ.debugMode) {
                        IJ.log("getOrCreateResultsTable: tmpDir null");
                    }
                    return null;
                }
                String path = tmpDir + "temp-table.csv";
                this.saveAs(path);
                try {
                    this.rt = ResultsTable.open(path);
                    new File(path).delete();
                }
                catch (Exception e) {
                    this.rt = null;
                    if (!IJ.debugMode) break block6;
                    IJ.log("getOrCreateResultsTable: " + e);
                }
            }
        }
        if (IJ.debugMode) {
            IJ.log("getOrCreateResultsTable: " + this.rt);
        }
        return this.rt;
    }

    private void extendMenus() {
        this.pm.addSeparator();
        this.addPopupItem("Rename...");
        this.addPopupItem("Duplicate...");
        if (this.fileMenu != null) {
            this.fileMenu.add("Rename...");
            this.fileMenu.add("Duplicate...");
        }
        this.menusExtended = true;
    }

    public void scrollToTop() {
        this.sbVert.setValue(0);
        this.iY = 0;
        for (int i = 0; i < this.iColCount; ++i) {
            this.tc.calcAutoWidth(i);
        }
        this.adjustHScroll();
        this.tc.repaint();
    }

    void flush() {
        if (this.vData != null) {
            this.vData.removeAllElements();
        }
        this.vData = null;
    }
}

