/*
 * Decompiled with CFR 0.152.
 */
package ij;

import ij.CompositeImage;
import ij.IJ;
import ij.ImageJ;
import ij.ImageListener;
import ij.ImageStack;
import ij.LookUpTable;
import ij.Menus;
import ij.Prefs;
import ij.Undo;
import ij.WindowManager;
import ij.gui.Arrow;
import ij.gui.EllipseRoi;
import ij.gui.FreehandRoi;
import ij.gui.ImageCanvas;
import ij.gui.ImageWindow;
import ij.gui.Line;
import ij.gui.OvalRoi;
import ij.gui.Overlay;
import ij.gui.PlotWindow;
import ij.gui.PointRoi;
import ij.gui.PolygonRoi;
import ij.gui.Roi;
import ij.gui.RotatedRectRoi;
import ij.gui.ShapeRoi;
import ij.gui.StackWindow;
import ij.gui.TextRoi;
import ij.gui.Toolbar;
import ij.io.FileInfo;
import ij.io.FileOpener;
import ij.io.Opener;
import ij.macro.Interpreter;
import ij.measure.Calibration;
import ij.measure.Measurements;
import ij.plugin.AVI_Reader;
import ij.plugin.Colors;
import ij.plugin.ContrastEnhancer;
import ij.plugin.Duplicator;
import ij.plugin.FileInfoVirtualStack;
import ij.plugin.filter.Analyzer;
import ij.plugin.frame.Channels;
import ij.plugin.frame.ContrastAdjuster;
import ij.plugin.frame.Recorder;
import ij.plugin.frame.RoiManager;
import ij.plugin.frame.ThresholdAdjuster;
import ij.process.ByteProcessor;
import ij.process.ColorProcessor;
import ij.process.FloatProcessor;
import ij.process.ImageConverter;
import ij.process.ImageProcessor;
import ij.process.ImageStatistics;
import ij.process.LUT;
import ij.process.ShortProcessor;
import ij.util.DicomTools;
import ij.util.Tools;
import java.awt.BasicStroke;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ImageObserver;
import java.awt.image.PixelGrabber;
import java.util.Properties;
import java.util.Vector;

public class ImagePlus
implements ImageObserver,
Measurements,
Cloneable {
    public static final int GRAY8 = 0;
    public static final int GRAY16 = 1;
    public static final int GRAY32 = 2;
    public static final int COLOR_256 = 3;
    public static final int COLOR_RGB = 4;
    public static final String flattenTitle = "flatten~canvas";
    public boolean changes;
    protected Image img;
    protected ImageProcessor ip;
    protected ImageWindow win;
    protected Roi roi;
    protected int currentSlice;
    protected static final int OPENED = 0;
    protected static final int CLOSED = 1;
    protected static final int UPDATED = 2;
    protected boolean compositeImage;
    protected int width;
    protected int height;
    protected boolean locked = false;
    protected int nChannels = 1;
    protected int nSlices = 1;
    protected int nFrames = 1;
    protected boolean dimensionsSet;
    private ImageJ ij = IJ.getInstance();
    private String title;
    private String url;
    private FileInfo fileInfo;
    private int imageType = 0;
    private ImageStack stack;
    private static int currentID = -1;
    private int ID;
    private static Component comp;
    private boolean imageLoaded;
    private int imageUpdateY;
    private int imageUpdateW;
    private Properties properties;
    private long startTime;
    private Calibration calibration;
    private static Calibration globalCalibration;
    private boolean activated;
    private boolean ignoreFlush;
    private boolean errorLoadingImage;
    private static ImagePlus clipboard;
    private static Vector listeners;
    private boolean openAsHyperStack;
    private int[] position = new int[]{1, 1, 1};
    private boolean noUpdateMode;
    private ImageCanvas flatteningCanvas;
    private Overlay overlay;
    private boolean hideOverlay;
    private static int default16bitDisplayRange;
    private boolean antialiasRendering = true;
    private boolean ignoreGlobalCalibration;
    public boolean setIJMenuBar = Prefs.setIJMenuBar;
    public boolean typeSet;
    long waitStart;
    private int[] pvalue = new int[4];
    private int savex;
    private int savey;

    public ImagePlus() {
        this.title = this instanceof CompositeImage ? "composite" : "null";
        this.setID();
    }

    public ImagePlus(String title, Image img) {
        this.title = title;
        if (img != null) {
            this.setImage(img);
        }
        this.setID();
    }

    public ImagePlus(String title, ImageProcessor ip) {
        this.setProcessor(title, ip);
        this.setID();
    }

    public ImagePlus(String pathOrURL) {
        Opener opener = new Opener();
        ImagePlus imp = null;
        boolean isURL = pathOrURL.indexOf("://") > 0;
        imp = isURL ? opener.openURL(pathOrURL) : opener.openImage(pathOrURL);
        if (imp != null) {
            if (imp.getStackSize() > 1) {
                this.setStack(imp.getTitle(), imp.getStack());
            } else {
                this.setProcessor(imp.getTitle(), imp.getProcessor());
            }
            this.setCalibration(imp.getCalibration());
            this.properties = imp.getProperties();
            this.setFileInfo(imp.getOriginalFileInfo());
            this.setDimensions(imp.getNChannels(), imp.getNSlices(), imp.getNFrames());
            this.setOverlay(imp.getOverlay());
            this.setRoi(imp.getRoi());
            if (isURL) {
                this.url = pathOrURL;
            }
            this.setID();
        }
    }

    public ImagePlus(String title, ImageStack stack) {
        this.setStack(title, stack);
        this.setID();
    }

    private void setID() {
        this.ID = --currentID;
    }

    public synchronized boolean lock() {
        if (this.locked) {
            IJ.beep();
            IJ.showStatus("\"" + this.title + "\" is locked");
            if (IJ.macroRunning()) {
                IJ.wait(500);
            }
            return false;
        }
        this.locked = true;
        if (IJ.debugMode) {
            IJ.log(this.title + ": lock");
        }
        return true;
    }

    public synchronized boolean lockSilently() {
        if (this.locked) {
            return false;
        }
        this.locked = true;
        if (IJ.debugMode) {
            IJ.log(this.title + ": lock silently");
        }
        return true;
    }

    public synchronized void unlock() {
        this.locked = false;
        if (IJ.debugMode) {
            IJ.log(this.title + ": unlock");
        }
    }

    private void waitForImage(Image img) {
        if (comp == null && (comp = IJ.getInstance()) == null) {
            comp = new Canvas();
        }
        this.imageLoaded = false;
        if (!comp.prepareImage(img, this)) {
            this.waitStart = System.currentTimeMillis();
            while (!this.imageLoaded && !this.errorLoadingImage) {
                IJ.wait(30);
                if (this.imageUpdateW <= 1) continue;
                double progress = (double)this.imageUpdateY / (double)this.imageUpdateW;
                if (!(progress < 1.0) && (progress = 1.0 - (progress - 1.0)) < 0.0) {
                    progress = 0.9;
                }
                this.showProgress(progress);
            }
            this.showProgress(1.0);
        }
    }

    private void showProgress(double percent) {
        if (System.currentTimeMillis() - this.waitStart > 500L) {
            IJ.showProgress(percent);
        }
    }

    public void draw() {
        if (this.win != null) {
            this.win.getCanvas().repaint();
        }
    }

    public void draw(int x, int y, int width, int height) {
        if (this.win != null) {
            ImageCanvas ic = this.win.getCanvas();
            double mag = ic.getMagnification();
            x = ic.screenX(x);
            y = ic.screenY(y);
            width = (int)((double)width * mag);
            height = (int)((double)height * mag);
            ic.repaint(x, y, width, height);
            if (listeners.size() > 0 && this.roi != null && this.roi.getPasteMode() != -1) {
                this.notifyListeners(2);
            }
        }
    }

    public synchronized void updateAndDraw() {
        if (this.stack != null && !this.stack.isVirtual() && this.currentSlice >= 1 && this.currentSlice <= this.stack.getSize()) {
            Object pixels = this.stack.getPixels(this.currentSlice);
            if (this.ip != null && pixels != null && pixels != this.ip.getPixels()) {
                try {
                    this.ip.setPixels(pixels);
                    this.ip.setSnapshotPixels(null);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if (this.win != null) {
            this.win.getCanvas().setImageUpdated();
            if (listeners.size() > 0) {
                this.notifyListeners(2);
            }
        }
        this.draw();
    }

    public void setDisplayMode(int mode) {
        if (this instanceof CompositeImage) {
            ((CompositeImage)this).setMode(mode);
            this.updateAndDraw();
        }
    }

    public int getDisplayMode() {
        if (this instanceof CompositeImage) {
            return ((CompositeImage)this).getMode();
        }
        return 0;
    }

    public void setActiveChannels(String channels) {
        if (!(this instanceof CompositeImage)) {
            return;
        }
        boolean[] active = ((CompositeImage)this).getActiveChannels();
        for (int i = 0; i < active.length; ++i) {
            boolean b = false;
            if (channels.length() > i && channels.charAt(i) == '1') {
                b = true;
            }
            active[i] = b;
        }
        this.updateAndDraw();
        Channels.updateChannels();
    }

    public void updateChannelAndDraw() {
        this.updateAndDraw();
    }

    public ImageProcessor getChannelProcessor() {
        return this.getProcessor();
    }

    public LUT[] getLuts() {
        ImageProcessor ip2 = this.getProcessor();
        if (ip2 == null) {
            return new LUT[0];
        }
        LUT lut = ip2.getLut();
        if (lut == null) {
            return new LUT[0];
        }
        LUT[] luts = new LUT[]{lut};
        return luts;
    }

    public void repaintWindow() {
        if (this.win != null) {
            this.draw();
            this.win.repaint();
        }
    }

    public void updateAndRepaintWindow() {
        if (this.win != null) {
            this.updateAndDraw();
            this.win.repaint();
        }
    }

    public void updateImage() {
        if (this.ip != null) {
            this.img = this.ip.createImage();
        }
    }

    public void hide() {
        if (this.win == null) {
            Interpreter.removeBatchModeImage(this);
            return;
        }
        boolean unlocked = this.lockSilently();
        Overlay overlay2 = this.getOverlay();
        this.changes = false;
        this.win.close();
        this.win = null;
        this.setOverlay(overlay2);
        if (unlocked) {
            this.unlock();
        }
    }

    public void close() {
        ImageWindow win = this.getWindow();
        if (win != null) {
            win.close();
        } else {
            if (WindowManager.getCurrentImage() == this) {
                WindowManager.setTempCurrentImage(null);
            }
            this.deleteRoi();
            Interpreter.removeBatchModeImage(this);
        }
    }

    public void show() {
        this.show("");
    }

    public void show(String statusMessage) {
        if (this.isVisible()) {
            return;
        }
        this.win = null;
        if (IJ.isMacro() && this.ij == null || Interpreter.isBatchMode()) {
            ImagePlus img;
            if (this.isComposite()) {
                ((CompositeImage)this).reset();
            }
            if ((img = WindowManager.getCurrentImage()) != null) {
                img.saveRoi();
            }
            WindowManager.setTempCurrentImage(this);
            Interpreter.addBatchModeImage(this);
            return;
        }
        if (Prefs.useInvertingLut && this.getBitDepth() == 8 && this.ip != null && !this.ip.isInvertedLut() && !this.ip.isColorLut()) {
            this.invertLookupTable();
        }
        this.img = this.getImage();
        if (this.img != null && this.width >= 0 && this.height >= 0) {
            this.activated = false;
            int stackSize = this.getStackSize();
            this.win = stackSize > 1 ? new StackWindow(this) : new ImageWindow(this);
            if (this.roi != null) {
                this.roi.setImage(this);
            }
            if (this.overlay != null && this.getCanvas() != null) {
                this.getCanvas().setOverlay(this.overlay);
            }
            this.draw();
            IJ.showStatus(statusMessage);
            if (IJ.isMacro()) {
                long start = System.currentTimeMillis();
                while (!this.activated) {
                    IJ.wait(5);
                    if (System.currentTimeMillis() - start <= 2000L) continue;
                    WindowManager.setTempCurrentImage(this);
                    break;
                }
            }
            if (this.imageType == 1 && default16bitDisplayRange != 0) {
                this.resetDisplayRange();
                this.updateAndDraw();
            }
            if (stackSize > 1) {
                int c = this.getChannel();
                int z = this.getSlice();
                int t = this.getFrame();
                if (c > 1 || z > 1 || t > 1) {
                    this.setPosition(c, z, t);
                }
            }
            if (this.setIJMenuBar) {
                IJ.wait(25);
            }
            this.notifyListeners(0);
        }
    }

    void invertLookupTable() {
        int nImages = this.getStackSize();
        this.ip.invertLut();
        if (nImages == 1) {
            this.ip.invert();
        } else {
            ImageStack stack2 = this.getStack();
            for (int i = 1; i <= nImages; ++i) {
                stack2.getProcessor(i).invert();
            }
            stack2.setColorModel(this.ip.getColorModel());
        }
    }

    public void setActivated() {
        this.activated = true;
    }

    public Image getImage() {
        if (this.img == null && this.ip != null) {
            this.img = this.ip.createImage();
        }
        return this.img;
    }

    public BufferedImage getBufferedImage() {
        if (this.isComposite()) {
            return new ColorProcessor(this.getImage()).getBufferedImage();
        }
        return this.ip.getBufferedImage();
    }

    public int getID() {
        return this.ID;
    }

    public void setImage(Image img) {
        if (img instanceof BufferedImage) {
            BufferedImage bi = (BufferedImage)img;
            if (bi.getType() == 11) {
                this.setProcessor(null, new ShortProcessor(bi));
                return;
            }
            if (bi.getType() == 10) {
                this.setProcessor(null, new ByteProcessor(bi));
                return;
            }
        }
        this.roi = null;
        this.errorLoadingImage = false;
        this.waitForImage(img);
        if (this.errorLoadingImage) {
            throw new IllegalStateException("Error loading image");
        }
        this.img = img;
        int newWidth = img.getWidth(this.ij);
        int newHeight = img.getHeight(this.ij);
        boolean dimensionsChanged = newWidth != this.width || newHeight != this.height;
        this.width = newWidth;
        this.height = newHeight;
        this.ip = null;
        this.stack = null;
        LookUpTable lut = new LookUpTable(img);
        int type = lut.getMapSize() > 0 ? (lut.isGrayscale() ? 0 : 3) : 4;
        this.setType(type);
        this.setupProcessor();
        this.img = this.ip.createImage();
        if (this.win != null) {
            if (dimensionsChanged) {
                this.win = new ImageWindow(this);
            } else {
                this.repaintWindow();
            }
        }
    }

    public void setImage(ImagePlus imp) {
        if (imp.getWindow() != null) {
            imp = imp.duplicate();
        }
        ImageStack stack2 = imp.getStack();
        if (imp.isHyperStack()) {
            this.setOpenAsHyperStack(true);
        }
        LUT[] luts = null;
        if (imp.isComposite() && this.isComposite()) {
            if (((CompositeImage)imp).getMode() != ((CompositeImage)this).getMode()) {
                ((CompositeImage)this).setMode(((CompositeImage)imp).getMode());
            }
            luts = ((CompositeImage)imp).getLuts();
        }
        this.setStack(stack2, imp.getNChannels(), imp.getNSlices(), imp.getNFrames());
        if (luts != null) {
            ((CompositeImage)this).setLuts(luts);
            this.updateAndDraw();
        }
        this.setCalibration(imp.getCalibration());
        this.setProperty("Info", imp.getProperty("Info"));
    }

    public void setProcessor(ImageProcessor ip) {
        this.setProcessor(null, ip);
    }

    public void setProcessor(String title, ImageProcessor ip) {
        if (ip == null || ip.getPixels() == null) {
            throw new IllegalArgumentException("ip null or ip.getPixels() null");
        }
        if (this.getStackSize() > 1) {
            int stackBitDepth;
            if (ip.getWidth() != this.width || ip.getHeight() != this.height) {
                throw new IllegalArgumentException("Wrong dimensions for this stack");
            }
            int n = stackBitDepth = this.stack != null ? this.stack.getBitDepth() : 0;
            if (stackBitDepth > 0 && this.getBitDepth() != stackBitDepth) {
                throw new IllegalArgumentException("Wrong type for this stack");
            }
        } else {
            this.stack = null;
            this.setCurrentSlice(1);
        }
        this.setProcessor2(title, ip, null);
    }

    void setProcessor2(String title, ImageProcessor ip, ImageStack newStack) {
        boolean dimensionsChanged;
        if (title != null) {
            this.setTitle(title);
        }
        if (ip == null) {
            return;
        }
        if (this.ip != null && this.getWindow() != null) {
            this.notifyListeners(2);
        }
        this.ip = ip;
        if (this.ij != null) {
            ip.setProgressBar(this.ij.getProgressBar());
        }
        int stackSize = 1;
        if (this.stack != null && this.currentSlice > (stackSize = this.stack.getSize())) {
            this.setCurrentSlice(stackSize);
        }
        this.img = null;
        boolean bl = dimensionsChanged = this.width > 0 && this.height > 0 && (this.width != ip.getWidth() || this.height != ip.getHeight());
        if (dimensionsChanged) {
            this.roi = null;
        }
        int type = ip instanceof ByteProcessor ? 0 : (ip instanceof ColorProcessor ? 4 : (ip instanceof ShortProcessor ? 1 : 2));
        if (this.width == 0) {
            this.imageType = type;
        } else {
            this.setType(type);
        }
        this.width = ip.getWidth();
        this.height = ip.getHeight();
        if (this.win != null) {
            if (dimensionsChanged && stackSize == 1) {
                this.win.updateImage(this);
            } else if (newStack == null) {
                this.repaintWindow();
            }
            this.draw();
        }
    }

    public void setStack(ImageStack stack) {
        this.setStack(null, stack);
    }

    public void setStack(String title, ImageStack newStack) {
        boolean invalidDimensions;
        boolean dimensionsChanged;
        boolean resetCurrentSlice;
        Object[] arrays;
        int newStackSize = newStack.getSize();
        if (newStackSize == 0) {
            throw new IllegalArgumentException("Stack is empty");
        }
        if (!newStack.isVirtual() && ((arrays = newStack.getImageArray()) == null || arrays.length > 0 && arrays[0] == null)) {
            throw new IllegalArgumentException("Stack pixel array null");
        }
        boolean sliderChange = false;
        if (this.win != null && this.win instanceof StackWindow) {
            int nScrollbars = ((StackWindow)this.win).getNScrollbars();
            if (nScrollbars > 0 && newStackSize == 1) {
                sliderChange = true;
            } else if (nScrollbars == 0 && newStackSize > 1) {
                sliderChange = true;
            }
        }
        if (this.currentSlice < 1) {
            this.setCurrentSlice(1);
        }
        boolean bl = resetCurrentSlice = this.currentSlice > newStackSize;
        if (resetCurrentSlice) {
            this.setCurrentSlice(newStackSize);
        }
        ImageProcessor ip = newStack.getProcessor(this.currentSlice);
        boolean bl2 = dimensionsChanged = this.width > 0 && this.height > 0 && (this.width != ip.getWidth() || this.height != ip.getHeight());
        if (this.stack == null) {
            newStack.viewers(1);
        }
        this.stack = newStack;
        this.setProcessor2(title, ip, newStack);
        if (this.win == null) {
            if (resetCurrentSlice) {
                this.setSlice(this.currentSlice);
            }
            return;
        }
        boolean bl3 = invalidDimensions = (this.isDisplayedHyperStack() || this.isComposite()) && this.win instanceof StackWindow && !((StackWindow)this.win).validDimensions();
        if (newStackSize > 1 && !(this.win instanceof StackWindow)) {
            if (this.isDisplayedHyperStack()) {
                this.setOpenAsHyperStack(true);
            }
            this.win = new StackWindow(this, this.getCanvas());
            this.setPosition(1, 1, 1);
            if (Interpreter.getInstance() != null) {
                IJ.wait(25);
            }
        } else if (newStackSize > 1 && invalidDimensions) {
            if (this.isDisplayedHyperStack()) {
                this.setOpenAsHyperStack(true);
            }
            this.win = new StackWindow(this);
            this.setPosition(1, 1, 1);
        } else if (dimensionsChanged || sliderChange) {
            this.win.updateImage(this);
        } else {
            if (this.win != null && this.win instanceof StackWindow) {
                ((StackWindow)this.win).updateSliceSelector();
            }
            if (this.isComposite()) {
                ((CompositeImage)this).reset();
                this.updateAndDraw();
            }
            this.repaintWindow();
        }
        if (resetCurrentSlice) {
            this.setSlice(this.currentSlice);
        }
    }

    public void setStack(ImageStack newStack, int channels, int slices, int frames) {
        if (newStack == null || channels * slices * frames != newStack.getSize()) {
            throw new IllegalArgumentException("channels*slices*frames!=stackSize");
        }
        int channelsBefore = this.nChannels;
        if (IJ.debugMode) {
            IJ.log("setStack: " + newStack.getSize() + " " + channels + " (" + channelsBefore + ") " + slices + " " + frames + " " + this.isComposite());
        }
        this.nChannels = channels;
        this.nSlices = slices;
        this.nFrames = frames;
        if (channelsBefore != channels && this.isComposite()) {
            ImageStack stack2 = this.stack;
            this.stack = newStack;
            ((CompositeImage)this).reset();
            this.stack = stack2;
        }
        this.setStack(null, newStack);
    }

    public void setFileInfo(FileInfo fi) {
        if (fi != null) {
            fi.pixels = null;
        }
        this.fileInfo = fi;
    }

    public ImageWindow getWindow() {
        return this.win;
    }

    public boolean isVisible() {
        return this.win != null && this.win.isVisible();
    }

    public void setWindow(ImageWindow win) {
        this.win = win;
        if (this.roi != null) {
            this.roi.setImage(this);
        }
    }

    public ImageCanvas getCanvas() {
        return this.win != null ? this.win.getCanvas() : this.flatteningCanvas;
    }

    public void setColor(Color c) {
        if (this.ip != null) {
            this.ip.setColor(c);
        }
    }

    void setupProcessor() {
        if (this.imageType == 4) {
            if (this.ip == null || this.ip instanceof ByteProcessor) {
                this.ip = new ColorProcessor(this.getImage());
            }
        } else if (this.ip == null || this.ip instanceof ColorProcessor) {
            this.ip = new ByteProcessor(this.getImage());
        }
        if (this.roi != null && this.roi.isArea()) {
            this.ip.setRoi(this.roi.getBounds());
        } else {
            this.ip.resetRoi();
        }
    }

    public boolean isProcessor() {
        return this.ip != null;
    }

    public ImageProcessor getProcessor() {
        Recorder recorder;
        Calibration cal;
        if (this.ip == null && this.img == null) {
            return null;
        }
        this.setupProcessor();
        if (!this.compositeImage) {
            this.ip.setLineWidth(Line.getWidth());
        }
        if (this.ij != null) {
            this.ip.setProgressBar(this.ij.getProgressBar());
        }
        if ((cal = this.getCalibration()).calibrated()) {
            this.ip.setCalibrationTable(cal.getCTable());
        } else {
            this.ip.setCalibrationTable(null);
        }
        if (Recorder.record && (recorder = Recorder.getInstance()) != null) {
            recorder.imageUpdated(this);
        }
        return this.ip;
    }

    public void trimProcessor() {
        ImageProcessor ip2 = this.ip;
        if (!this.locked && ip2 != null) {
            Roi roi2;
            if (IJ.debugMode) {
                IJ.log(this.title + ": trimProcessor");
            }
            if ((roi2 = this.getRoi()) != null && roi2.getPasteMode() != -1) {
                roi2.endPaste();
            }
            ip2.setSnapshotPixels(null);
        }
    }

    public ImageProcessor getMask() {
        if (this.roi == null) {
            if (this.ip != null) {
                this.ip.resetRoi();
            }
            return null;
        }
        ImageProcessor mask = this.roi.getMask();
        if (mask == null) {
            return null;
        }
        if (this.ip != null && this.roi != null) {
            this.ip.setMask(mask);
            this.ip.setRoi(this.roi.getBounds());
        }
        return mask;
    }

    public ImageStatistics getStatistics() {
        return this.getStatistics(543);
    }

    public ImageStatistics getAllStatistics() {
        return this.getStatistics(1043455);
    }

    public ImageStatistics getRawStatistics() {
        this.setupProcessor();
        if (this.roi != null && this.roi.isArea()) {
            this.ip.setRoi(this.roi);
        } else {
            this.ip.resetRoi();
        }
        return ImageStatistics.getStatistics(this.ip, 27, null);
    }

    public ImageStatistics getStatistics(int mOptions) {
        return this.getStatistics(mOptions, 256, 0.0, 0.0);
    }

    public ImageStatistics getStatistics(int mOptions, int nBins) {
        return this.getStatistics(mOptions, nBins, 0.0, 0.0);
    }

    public ImageStatistics getStatistics(int mOptions, int nBins, double histMin, double histMax) {
        this.setupProcessor();
        if (this.roi != null && this.roi.isArea()) {
            this.ip.setRoi(this.roi);
        } else {
            this.ip.resetRoi();
        }
        this.ip.setHistogramSize(nBins);
        Calibration cal = this.getCalibration();
        if (this.getType() == 1 && (histMin != 0.0 || histMax != 0.0)) {
            histMin = cal.getRawValue(histMin);
            histMax = cal.getRawValue(histMax);
        }
        this.ip.setHistogramRange(histMin, histMax);
        ImageStatistics stats = ImageStatistics.getStatistics(this.ip, mOptions, cal);
        this.ip.setHistogramSize(256);
        this.ip.setHistogramRange(0.0, 0.0);
        return stats;
    }

    public String getTitle() {
        if (this.title == null) {
            return "";
        }
        return this.title;
    }

    public String getShortTitle() {
        String title = this.getTitle();
        int index = title.indexOf(32);
        if (index > -1) {
            title = title.substring(0, index);
        }
        if ((index = title.lastIndexOf(46)) > 0) {
            title = title.substring(0, index);
        }
        return title;
    }

    public void setTitle(String title) {
        if (title == null) {
            return;
        }
        if (this.win != null) {
            if (this.ij != null) {
                Menus.updateWindowMenuItem(this, this.title, title);
            }
            String virtual = this.stack != null && this.stack.isVirtual() ? " (V)" : "";
            String global = this.getGlobalCalibration() != null ? " (G)" : "";
            String scale = "";
            double magnification = this.win.getCanvas().getMagnification();
            if (magnification != 1.0) {
                double percent = magnification * 100.0;
                int digits = percent > 100.0 || percent == (double)((int)percent) ? 0 : 1;
                scale = " (" + IJ.d2s(percent, digits) + "%)";
            }
            this.win.setTitle(title + virtual + global + scale);
        }
        boolean titleChanged = !title.equals(this.title);
        this.title = title;
        if (titleChanged && listeners.size() > 0) {
            this.notifyListeners(2);
        }
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getStackSize() {
        if (this.stack == null) {
            return 1;
        }
        int slices = this.stack.getSize();
        if (slices <= 0) {
            slices = 1;
        }
        return slices;
    }

    public int getImageStackSize() {
        if (this.stack == null) {
            return 1;
        }
        int slices = this.stack.getSize();
        if (slices == 0) {
            slices = 1;
        }
        return slices;
    }

    public void setDimensions(int nChannels, int nSlices, int nFrames) {
        boolean newSingleImage;
        if (nChannels * nSlices * nFrames != this.getImageStackSize() && this.ip != null) {
            nChannels = 1;
            nSlices = this.getImageStackSize();
            nFrames = 1;
            if (this.isDisplayedHyperStack()) {
                this.setOpenAsHyperStack(false);
                new StackWindow(this);
                this.setSlice(1);
            }
        }
        boolean updateWin = this.isDisplayedHyperStack() && (this.nChannels != nChannels || this.nSlices != nSlices || this.nFrames != nFrames);
        boolean bl = newSingleImage = this.win != null && this.win instanceof StackWindow && nChannels == 1 && nSlices == 1 && nFrames == 1;
        if (newSingleImage) {
            updateWin = true;
        }
        this.nChannels = nChannels;
        this.nSlices = nSlices;
        this.nFrames = nFrames;
        if (updateWin) {
            if (nSlices != this.getImageStackSize()) {
                this.setOpenAsHyperStack(true);
            }
            this.ip = null;
            this.img = null;
            this.setPositionWithoutUpdate(this.getChannel(), this.getSlice(), this.getFrame());
            if (this.isComposite()) {
                ((CompositeImage)this).reset();
            }
            new StackWindow(this);
        }
        this.dimensionsSet = true;
    }

    public boolean isHyperStack() {
        return this.isDisplayedHyperStack() || this.openAsHyperStack && this.getNDimensions() > 3;
    }

    public int getNDimensions() {
        int dimensions = 2;
        int[] dim = this.getDimensions(true);
        if (dim[2] > 1) {
            ++dimensions;
        }
        if (dim[3] > 1) {
            ++dimensions;
        }
        if (dim[4] > 1) {
            ++dimensions;
        }
        return dimensions;
    }

    public boolean isDisplayedHyperStack() {
        return this.win != null && this.win instanceof StackWindow && ((StackWindow)this.win).isHyperStack();
    }

    public int getNChannels() {
        this.verifyDimensions();
        return this.nChannels;
    }

    public int getNSlices() {
        this.verifyDimensions();
        return this.nSlices;
    }

    public int getNFrames() {
        this.verifyDimensions();
        return this.nFrames;
    }

    public int[] getDimensions() {
        return this.getDimensions(true);
    }

    public int[] getDimensions(boolean varify) {
        if (varify) {
            this.verifyDimensions();
        }
        int[] d = new int[]{this.width, this.height, this.nChannels, this.nSlices, this.nFrames};
        return d;
    }

    void verifyDimensions() {
        int stackSize = this.getImageStackSize();
        if (this.nSlices == 1) {
            if (this.nChannels > 1 && this.nFrames == 1) {
                this.nChannels = stackSize;
            } else if (this.nFrames > 1 && this.nChannels == 1) {
                this.nFrames = stackSize;
            }
        }
        if (this.nChannels * this.nSlices * this.nFrames != stackSize) {
            this.nSlices = stackSize;
            this.nChannels = 1;
            this.nFrames = 1;
        }
    }

    public int getType() {
        return this.imageType;
    }

    public int getBitDepth() {
        if (this.imageType == 0 && this.ip == null && this.img == null && !this.typeSet) {
            return 0;
        }
        int bitDepth = 0;
        switch (this.imageType) {
            case 0: 
            case 3: {
                bitDepth = 8;
                break;
            }
            case 1: {
                bitDepth = 16;
                break;
            }
            case 2: {
                bitDepth = 32;
                break;
            }
            case 4: {
                bitDepth = 24;
            }
        }
        return bitDepth;
    }

    public int getBytesPerPixel() {
        switch (this.imageType) {
            case 1: {
                return 2;
            }
            case 2: 
            case 4: {
                return 4;
            }
        }
        return 1;
    }

    protected void setType(int type) {
        if (type < 0 || type > 4) {
            return;
        }
        int previousType = this.imageType;
        this.imageType = type;
        this.typeSet = true;
        if (this.imageType != previousType) {
            if (this.win != null) {
                Menus.updateMenus();
            }
            this.getLocalCalibration().setImage(this);
        }
    }

    public String getStringProperty(String key) {
        String value;
        ImageStack stack;
        String label;
        if (key == null) {
            return null;
        }
        if (this.isDicomTag(key)) {
            return DicomTools.getTag(this, key);
        }
        if (this.getStackSize() > 1 && (label = (stack = this.getStack()).getSliceLabel(this.getCurrentSlice())) != null && label.indexOf(10) > 0 && (value = this.getStringProperty(key, label)) != null) {
            return value;
        }
        Object obj = this.getProperty("Info");
        if (obj == null || !(obj instanceof String)) {
            return null;
        }
        String info = (String)obj;
        return this.getStringProperty(key, info);
    }

    private boolean isDicomTag(String key) {
        if (key.length() != 9 || key.charAt(4) != ',') {
            return false;
        }
        key = key.toLowerCase();
        for (int i = 0; i < 9; ++i) {
            char c;
            char c2 = c = i != 4 ? (char)key.charAt(i) : (char)'0';
            if (Character.isDigit(c) || c == 97 || c == 98 || c == 99 || c == 100 || c == 101 || c == 102) continue;
            return false;
        }
        return true;
    }

    public double getNumericProperty(String key) {
        return Tools.parseDouble(this.getStringProperty(key));
    }

    public String getProp(String key) {
        return this.getStringProperty(key);
    }

    private String getStringProperty(String key, String info) {
        int index1 = -1;
        index1 = this.findKey(info, key + ": ");
        if (index1 < 0) {
            index1 = this.findKey(info, key + " = ");
        }
        if (index1 < 0) {
            return null;
        }
        if (index1 == info.length()) {
            return "";
        }
        int index2 = info.indexOf("\n", index1);
        if (index2 == -1) {
            index2 = info.length();
        }
        String value = info.substring(index1, index2);
        return value;
    }

    private int findKey(String s, String key) {
        int i = s.indexOf(key);
        if (i < 0) {
            return -1;
        }
        while (i > 0 && Character.isLetterOrDigit(s.charAt(i - 1))) {
            i = s.indexOf(key, i + key.length());
        }
        if (i >= 0) {
            return i + key.length();
        }
        return -1;
    }

    public String getInfoProperty() {
        String info = null;
        Object obj = this.getProperty("Info");
        if (obj != null && obj instanceof String && (info = (String)obj).length() == 0) {
            info = null;
        }
        return info;
    }

    public Object getProperty(String key) {
        if (this.properties == null) {
            return null;
        }
        return this.properties.get(key);
    }

    public void setProperty(String key, Object value) {
        if (this.properties == null) {
            this.properties = new Properties();
        }
        if (value == null) {
            this.properties.remove(key);
        } else {
            this.properties.put(key, value);
        }
    }

    public Properties getProperties() {
        return this.properties;
    }

    public LookUpTable createLut() {
        ImageProcessor ip2 = this.getProcessor();
        if (ip2 != null) {
            return new LookUpTable(ip2.getColorModel());
        }
        return new LookUpTable(LookUpTable.createGrayscaleColorModel(false));
    }

    public boolean isInvertedLut() {
        if (this.ip == null) {
            if (this.img == null) {
                return false;
            }
            this.setupProcessor();
        }
        return this.ip.isInvertedLut();
    }

    public int[] getPixel(int x, int y) {
        this.pvalue[3] = 0;
        this.pvalue[2] = 0;
        this.pvalue[1] = 0;
        this.pvalue[0] = 0;
        switch (this.imageType) {
            case 0: 
            case 3: {
                int index;
                if (this.ip != null) {
                    index = this.ip.getPixel(x, y);
                } else {
                    if (this.img == null) {
                        return this.pvalue;
                    }
                    PixelGrabber pg = new PixelGrabber(this.img, x, y, 1, 1, false);
                    try {
                        pg.grabPixels();
                    }
                    catch (InterruptedException e) {
                        return this.pvalue;
                    }
                    byte[] pixels8 = (byte[])pg.getPixels();
                    int n = index = pixels8 != null ? pixels8[0] & 0xFF : 0;
                }
                if (this.imageType != 3) {
                    this.pvalue[0] = index;
                    return this.pvalue;
                }
                this.pvalue[3] = index;
            }
            case 4: {
                int c = 0;
                if (this.imageType == 4 && this.ip != null) {
                    c = this.ip.getPixel(x, y);
                } else {
                    int[] pixels32 = new int[1];
                    if (this.img == null) {
                        return this.pvalue;
                    }
                    PixelGrabber pg = new PixelGrabber(this.img, x, y, 1, 1, pixels32, 0, this.width);
                    try {
                        pg.grabPixels();
                    }
                    catch (InterruptedException e) {
                        return this.pvalue;
                    }
                    c = pixels32[0];
                }
                int r = (c & 0xFF0000) >> 16;
                int g = (c & 0xFF00) >> 8;
                int b = c & 0xFF;
                this.pvalue[0] = r;
                this.pvalue[1] = g;
                this.pvalue[2] = b;
                break;
            }
            case 1: 
            case 2: {
                if (this.ip == null) break;
                this.pvalue[0] = this.ip.getPixel(x, y);
            }
        }
        return this.pvalue;
    }

    public ImageStack createEmptyStack() {
        ColorModel cm = this.ip != null ? this.ip.getColorModel() : this.createLut().getColorModel();
        return new ImageStack(this.width, this.height, cm);
    }

    public ImageStack getStack() {
        ImageStack s;
        if (this.stack == null) {
            s = this.createEmptyStack();
            ImageProcessor ip2 = this.getProcessor();
            if (ip2 == null) {
                return s;
            }
            String info = (String)this.getProperty("Info");
            String label = info != null ? this.getTitle() + "\n" + info : null;
            s.addSlice(label, ip2);
            s.update(ip2);
        } else {
            s = this.stack;
            if (this.ip != null) {
                Calibration cal = this.getCalibration();
                if (cal.calibrated()) {
                    this.ip.setCalibrationTable(cal.getCTable());
                } else {
                    this.ip.setCalibrationTable(null);
                }
            }
            s.update(this.ip);
        }
        if (this.roi != null) {
            s.setRoi(this.roi.getBounds());
        } else {
            s.setRoi(null);
        }
        return s;
    }

    public ImageStack getImageStack() {
        if (this.stack == null) {
            return this.getStack();
        }
        this.stack.update(this.ip);
        return this.stack;
    }

    public int getCurrentSlice() {
        if (this.currentSlice < 1) {
            this.setCurrentSlice(1);
        }
        if (this.currentSlice > this.getStackSize()) {
            this.setCurrentSlice(this.getStackSize());
        }
        return this.currentSlice;
    }

    final void setCurrentSlice(int slice) {
        this.currentSlice = slice;
        int stackSize = this.getStackSize();
        if (this.nChannels == stackSize) {
            this.updatePosition(this.currentSlice, 1, 1);
        }
        if (this.nSlices == stackSize) {
            this.updatePosition(1, this.currentSlice, 1);
        }
        if (this.nFrames == stackSize) {
            this.updatePosition(1, 1, this.currentSlice);
        }
    }

    public int getChannel() {
        return this.position[0];
    }

    public int getSlice() {
        return this.position[1];
    }

    public int getFrame() {
        return this.position[2];
    }

    public void killStack() {
        this.stack = null;
        this.trimProcessor();
    }

    public void setPosition(int channel, int slice, int frame) {
        this.verifyDimensions();
        if (channel < 0) {
            channel = 0;
        }
        if (slice < 0) {
            slice = 0;
        }
        if (frame < 0) {
            frame = 0;
        }
        if (channel == 0) {
            channel = this.getC();
        }
        if (slice == 0) {
            slice = this.getZ();
        }
        if (frame == 0) {
            frame = this.getT();
        }
        if (channel > this.nChannels) {
            channel = this.nChannels;
        }
        if (slice > this.nSlices) {
            slice = this.nSlices;
        }
        if (frame > this.nFrames) {
            frame = this.nFrames;
        }
        if (this.isDisplayedHyperStack()) {
            ((StackWindow)this.win).setPosition(channel, slice, frame);
        } else {
            boolean channelChanged = channel != this.getChannel();
            this.setSlice((frame - 1) * this.nChannels * this.nSlices + (slice - 1) * this.nChannels + channel);
            this.updatePosition(channel, slice, frame);
            if (channelChanged && this.isComposite()) {
                this.updateImage();
            }
        }
    }

    public void setPositionWithoutUpdate(int channel, int slice, int frame) {
        this.noUpdateMode = true;
        this.setPosition(channel, slice, frame);
        this.noUpdateMode = false;
    }

    public void setC(int channel) {
        this.setPosition(channel, this.getZ(), this.getT());
    }

    public void setZ(int slice) {
        this.setPosition(this.getC(), slice, this.getT());
    }

    public void setT(int frame) {
        this.setPosition(this.getC(), this.getZ(), frame);
    }

    public int getC() {
        return this.position[0];
    }

    public int getZ() {
        return this.position[1];
    }

    public int getT() {
        return this.position[2];
    }

    public int getStackIndex(int channel, int slice, int frame) {
        if (channel < 1) {
            channel = 1;
        }
        if (channel > this.nChannels) {
            channel = this.nChannels;
        }
        if (slice < 1) {
            slice = 1;
        }
        if (slice > this.nSlices) {
            slice = this.nSlices;
        }
        if (frame < 1) {
            frame = 1;
        }
        if (frame > this.nFrames) {
            frame = this.nFrames;
        }
        return (frame - 1) * this.nChannels * this.nSlices + (slice - 1) * this.nChannels + channel;
    }

    public void resetStack() {
        if (this.currentSlice == 1 && this.stack != null && this.stack.getSize() > 0) {
            ColorModel cm = this.ip.getColorModel();
            double min = this.ip.getMin();
            double max = this.ip.getMax();
            this.ip = this.stack.getProcessor(1);
            this.ip.setColorModel(cm);
            this.ip.setMinAndMax(min, max);
        }
    }

    public void setPosition(int n) {
        int[] pos = this.convertIndexToPosition(n);
        this.setPosition(pos[0], pos[1], pos[2]);
    }

    public int[] convertIndexToPosition(int n) {
        if (n < 1 || n > this.getStackSize()) {
            throw new IllegalArgumentException("n out of range: " + n);
        }
        int[] position = new int[3];
        int[] dim = this.getDimensions();
        position[0] = (n - 1) % dim[2] + 1;
        position[1] = (n - 1) / dim[2] % dim[3] + 1;
        position[2] = (n - 1) / (dim[2] * dim[3]) % dim[4] + 1;
        return position;
    }

    public synchronized void setSlice(int n) {
        if (this.stack == null || n == this.currentSlice && this.ip != null) {
            if (!this.noUpdateMode) {
                this.updateAndRepaintWindow();
            }
            return;
        }
        if (n >= 1 && n <= this.stack.getSize()) {
            int channel;
            Roi roi = this.getRoi();
            if (roi != null) {
                roi.endPaste();
            }
            if (this.isProcessor()) {
                this.stack.setPixels(this.ip.getPixels(), this.currentSlice);
            }
            this.ip = this.getProcessor();
            this.setCurrentSlice(n);
            Object pixels = null;
            Overlay overlay2 = null;
            if (this.stack.isVirtual() && !(this.stack instanceof FileInfoVirtualStack) && !(this.stack instanceof AVI_Reader)) {
                ImageProcessor ip2 = this.stack.getProcessor(this.currentSlice);
                overlay2 = ip2.getOverlay();
                if (overlay2 != null) {
                    this.setOverlay(overlay2);
                }
                pixels = ip2.getPixels();
            } else {
                pixels = this.stack.getPixels(this.currentSlice);
            }
            if (this.ip != null && pixels != null) {
                try {
                    this.ip.setPixels(pixels);
                    this.ip.setSnapshotPixels(null);
                }
                catch (Exception e) {}
            } else {
                this.ip = this.stack.getProcessor(n);
            }
            if (this.compositeImage && this.getCompositeMode() == 1 && this.ip != null && (channel = this.getC()) > 0 && channel <= this.getNChannels()) {
                this.ip.setLut(((CompositeImage)this).getChannelLut(channel));
            }
            if (this.win != null && this.win instanceof StackWindow) {
                ((StackWindow)this.win).updateSliceSelector();
            }
            if ((Prefs.autoContrast || IJ.shiftKeyDown()) && this.nChannels == 1 && this.imageType != 4) {
                new ContrastEnhancer().stretchHistogram(this.ip, 0.35, this.ip.getStats());
                ContrastAdjuster.update();
            }
            if (this.imageType == 4) {
                ContrastAdjuster.update();
            } else if (this.imageType == 1 || this.imageType == 2) {
                ThresholdAdjuster.update();
            }
            if (!this.noUpdateMode) {
                this.updateAndRepaintWindow();
            } else {
                this.img = null;
            }
        }
    }

    public void setSliceWithoutUpdate(int n) {
        this.noUpdateMode = true;
        this.setSlice(n);
        this.noUpdateMode = false;
    }

    public Roi getRoi() {
        return this.roi;
    }

    public void setRoi(Roi newRoi) {
        this.setRoi(newRoi, true);
    }

    public void setRoi(Roi newRoi, boolean updateDisplay) {
        Recorder recorder;
        if (newRoi == null) {
            this.deleteRoi();
            return;
        }
        if (Recorder.record && (recorder = Recorder.getInstance()) != null) {
            recorder.imageUpdated(this);
        }
        Rectangle bounds = newRoi.getBounds();
        if (newRoi.isVisible()) {
            if (newRoi instanceof Arrow && newRoi.getState() == 0 && bounds.width == 0 && bounds.height == 0) {
                this.deleteRoi();
                this.roi = newRoi;
                return;
            }
            if ((newRoi = (Roi)newRoi.clone()) == null) {
                this.deleteRoi();
                return;
            }
        }
        if (bounds.width == 0 && bounds.height == 0 && newRoi.getType() != 10 && newRoi.getType() != 5) {
            this.deleteRoi();
            return;
        }
        this.roi = newRoi;
        if (this.ip != null) {
            this.ip.setMask(null);
            if (this.roi.isArea()) {
                this.ip.setRoi(bounds);
            } else {
                this.ip.resetRoi();
            }
        }
        this.roi.setImage(this);
        if (updateDisplay) {
            this.draw();
        }
    }

    public void setRoi(int x, int y, int width, int height) {
        this.setRoi(new Rectangle(x, y, width, height));
    }

    public void setRoi(Rectangle r) {
        this.setRoi(new Roi(r.x, r.y, r.width, r.height));
    }

    public void createNewRoi(int sx, int sy) {
        this.deleteRoi();
        switch (Toolbar.getToolId()) {
            case 0: {
                if (Toolbar.getRectToolType() == 2) {
                    this.roi = new RotatedRectRoi(sx, sy, this);
                    break;
                }
                this.roi = new Roi(sx, sy, this, Toolbar.getRoundRectArcSize());
                break;
            }
            case 1: {
                if (Toolbar.getOvalToolType() == 1) {
                    this.roi = new EllipseRoi(sx, sy, this);
                    break;
                }
                this.roi = new OvalRoi(sx, sy, this);
                break;
            }
            case 2: 
            case 5: 
            case 14: {
                this.roi = new PolygonRoi(sx, sy, this);
                break;
            }
            case 3: 
            case 6: {
                this.roi = new FreehandRoi(sx, sy, this);
                break;
            }
            case 4: {
                if ("arrow".equals(Toolbar.getToolName())) {
                    this.roi = new Arrow(sx, sy, this);
                    break;
                }
                this.roi = new Line(sx, sy, this);
                break;
            }
            case 9: {
                this.roi = new TextRoi(sx, sy, this);
                break;
            }
            case 7: {
                this.roi = new PointRoi(sx, sy, this);
                if (Prefs.pointAddToOverlay) {
                    Overlay overlay2;
                    int measurements = Analyzer.getMeasurements();
                    if (!Prefs.pointAutoMeasure || (measurements & 0x400000) == 0) {
                        IJ.run(this, "Add Selection...", "");
                    }
                    if ((overlay2 = this.getOverlay()) != null) {
                        overlay2.drawLabels(!Prefs.noPointLabels);
                    }
                    Prefs.pointAddToManager = false;
                }
                if (Prefs.pointAutoMeasure || Prefs.pointAutoNextSlice && !Prefs.pointAddToManager) {
                    IJ.run(this, "Measure", "");
                }
                if (Prefs.pointAddToManager) {
                    RoiManager rm;
                    IJ.run(this, "Add to Manager ", "");
                    ImageCanvas ic = this.getCanvas();
                    if (ic != null && (rm = RoiManager.getInstance()) != null) {
                        if (Prefs.noPointLabels) {
                            rm.runCommand("show all without labels");
                        } else {
                            rm.runCommand("show all with labels");
                        }
                    }
                }
                if (!Prefs.pointAutoNextSlice || this.getStackSize() <= 1) break;
                IJ.run(this, "Next Slice [>]", "");
                this.deleteRoi();
            }
        }
    }

    public void deleteRoi() {
        if (this.roi != null) {
            RoiManager rm;
            this.saveRoi();
            if (!IJ.altKeyDown() && !IJ.shiftKeyDown() && (rm = RoiManager.getInstance()) != null) {
                rm.deselect(this.roi);
            }
            this.roi.notifyListeners(6);
            if (this.roi instanceof PointRoi) {
                ((PointRoi)this.roi).resetCounters();
            }
            this.roi = null;
            if (this.ip != null) {
                this.ip.resetRoi();
            }
            this.draw();
        }
    }

    public void killRoi() {
        this.deleteRoi();
    }

    public synchronized void saveRoi() {
        if (this.roi != null) {
            this.roi.endPaste();
            Rectangle r = this.roi.getBounds();
            if (r.width > 0 || r.height > 0) {
                Roi.previousRoi = (Roi)this.roi.clone();
                if (IJ.debugMode) {
                    IJ.log("saveRoi: " + this.roi);
                }
            }
        }
    }

    public void restoreRoi() {
        if (Roi.previousRoi != null) {
            Roi pRoi = Roi.previousRoi;
            Rectangle r = pRoi.getBounds();
            if (r.width <= this.width || r.height <= this.height || r.x < this.width && r.y < this.height || this.isSmaller(pRoi)) {
                this.roi = (Roi)pRoi.clone();
                this.roi.setImage(this);
                if (r.x >= this.width || r.y >= this.height || r.x + r.width < 0 || r.y + r.height < 0) {
                    this.roi.setLocation((this.width - r.width) / 2, (this.height - r.height) / 2);
                } else if (r.width == this.width && r.height == this.height) {
                    this.roi.setLocation(0, 0);
                }
                this.draw();
                this.roi.notifyListeners(1);
            }
        }
    }

    boolean isSmaller(Roi r) {
        ImageProcessor mask = r.getMask();
        if (mask == null) {
            return false;
        }
        mask.setThreshold(255.0, 255.0, 2);
        ImageStatistics stats = ImageStatistics.getStatistics(mask, 258, null);
        return stats.area <= (double)(this.width * this.height);
    }

    public void revert() {
        boolean isFileInfo;
        if (this.getStackSize() > 1 && this.getStack().isVirtual()) {
            return;
        }
        FileInfo fi = this.getOriginalFileInfo();
        boolean bl = isFileInfo = fi != null && fi.fileFormat != 0;
        if (!isFileInfo && this.url == null) {
            return;
        }
        if (fi.directory == null && this.url == null) {
            return;
        }
        if (this.ij != null && this.changes && isFileInfo && !Interpreter.isBatchMode() && !IJ.isMacro() && !IJ.altKeyDown() && !IJ.showMessageWithCancel("Revert?", "Revert to saved version of\n\"" + this.getTitle() + "\"?")) {
            return;
        }
        Roi saveRoi = null;
        if (this.roi != null) {
            this.roi.endPaste();
            saveRoi = (Roi)this.roi.clone();
        }
        this.trimProcessor();
        new FileOpener(fi).revertToSaved(this);
        if (Prefs.useInvertingLut && this.getBitDepth() == 8 && this.ip != null && !this.ip.isInvertedLut() && !this.ip.isColorLut()) {
            this.invertLookupTable();
        }
        if (this.getProperty("FHT") != null) {
            this.properties.remove("FHT");
            if (this.getTitle().startsWith("FFT of ")) {
                this.setTitle(this.getTitle().substring(7));
            }
        }
        ContrastAdjuster.update();
        if (saveRoi != null) {
            this.setRoi(saveRoi);
        }
        this.repaintWindow();
        IJ.showStatus("");
        this.changes = false;
        this.notifyListeners(2);
    }

    void revertStack(FileInfo fi) {
        String path = null;
        String url2 = null;
        if (this.url != null && !this.url.equals("")) {
            path = this.url;
            url2 = this.url;
        } else if (fi != null && fi.directory != null && !fi.directory.equals("")) {
            path = fi.directory + fi.fileName;
        } else if (fi != null && fi.url != null && !fi.url.equals("")) {
            path = fi.url;
            url2 = fi.url;
        } else {
            return;
        }
        IJ.showStatus("Loading: " + path);
        ImagePlus imp = IJ.openImage(path);
        if (imp != null) {
            int n = imp.getStackSize();
            int c = imp.getNChannels();
            int z = imp.getNSlices();
            int t = imp.getNFrames();
            if (z == n || t == n || c == this.getNChannels() && z == this.getNSlices() && t == this.getNFrames()) {
                this.setCalibration(imp.getCalibration());
                this.setStack(imp.getStack(), c, z, t);
            } else {
                ImageWindow win = this.getWindow();
                Point loc = null;
                if (win != null) {
                    loc = win.getLocation();
                }
                this.changes = false;
                this.close();
                FileInfo fi2 = imp.getOriginalFileInfo();
                if (fi2 != null && (fi2.url == null || fi2.url.length() == 0)) {
                    fi2.url = url2;
                    imp.setFileInfo(fi2);
                }
                ImageWindow.setNextLocation(loc);
                imp.show();
            }
        }
    }

    public FileInfo getFileInfo() {
        FileInfo fi = new FileInfo();
        fi.width = this.width;
        fi.height = this.height;
        fi.nImages = this.getStackSize();
        if (this.compositeImage) {
            fi.nImages = this.getImageStackSize();
        }
        fi.whiteIsZero = this.isInvertedLut();
        fi.intelByteOrder = false;
        this.setupProcessor();
        fi.pixels = fi.nImages == 1 ? this.ip.getPixels() : this.stack.getImageArray();
        Calibration cal = this.getCalibration();
        if (cal.scaled()) {
            fi.pixelWidth = cal.pixelWidth;
            fi.pixelHeight = cal.pixelHeight;
            fi.unit = cal.getUnit();
        }
        if (fi.nImages > 1) {
            fi.pixelDepth = cal.pixelDepth;
        }
        fi.frameInterval = cal.frameInterval;
        if (cal.calibrated()) {
            fi.calibrationFunction = cal.getFunction();
            fi.coefficients = cal.getCoefficients();
            fi.valueUnit = cal.getValueUnit();
        } else if (!"Gray Value".equals(cal.getValueUnit())) {
            fi.valueUnit = cal.getValueUnit();
        }
        switch (this.imageType) {
            case 0: 
            case 3: {
                LookUpTable lut = this.createLut();
                fi.fileType = this.imageType == 3 || !lut.isGrayscale() ? 5 : 0;
                this.addLut(lut, fi);
                break;
            }
            case 1: {
                LookUpTable lut;
                fi.fileType = this.compositeImage && fi.nImages == 3 ? ("Red".equals(this.getStack().getSliceLabel(1)) ? 12 : 2) : 2;
                if (this.compositeImage || (lut = this.createLut()).isGrayscale()) break;
                this.addLut(lut, fi);
                break;
            }
            case 2: {
                LookUpTable lut;
                fi.fileType = 4;
                if (this.compositeImage || (lut = this.createLut()).isGrayscale()) break;
                this.addLut(lut, fi);
                break;
            }
            case 4: {
                fi.fileType = 6;
                break;
            }
        }
        return fi;
    }

    private void addLut(LookUpTable lut, FileInfo fi) {
        fi.lutSize = lut.getMapSize();
        fi.reds = lut.getReds();
        fi.greens = lut.getGreens();
        fi.blues = lut.getBlues();
    }

    public FileInfo getOriginalFileInfo() {
        if (this.fileInfo == null & this.url != null) {
            this.fileInfo = new FileInfo();
            this.fileInfo.width = this.width;
            this.fileInfo.height = this.height;
            this.fileInfo.url = this.url;
            this.fileInfo.directory = null;
        }
        return this.fileInfo;
    }

    @Override
    public boolean imageUpdate(Image img, int flags, int x, int y, int w, int h) {
        this.imageUpdateY = y;
        this.imageUpdateW = w;
        if ((flags & 0x40) != 0) {
            this.errorLoadingImage = true;
            return false;
        }
        this.imageLoaded = (flags & 0xB0) != 0;
        return !this.imageLoaded;
    }

    public synchronized void flush() {
        this.notifyListeners(1);
        if (this.locked || this.ignoreFlush) {
            return;
        }
        this.ip = null;
        if (this.roi != null) {
            this.roi.setImage(null);
        }
        this.roi = null;
        if (this.stack != null && this.stack.viewers(-1) <= 0) {
            Object[] arrays = this.stack.getImageArray();
            if (arrays != null) {
                for (int i = 0; i < arrays.length; ++i) {
                    arrays[i] = null;
                }
            }
            if (this.isComposite()) {
                ((CompositeImage)this).setChannelsUpdated();
            }
        }
        this.stack = null;
        this.img = null;
        this.win = null;
        if (this.roi != null) {
            this.roi.setImage(null);
        }
        this.roi = null;
        this.properties = null;
        this.overlay = null;
        this.flatteningCanvas = null;
    }

    public void setIgnoreFlush(boolean ignoreFlush) {
        this.ignoreFlush = ignoreFlush;
    }

    public ImagePlus duplicate() {
        return new Duplicator().run(this);
    }

    public ImagePlus crop() {
        return new Duplicator().crop(this);
    }

    public ImagePlus createImagePlus() {
        FileInfo fi;
        ImagePlus imp2 = new ImagePlus();
        imp2.setType(this.getType());
        imp2.setCalibration(this.getCalibration());
        String info = (String)this.getProperty("Info");
        if (info != null) {
            imp2.setProperty("Info", info);
        }
        if ((fi = this.getOriginalFileInfo()) != null) {
            fi = (FileInfo)fi.clone();
            fi.directory = null;
            fi.url = null;
            imp2.setFileInfo(fi);
        }
        return imp2;
    }

    public ImagePlus createHyperStack(String title, int channels, int slices, int frames, int bitDepth) {
        int size = channels * slices * frames;
        ImageStack stack2 = new ImageStack(this.width, this.height, size);
        ImageProcessor ip2 = null;
        switch (bitDepth) {
            case 8: {
                ip2 = new ByteProcessor(this.width, this.height);
                break;
            }
            case 16: {
                ip2 = new ShortProcessor(this.width, this.height);
                break;
            }
            case 24: {
                ip2 = new ColorProcessor(this.width, this.height);
                break;
            }
            case 32: {
                ip2 = new FloatProcessor(this.width, this.height);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid bit depth");
            }
        }
        stack2.setPixels(ip2.getPixels(), 1);
        ImagePlus imp2 = new ImagePlus(title, stack2);
        stack2.setPixels(null, 1);
        imp2.setDimensions(channels, slices, frames);
        imp2.setCalibration(this.getCalibration());
        imp2.setOpenAsHyperStack(true);
        return imp2;
    }

    public void copyScale(ImagePlus imp) {
        if (imp != null && globalCalibration == null) {
            this.setCalibration(imp.getCalibration());
        }
    }

    public void copyAttributes(ImagePlus imp) {
        Object info;
        if (IJ.debugMode) {
            IJ.log("copyAttributes: " + imp.getID() + "  " + this.getID() + " " + imp + "   " + this);
        }
        if (imp == null || imp.getWindow() != null) {
            throw new IllegalArgumentException("Souce image is null or displayed");
        }
        this.ID = imp.getID();
        this.setTitle(imp.getTitle());
        this.setCalibration(imp.getCalibration());
        FileInfo fi = imp.getOriginalFileInfo();
        if (fi != null) {
            this.setFileInfo(fi);
        }
        if ((info = imp.getProperty("Info")) != null) {
            this.setProperty("Info", imp.getProperty("Info"));
        }
    }

    public void startTiming() {
        this.startTime = System.currentTimeMillis();
    }

    public long getStartTime() {
        return this.startTime;
    }

    public Calibration getCalibration() {
        if (globalCalibration != null && !this.ignoreGlobalCalibration) {
            Calibration gc = globalCalibration.copy();
            gc.setImage(this);
            return gc;
        }
        if (this.calibration == null) {
            this.calibration = new Calibration(this);
        }
        return this.calibration;
    }

    public void setCalibration(Calibration cal) {
        if (cal == null) {
            this.calibration = null;
        } else {
            this.calibration = cal.copy();
            this.calibration.setImage(this);
        }
    }

    public void setGlobalCalibration(Calibration global) {
        globalCalibration = global == null ? null : global.copy();
    }

    public Calibration getGlobalCalibration() {
        return globalCalibration;
    }

    public static Calibration getStaticGlobalCalibration() {
        return globalCalibration;
    }

    public Calibration getLocalCalibration() {
        if (this.calibration == null) {
            this.calibration = new Calibration(this);
        }
        return this.calibration;
    }

    public void setIgnoreGlobalCalibration(boolean ignoreGlobalCalibration) {
        this.ignoreGlobalCalibration = ignoreGlobalCalibration;
    }

    public void mouseMoved(int x, int y) {
        if (this.ij != null) {
            this.ij.showStatus(this.getLocationAsString(x, y) + this.getValueAsString(x, y));
        }
        this.savex = x;
        this.savey = y;
    }

    public void updateStatusbarValue() {
        IJ.showStatus(this.getLocationAsString(this.savex, this.savey) + this.getValueAsString(this.savex, this.savey));
    }

    String getFFTLocation(int x, int y, Calibration cal) {
        double center = (double)this.width / 2.0;
        double r = Math.sqrt(((double)x - center) * ((double)x - center) + ((double)y - center) * ((double)y - center));
        double theta = Math.atan2((double)y - center, (double)x - center);
        if ((theta = theta * 180.0 / Math.PI) < 0.0) {
            theta = 360.0 + theta;
        }
        String s = "r=";
        if (r < 1.0) {
            return s + "Infinity/c (0)";
        }
        s = cal.scaled() ? s + IJ.d2s((double)this.width / r * cal.pixelWidth, 2) + " " + cal.getUnit() + "/c (" + IJ.d2s(r, 0) + ")" : s + IJ.d2s((double)this.width / r, 2) + " p/c (" + IJ.d2s(r, 0) + ")";
        s = s + ", theta= " + IJ.d2s(theta, 2) + '\u00b0';
        return s;
    }

    public String getLocationAsString(int x, int y) {
        Calibration cal = this.getCalibration();
        if (this.getProperty("FHT") != null) {
            return this.getFFTLocation(x, this.height - y, cal);
        }
        if (!IJ.altKeyDown() && !IJ.shiftKeyDown()) {
            String s = " x=" + this.d2s(cal.getX(x)) + ", y=" + this.d2s(cal.getY(y, this.height));
            if (this.getStackSize() > 1) {
                int z = this.isDisplayedHyperStack() ? this.getSlice() - 1 : this.getCurrentSlice() - 1;
                s = s + ", z=" + this.d2s(cal.getZ(z));
            }
            return s;
        }
        String s = " x=" + x + ", y=" + y;
        if (this.getStackSize() > 1) {
            int z = this.isDisplayedHyperStack() ? this.getSlice() - 1 : this.getCurrentSlice() - 1;
            s = s + ", z=" + z;
        }
        return s;
    }

    private String d2s(double n) {
        return n == (double)((int)n) ? Integer.toString((int)n) : IJ.d2s(n);
    }

    private String getValueAsString(int x, int y) {
        if (this.win != null && this.win instanceof PlotWindow) {
            return "";
        }
        Calibration cal = this.getCalibration();
        int[] v = this.getPixel(x, y);
        int type = this.getType();
        switch (type) {
            case 0: 
            case 1: 
            case 3: {
                double cValue;
                if (type == 3) {
                    if (cal.getCValue(v[3]) == (double)v[3]) {
                        return ", index=" + v[3] + ", value=" + v[0] + "," + v[1] + "," + v[2];
                    }
                    v[0] = v[3];
                }
                if ((cValue = cal.getCValue(v[0])) == (double)v[0]) {
                    return ", value=" + v[0];
                }
                return ", value=" + IJ.d2s(cValue) + " (" + v[0] + ")";
            }
            case 2: {
                double value = Float.intBitsToFloat(v[0]);
                String s = (double)((int)value) == value ? IJ.d2s(value, 0) + ".0" : IJ.d2s(value, 4, 7);
                return ", value=" + s;
            }
            case 4: {
                String hex = Colors.colorToString(new Color(v[0], v[1], v[2]));
                return ", value=" + IJ.pad(v[0], 3) + "," + IJ.pad(v[1], 3) + "," + IJ.pad(v[2], 3) + " (" + hex + ")";
            }
        }
        return "";
    }

    public void copy() {
        this.copy(false);
    }

    public void copy(boolean cut) {
        String msg;
        Roi roi = this.getRoi();
        if (roi != null && !roi.isArea()) {
            roi = null;
        }
        if (cut && roi == null && !IJ.isMacro()) {
            IJ.error("Edit>Cut", "This command requires an area selection");
            return;
        }
        boolean batchMode = Interpreter.isBatchMode();
        String string = msg = cut ? "Cut" : "Copy";
        if (!batchMode) {
            IJ.showStatus(msg + "ing...");
        }
        ImageProcessor ip = this.getProcessor();
        ImageProcessor ip2 = ip.crop();
        clipboard = new ImagePlus("Clipboard", ip2);
        if (roi != null) {
            clipboard.setRoi((Roi)roi.clone());
        }
        if (cut) {
            ip.snapshot();
            ip.setColor(Toolbar.getBackgroundColor());
            ip.fill();
            if (roi != null && roi.getType() != 0) {
                this.getMask();
                ip.reset(ip.getMask());
            }
            this.setColor(Toolbar.getForegroundColor());
            Undo.setup(1, this);
            this.updateAndDraw();
        }
        int bytesPerPixel = 1;
        switch (clipboard.getType()) {
            case 1: {
                bytesPerPixel = 2;
                break;
            }
            case 2: 
            case 4: {
                bytesPerPixel = 4;
            }
        }
        if (!batchMode) {
            msg = cut ? "Cut" : "Copy";
            IJ.showStatus(msg + ": " + clipboard.getWidth() * clipboard.getHeight() * bytesPerPixel / 1024 + "k");
        }
    }

    public void paste() {
        if (clipboard == null) {
            return;
        }
        int cType = clipboard.getType();
        int iType = this.getType();
        int w = clipboard.getWidth();
        int h = clipboard.getHeight();
        Roi cRoi = clipboard.getRoi();
        Rectangle r = null;
        Rectangle cr = null;
        Roi roi = this.getRoi();
        if (roi != null) {
            r = roi.getBounds();
        }
        if (cRoi != null) {
            cr = cRoi.getBounds();
        }
        if (cr == null) {
            cr = new Rectangle(0, 0, w, h);
        }
        if (r == null || cr.width != r.width || cr.height != r.height) {
            ImageCanvas ic = null;
            if (this.win != null) {
                ic = this.win.getCanvas();
            }
            Rectangle srcRect = ic != null ? ic.getSrcRect() : new Rectangle(0, 0, this.width, this.height);
            int xCenter = srcRect.x + srcRect.width / 2;
            int yCenter = srcRect.y + srcRect.height / 2;
            if (cRoi != null && cRoi.getType() != 0) {
                cRoi.setImage(this);
                cRoi.setLocation(xCenter - w / 2, yCenter - h / 2);
                this.setRoi(cRoi);
            } else {
                this.setRoi(xCenter - w / 2, yCenter - h / 2, w, h);
            }
            roi = this.getRoi();
        }
        if (IJ.isMacro()) {
            int pasteMode = Roi.getCurrentPasteMode();
            boolean nonRect = roi.getType() != 0;
            ImageProcessor ip = this.getProcessor();
            if (nonRect) {
                ip.snapshot();
            }
            r = roi.getBounds();
            int xoffset = cr.x < 0 ? -cr.x : 0;
            int yoffset = cr.y < 0 ? -cr.y : 0;
            ip.copyBits(clipboard.getProcessor(), r.x + xoffset, r.y + yoffset, pasteMode);
            if (nonRect) {
                ImageProcessor mask = roi.getMask();
                ip.setMask(mask);
                ip.setRoi(roi.getBounds());
                ip.reset(ip.getMask());
            }
            this.updateAndDraw();
        } else if (roi != null) {
            roi.startPaste(clipboard);
            Undo.setup(3, this);
        }
        this.changes = true;
    }

    public static ImagePlus getClipboard() {
        return clipboard;
    }

    public static void resetClipboard() {
        clipboard = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyListeners(int id) {
        Vector vector = listeners;
        synchronized (vector) {
            block8: for (int i = 0; i < listeners.size(); ++i) {
                ImageListener listener = (ImageListener)listeners.elementAt(i);
                switch (id) {
                    case 0: {
                        listener.imageOpened(this);
                        continue block8;
                    }
                    case 1: {
                        listener.imageClosed(this);
                        continue block8;
                    }
                    case 2: {
                        listener.imageUpdated(this);
                    }
                }
            }
        }
    }

    public static void addImageListener(ImageListener listener) {
        listeners.addElement(listener);
    }

    public static void removeImageListener(ImageListener listener) {
        listeners.removeElement(listener);
    }

    public boolean isLocked() {
        return this.locked;
    }

    public void setOpenAsHyperStack(boolean openAsHyperStack) {
        this.openAsHyperStack = openAsHyperStack;
    }

    public boolean getOpenAsHyperStack() {
        return this.openAsHyperStack;
    }

    public boolean isComposite() {
        return this.compositeImage && this.nChannels >= 1 && this.imageType != 4 && this instanceof CompositeImage;
    }

    public int getCompositeMode() {
        if (this.isComposite()) {
            return ((CompositeImage)this).getMode();
        }
        return -1;
    }

    public void setDisplayRange(double min, double max) {
        if (this.ip != null) {
            this.ip.setMinAndMax(min, max);
        }
    }

    public double getDisplayRangeMin() {
        return this.ip.getMin();
    }

    public double getDisplayRangeMax() {
        return this.ip.getMax();
    }

    public void setDisplayRange(double min, double max, int channels) {
        if (this.ip instanceof ColorProcessor) {
            ((ColorProcessor)this.ip).setMinAndMax(min, max, channels);
        } else {
            this.ip.setMinAndMax(min, max);
        }
    }

    public void resetDisplayRange() {
        if (this.imageType == 1 && default16bitDisplayRange >= 8 && default16bitDisplayRange <= 16 && !this.getCalibration().isSigned16Bit()) {
            this.ip.setMinAndMax(0.0, Math.pow(2.0, default16bitDisplayRange) - 1.0);
        } else {
            this.ip.resetMinAndMax();
        }
    }

    public boolean isThreshold() {
        return this.ip != null && this.ip.getMinThreshold() != -808080.0;
    }

    public static void setDefault16bitRange(int bitDepth) {
        if (bitDepth != 8 && bitDepth != 10 && bitDepth != 12 && bitDepth != 14 && bitDepth != 15 && bitDepth != 16) {
            bitDepth = 0;
        }
        default16bitDisplayRange = bitDepth;
    }

    public static int getDefault16bitRange() {
        return default16bitDisplayRange;
    }

    public void updatePosition(int c, int z, int t) {
        this.position[0] = c;
        this.position[1] = z;
        this.position[2] = t;
    }

    public ImagePlus flatten() {
        Overlay overlay2;
        ImageCanvas ic2;
        if (IJ.debugMode) {
            IJ.log("flatten");
        }
        ImagePlus imp2 = this.createImagePlus();
        imp2.setTitle(flattenTitle);
        imp2.flatteningCanvas = ic2 = new ImageCanvas(imp2);
        imp2.setRoi(this.getRoi());
        if (this.getStackSize() > 1) {
            imp2.setStack(this.getStack());
            imp2.setSlice(this.getCurrentSlice());
            if (this.isHyperStack()) {
                imp2.setDimensions(this.getNChannels(), this.getNSlices(), this.getNFrames());
                imp2.setPosition(this.getChannel(), this.getSlice(), this.getFrame());
                imp2.setOpenAsHyperStack(true);
            }
        }
        if ((overlay2 = this.getOverlay()) != null && imp2.getRoi() != null) {
            imp2.deleteRoi();
        }
        ic2.setOverlay(overlay2);
        ImageCanvas ic = this.getCanvas();
        if (ic != null) {
            ic2.setShowAllList(ic.getShowAllList());
        }
        BufferedImage bi = new BufferedImage(this.width, this.height, 2);
        Graphics2D g = (Graphics2D)bi.getGraphics();
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, this.antialiasRendering ? RenderingHints.VALUE_ANTIALIAS_ON : RenderingHints.VALUE_ANTIALIAS_OFF);
        g.drawImage(this.getImage(), 0, 0, null);
        ic2.paint(g);
        imp2.flatteningCanvas = null;
        ImagePlus imp3 = new ImagePlus("Flat_" + this.getTitle(), new ColorProcessor(bi));
        imp3.copyScale(this);
        imp3.setProperty("Info", this.getProperty("Info"));
        return imp3;
    }

    public void flattenStack() {
        boolean showAll;
        Overlay overlay2;
        RoiManager rm;
        if (IJ.debugMode) {
            IJ.log("flattenStack");
        }
        if (this.getStackSize() == 1 || !IJ.isJava16()) {
            throw new UnsupportedOperationException("Image stack and Java 1.6 required");
        }
        boolean composite = this.isComposite();
        if (this.getBitDepth() != 24) {
            new ImageConverter(this).convertToRGB();
        }
        Overlay overlay1 = this.getOverlay();
        Overlay roiManagerOverlay = null;
        boolean roiManagerShowAllMode = !Prefs.showAllSliceOnly;
        ImageCanvas ic = this.getCanvas();
        if (ic != null) {
            roiManagerOverlay = ic.getShowAllList();
        }
        this.setOverlay(null);
        if (roiManagerOverlay != null && (rm = RoiManager.getInstance()) != null) {
            rm.runCommand("show none");
        }
        Overlay overlay = overlay2 = overlay1 != null ? overlay1 : roiManagerOverlay;
        if (composite && overlay2 == null) {
            return;
        }
        if (overlay2 == null || overlay2.size() == 0) {
            throw new UnsupportedOperationException("A non-empty overlay is required");
        }
        ImageStack stack2 = this.getStack();
        boolean bl = showAll = overlay1 != null ? false : roiManagerShowAllMode;
        if (this.isHyperStack()) {
            int Z = this.getNSlices();
            for (int z = 1; z <= Z; ++z) {
                for (int t = 1; t <= this.getNFrames(); ++t) {
                    int s = z + (t - 1) * Z;
                    this.flattenImage(stack2, s, overlay2.duplicate(), showAll, z, t);
                }
            }
        } else {
            for (int s = 1; s <= stack2.getSize(); ++s) {
                this.flattenImage(stack2, s, overlay2.duplicate(), showAll);
            }
        }
        this.setStack(stack2);
    }

    private void flattenImage(ImageStack stack, int slice, Overlay overlay, boolean showAll) {
        ImageProcessor ips = stack.getProcessor(slice);
        ImagePlus imp1 = new ImagePlus("temp", ips);
        int w = imp1.getWidth();
        int h = imp1.getHeight();
        for (int i = 0; i < overlay.size(); ++i) {
            Roi r = overlay.get(i);
            int roiPosition = r.getPosition();
            if (roiPosition == 0 || roiPosition == slice || showAll) continue;
            r.setLocation(w, h);
        }
        imp1.setOverlay(overlay);
        ImagePlus imp2 = imp1.flatten();
        stack.setPixels(imp2.getProcessor().getPixels(), slice);
    }

    private void flattenImage(ImageStack stack, int slice, Overlay overlay, boolean showAll, int z, int t) {
        ImageProcessor ips = stack.getProcessor(slice);
        ImagePlus imp1 = new ImagePlus("temp", ips);
        int w = imp1.getWidth();
        int h = imp1.getHeight();
        for (int i = 0; i < overlay.size(); ++i) {
            Roi r = overlay.get(i);
            int cPos = r.getCPosition();
            int zPos = r.getZPosition();
            int tPos = r.getTPosition();
            if (!(cPos != 1 && cPos != 0 || zPos != z && zPos != 0) && (tPos == t || tPos == 0) || showAll) continue;
            r.setLocation(w, h);
        }
        imp1.setOverlay(overlay);
        ImagePlus imp2 = imp1.flatten();
        stack.setPixels(imp2.getProcessor().getPixels(), slice);
    }

    public void setLut(LUT lut) {
        ImageProcessor ip2 = this.getProcessor();
        if (ip2 != null && lut != null) {
            ip2.setLut(lut);
            this.setProcessor(ip2);
        }
    }

    public void setOverlay(Overlay overlay) {
        ImageCanvas ic = this.getCanvas();
        if (ic != null) {
            ic.setOverlay(overlay);
            overlay = null;
        } else {
            this.overlay = overlay;
        }
        this.setHideOverlay(false);
    }

    public void setOverlay(Shape shape, Color color, BasicStroke stroke) {
        if (shape == null) {
            this.setOverlay(null);
            return;
        }
        ShapeRoi roi = new ShapeRoi(shape);
        roi.setStrokeColor(color);
        roi.setStroke(stroke);
        this.setOverlay(new Overlay(roi));
    }

    public void setOverlay(Roi roi, Color strokeColor, int strokeWidth, Color fillColor) {
        roi.setStrokeColor(strokeColor);
        roi.setStrokeWidth(strokeWidth);
        roi.setFillColor(fillColor);
        this.setOverlay(new Overlay(roi));
    }

    public Overlay getOverlay() {
        ImageCanvas ic = this.getCanvas();
        if (ic != null) {
            return ic.getOverlay();
        }
        return this.overlay;
    }

    public void setHideOverlay(boolean hide) {
        this.hideOverlay = hide;
        ImageCanvas ic = this.getCanvas();
        if (ic != null && ic.getOverlay() != null) {
            ic.repaint();
        }
    }

    public boolean getHideOverlay() {
        return this.hideOverlay;
    }

    public void setAntialiasRendering(boolean antialiasRendering) {
        this.antialiasRendering = antialiasRendering;
    }

    public synchronized Object clone() {
        try {
            ImagePlus copy = (ImagePlus)super.clone();
            copy.win = null;
            return copy;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public String toString() {
        return "img[\"" + this.getTitle() + "\" (" + this.getID() + "), " + this.getBitDepth() + "-bit, " + this.width + "x" + this.height + "x" + this.getNChannels() + "x" + this.getNSlices() + "x" + this.getNFrames() + "]";
    }

    public void setIJMenuBar(boolean b) {
        this.setIJMenuBar = b;
    }

    public boolean setIJMenuBar() {
        return this.setIJMenuBar && Prefs.setIJMenuBar;
    }

    static {
        listeners = new Vector();
    }
}

