/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.grab;

import groovy.grape.GrapeEngine;
import groovy.grape.GrapeIvy;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.codehaus.groovy.reflection.ReflectionUtils;
import org.scijava.Context;
import org.scijava.grab.GrabService;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.scijava.service.AbstractService;
import org.scijava.service.Service;

@Plugin(type=Service.class)
public class DefaultGrabService
extends AbstractService
implements GrabService {
    public static final String AUTO_DOWNLOAD_SETTING = "autoDownload";
    public static final String DISABLE_CHECKSUMS_SETTING = "disableChecksums";
    public static final String SYSTEM_PROPERTIES_SETTING = "systemProperties";
    @Parameter
    private Context context;
    private boolean grabEnabled = Boolean.valueOf(System.getProperty("scijava.grab.enable", "true"));
    private boolean autoDownload = Boolean.valueOf(System.getProperty("scijava.grab.autoDownload", "true"));
    private boolean disableChecksums = Boolean.valueOf(System.getProperty("scijava.grab.disableChecksums", "false"));
    private GrapeEngine grapeEngine;

    @Override
    public boolean isGrabEnabled() {
        return this.grabEnabled;
    }

    @Override
    public void setGrabEnabled(boolean enableGrab) {
        this.grabEnabled = enableGrab;
    }

    @Override
    public boolean getEnableAutoDownload() {
        return this.autoDownload;
    }

    @Override
    public void setEnableAutoDownload(boolean enableAutoDownload) {
        this.autoDownload = enableAutoDownload;
    }

    @Override
    public boolean getDisableChecksums() {
        return this.disableChecksums;
    }

    @Override
    public void setDisableChecksums(boolean disableChecksums) {
        this.disableChecksums = disableChecksums;
    }

    @Override
    public void grab(String endorsed) {
        GrapeEngine instance;
        if (this.grabEnabled && (instance = this.grapeEngine()) != null) {
            instance.grab(endorsed);
        }
    }

    @Override
    public void grab(Map<String, Object> dependency) {
        GrapeEngine instance;
        if (this.grabEnabled && (instance = this.grapeEngine()) != null) {
            if (!dependency.containsKey(AUTO_DOWNLOAD_SETTING)) {
                dependency.put(AUTO_DOWNLOAD_SETTING, this.autoDownload);
            }
            if (!dependency.containsKey(DISABLE_CHECKSUMS_SETTING)) {
                dependency.put(DISABLE_CHECKSUMS_SETTING, this.disableChecksums);
            }
            if (!dependency.containsKey("classLoader")) {
                dependency.put("classLoader", this.context().getClass().getClassLoader());
            }
            instance.grab(dependency);
        }
    }

    @Override
    public void grab(Map<String, Object> args, Map ... dependencies) {
        GrapeEngine instance;
        if (this.grabEnabled && (instance = this.grapeEngine()) != null) {
            if (!args.containsKey(AUTO_DOWNLOAD_SETTING)) {
                args.put(AUTO_DOWNLOAD_SETTING, this.autoDownload);
            }
            if (!args.containsKey(DISABLE_CHECKSUMS_SETTING)) {
                args.put(DISABLE_CHECKSUMS_SETTING, this.disableChecksums);
            }
            if (!args.containsKey("classLoader")) {
                args.put("classLoader", this.context().getClass().getClassLoader());
            }
            instance.grab(args, dependencies);
        }
    }

    @Override
    public Map<String, Map<String, List<String>>> dependencies() {
        GrapeEngine instance;
        Map grapes = null;
        if (this.grabEnabled && (instance = this.grapeEngine()) != null) {
            grapes = instance.enumerateGrapes();
        }
        return grapes == null ? Collections.emptyMap() : grapes;
    }

    @Override
    public URI[] resolve(Map<String, Object> args, Map ... dependencies) {
        return this.resolve(args, (List)null, dependencies);
    }

    @Override
    public URI[] resolve(Map<String, Object> args, List depsInfo, Map ... dependencies) {
        GrapeEngine instance;
        URI[] uris = null;
        if (this.grabEnabled && (instance = this.grapeEngine()) != null) {
            if (!args.containsKey(AUTO_DOWNLOAD_SETTING)) {
                args.put(AUTO_DOWNLOAD_SETTING, this.autoDownload);
            }
            if (!args.containsKey(DISABLE_CHECKSUMS_SETTING)) {
                args.put(DISABLE_CHECKSUMS_SETTING, this.disableChecksums);
            }
            uris = instance.resolve(args, depsInfo, dependencies);
        }
        return uris == null ? new URI[]{} : uris;
    }

    @Override
    public Map[] listDependencies(ClassLoader cl) {
        GrapeEngine instance;
        Map[] maps = null;
        if (this.grabEnabled && (instance = this.grapeEngine()) != null) {
            maps = instance.listDependencies(cl);
        }
        return maps == null ? new Map[]{} : maps;
    }

    @Override
    public void addResolver(Map<String, Object> args) {
        GrapeEngine instance;
        if (this.grabEnabled && (instance = this.grapeEngine()) != null) {
            instance.addResolver(args);
        }
    }

    private GrapeEngine grapeEngine() {
        if (this.grapeEngine == null) {
            System.setProperty("groovy.grape.report.downloads", "true");
            System.setProperty("grape.root", Paths.get(System.getProperty("user.home"), ".scijava").toString());
            this.grapeEngine = new GrapeSciJava();
        }
        return this.grapeEngine;
    }

    private static class GrapeSciJava
    extends GrapeIvy {
        private Map<String, List<String>> exclusiveGrabArgs = new HashMap<String, List<String>>(){
            {
                this.put("group", Arrays.asList("groupId", "organisation", "organization", "org"));
                this.put("groupId", Arrays.asList("group", "organisation", "organization", "org"));
                this.put("organisation", Arrays.asList("group", "groupId", "organization", "org"));
                this.put("organization", Arrays.asList("group", "groupId", "organisation", "org"));
                this.put("org", Arrays.asList("group", "groupId", "organisation", "organization"));
                this.put("module", Arrays.asList("artifactId", "artifact"));
                this.put("artifactId", Arrays.asList("module", "artifact"));
                this.put("artifact", Arrays.asList("module", "artifactId"));
                this.put("version", Arrays.asList("revision", "rev"));
                this.put("revision", Arrays.asList("version", "rev"));
                this.put("rev", Arrays.asList("version", "revision"));
                this.put("conf", Arrays.asList("scope", "configuration"));
                this.put("scope", Arrays.asList("conf", "configuration"));
                this.put("configuration", Arrays.asList("conf", "scope"));
            }
        };

        private GrapeSciJava() {
        }

        public ClassLoader chooseClassLoader(Map args) {
            ClassLoader loader = (ClassLoader)args.get("classLoader");
            if (this.isValidTargetClassLoader(loader)) {
                if (args.get("refObject") == null) {
                    loader = !args.containsKey("calleeDepth") ? ReflectionUtils.getCallingClass((int)((Integer)args.get("calleeDepth"))).getClassLoader() : ReflectionUtils.getCallingClass((int)1).getClassLoader();
                }
                while (loader != null && !this.isValidTargetClassLoader(loader)) {
                    loader = loader.getParent();
                }
                if (!this.isValidTargetClassLoader(loader)) {
                    throw new RuntimeException("No suitable ClassLoader found for grab");
                }
            }
            return loader;
        }

        public File getLocalGrapeConfig() {
            InputStream configStream = GrapeSciJava.class.getResourceAsStream("grapeConfig.xml");
            File configTempFile = new File("");
            try {
                configTempFile = File.createTempFile("grapeConfig", ".xml");
                try {
                    Files.copy(configStream, configTempFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
                }
                catch (IOException ex) {
                    Logger.getLogger(GrapeSciJava.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            catch (IOException ex) {
                Logger.getLogger(GrapeSciJava.class.getName()).log(Level.SEVERE, null, ex);
            }
            return configTempFile;
        }

        private boolean isValidTargetClassLoader(ClassLoader loader) {
            return loader == null ? false : loader.getClass() == ClassLoader.class;
        }
    }
}

