/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.ops.transform.scaleView;

import net.imagej.ops.Contingent;
import net.imagej.ops.Ops;
import net.imagej.ops.special.function.AbstractUnaryFunctionOp;
import net.imagej.ops.special.function.Functions;
import net.imagej.ops.special.function.UnaryFunctionOp;
import net.imglib2.Dimensions;
import net.imglib2.FinalInterval;
import net.imglib2.RandomAccessible;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.RealRandomAccessible;
import net.imglib2.interpolation.InterpolatorFactory;
import net.imglib2.outofbounds.OutOfBoundsFactory;
import net.imglib2.outofbounds.OutOfBoundsMirrorFactory;
import net.imglib2.realtransform.AffineGet;
import net.imglib2.realtransform.AffineRealRandomAccessible;
import net.imglib2.realtransform.RealViews;
import net.imglib2.realtransform.Scale;
import net.imglib2.util.Intervals;
import net.imglib2.view.ExtendedRandomAccessibleInterval;
import net.imglib2.view.IntervalView;
import net.imglib2.view.RandomAccessibleOnRealRandomAccessible;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;

@Plugin(type=Ops.Transform.ScaleView.class, priority=100.0)
public class DefaultScaleView<T>
extends AbstractUnaryFunctionOp<RandomAccessibleInterval<T>, RandomAccessibleInterval<T>>
implements Ops.Transform.ScaleView,
Contingent {
    @Parameter
    private double[] scaleFactors;
    @Parameter
    private InterpolatorFactory<T, RandomAccessible<T>> interpolator;
    @Parameter(required=false)
    private OutOfBoundsFactory<T, RandomAccessibleInterval<T>> outOfBoundsFactory = new OutOfBoundsMirrorFactory(OutOfBoundsMirrorFactory.Boundary.SINGLE);
    private UnaryFunctionOp<RandomAccessible<T>, RealRandomAccessible<T>> interpolateOp;
    private UnaryFunctionOp<RealRandomAccessible<T>, RandomAccessibleOnRealRandomAccessible<T>> rasterOp;
    private UnaryFunctionOp<RandomAccessible<T>, IntervalView<T>> intervalOp;
    private UnaryFunctionOp<RandomAccessibleInterval<T>, ExtendedRandomAccessibleInterval<T, RandomAccessibleInterval<T>>> extendOp;

    @Override
    public void initialize() {
        this.interpolateOp = Functions.unary(this.ops(), Ops.Transform.InterpolateView.class, RealRandomAccessible.class, RandomAccessible.class, new Object[]{this.interpolator});
        this.rasterOp = Functions.unary(this.ops(), Ops.Transform.RasterView.class, RandomAccessibleOnRealRandomAccessible.class, RealRandomAccessible.class, new Object[0]);
        this.extendOp = Functions.unary(this.ops(), Ops.Transform.ExtendView.class, ExtendedRandomAccessibleInterval.class, RandomAccessibleInterval.class, new Object[]{this.outOfBoundsFactory});
        long[] newDims = Intervals.dimensionsAsLongArray((Dimensions)((Dimensions)this.in()));
        for (int i = 0; i < Math.min(this.scaleFactors.length, ((RandomAccessibleInterval)this.in()).numDimensions()); ++i) {
            newDims[i] = Math.round((double)((RandomAccessibleInterval)this.in()).dimension(i) * this.scaleFactors[i]);
        }
        this.intervalOp = Functions.unary(this.ops(), Ops.Transform.IntervalView.class, IntervalView.class, RandomAccessible.class, new Object[]{new FinalInterval(newDims)});
    }

    @Override
    public RandomAccessibleInterval<T> calculate(RandomAccessibleInterval<T> input) {
        RealRandomAccessible<T> interpolated = this.interpolateOp.calculate((RandomAccessible<T>)this.extendOp.calculate(input));
        AffineRealRandomAccessible transformed = RealViews.affineReal(interpolated, (AffineGet)new Scale(this.scaleFactors));
        RandomAccessibleOnRealRandomAccessible<T> rasterized = this.rasterOp.calculate((RealRandomAccessible<T>)transformed);
        return (RandomAccessibleInterval)this.intervalOp.calculate((RandomAccessible<T>)rasterized);
    }

    @Override
    public boolean conforms() {
        return ((RandomAccessibleInterval)this.in()).numDimensions() == this.scaleFactors.length;
    }
}

