/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.ops.map;

import net.imagej.ops.Contingent;
import net.imagej.ops.Ops;
import net.imagej.ops.Parallel;
import net.imagej.ops.map.AbstractMapComputer;
import net.imagej.ops.map.Maps;
import net.imagej.ops.thread.chunker.ChunkerOp;
import net.imagej.ops.thread.chunker.CursorBasedChunk;
import net.imglib2.IterableInterval;
import net.imglib2.RandomAccessibleInterval;
import org.scijava.plugin.Plugin;

public class MapUnaryComputers {
    private MapUnaryComputers() {
    }

    @Plugin(type=Ops.Map.class, priority=11.0)
    public static class RAIToIIParallel<EI, EO>
    extends AbstractMapComputer<EI, EO, RandomAccessibleInterval<EI>, IterableInterval<EO>>
    implements Contingent,
    Parallel {
        @Override
        public boolean conforms() {
            return this.out() == null || Maps.compatible((RandomAccessibleInterval)this.in(), (IterableInterval)this.out());
        }

        @Override
        public void compute(final RandomAccessibleInterval<EI> input, final IterableInterval<EO> output) {
            this.ops().run(ChunkerOp.class, new CursorBasedChunk(){

                @Override
                public void execute(int startIndex, int stepSize, int numSteps) {
                    Maps.map(input, output, this.getOp().getIndependentInstance(), startIndex, stepSize, numSteps);
                }
            }, output.size());
        }
    }

    @Plugin(type=Ops.Map.class, priority=1.0)
    public static class RAIToII<EI, EO>
    extends AbstractMapComputer<EI, EO, RandomAccessibleInterval<EI>, IterableInterval<EO>>
    implements Contingent {
        @Override
        public boolean conforms() {
            return this.out() == null || Maps.compatible((RandomAccessibleInterval)this.in(), (IterableInterval)this.out());
        }

        @Override
        public void compute(RandomAccessibleInterval<EI> input, IterableInterval<EO> output) {
            Maps.map(input, output, this.getOp());
        }
    }

    @Plugin(type=Ops.Map.class, priority=12.0)
    public static class IIToRAIParallel<EI, EO>
    extends AbstractMapComputer<EI, EO, IterableInterval<EI>, RandomAccessibleInterval<EO>>
    implements Contingent,
    Parallel {
        @Override
        public boolean conforms() {
            return this.out() == null || Maps.compatible((IterableInterval)this.in(), (RandomAccessibleInterval)this.out());
        }

        @Override
        public void compute(final IterableInterval<EI> input, final RandomAccessibleInterval<EO> output) {
            this.ops().run(ChunkerOp.class, new CursorBasedChunk(){

                @Override
                public void execute(int startIndex, int stepSize, int numSteps) {
                    Maps.map(input, output, this.getOp().getIndependentInstance(), startIndex, stepSize, numSteps);
                }
            }, input.size());
        }
    }

    @Plugin(type=Ops.Map.class, priority=2.0)
    public static class IIToRAI<EI, EO>
    extends AbstractMapComputer<EI, EO, IterableInterval<EI>, RandomAccessibleInterval<EO>>
    implements Contingent {
        @Override
        public boolean conforms() {
            return this.out() == null || Maps.compatible((IterableInterval)this.in(), (RandomAccessibleInterval)this.out());
        }

        @Override
        public void compute(IterableInterval<EI> input, RandomAccessibleInterval<EO> output) {
            Maps.map(input, output, this.getOp());
        }
    }

    @Plugin(type=Ops.Map.class, priority=13.0)
    public static class IIToIIParallel<EI, EO>
    extends AbstractMapComputer<EI, EO, IterableInterval<EI>, IterableInterval<EO>>
    implements Contingent,
    Parallel {
        @Override
        public boolean conforms() {
            return this.out() == null || Maps.compatible((IterableInterval)this.in(), (IterableInterval)this.out());
        }

        @Override
        public void compute(final IterableInterval<EI> input, final IterableInterval<EO> output) {
            this.ops().run(ChunkerOp.class, new CursorBasedChunk(){

                @Override
                public void execute(int startIndex, int stepSize, int numSteps) {
                    Maps.map(input, output, this.getOp().getIndependentInstance(), startIndex, stepSize, numSteps);
                }
            }, input.size());
        }
    }

    @Plugin(type=Ops.Map.class, priority=3.0)
    public static class IIToII<EI, EO>
    extends AbstractMapComputer<EI, EO, IterableInterval<EI>, IterableInterval<EO>>
    implements Contingent {
        @Override
        public boolean conforms() {
            return this.out() == null || Maps.compatible((IterableInterval)this.in(), (IterableInterval)this.out());
        }

        @Override
        public void compute(IterableInterval<EI> input, IterableInterval<EO> output) {
            Maps.map(input, output, this.getOp());
        }
    }
}

