/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.ops.imagemoments.centralmoments;

import net.imagej.ops.Ops;
import net.imagej.ops.imagemoments.AbstractImageMomentOp;
import net.imagej.ops.special.chain.RTs;
import net.imagej.ops.special.function.UnaryFunctionOp;
import net.imglib2.Cursor;
import net.imglib2.IterableInterval;
import net.imglib2.type.numeric.RealType;
import org.scijava.plugin.Plugin;

@Plugin(type=Ops.ImageMoments.CentralMoment30.class, label="Image Moment: CentralMoment30")
public class DefaultCentralMoment30<I extends RealType<I>, O extends RealType<O>>
extends AbstractImageMomentOp<I, O>
implements Ops.ImageMoments.CentralMoment30 {
    private UnaryFunctionOp<IterableInterval<I>, O> moment00Func;
    private UnaryFunctionOp<IterableInterval<I>, O> moment10Func;

    @Override
    public void initialize() {
        this.moment00Func = RTs.function(this.ops(), Ops.ImageMoments.Moment00.class, this.in(), new Object[0]);
        this.moment10Func = RTs.function(this.ops(), Ops.ImageMoments.Moment10.class, this.in(), new Object[0]);
    }

    @Override
    public void compute(IterableInterval<I> input, O output) {
        double moment00 = ((RealType)this.moment00Func.calculate(input)).getRealDouble();
        double moment10 = ((RealType)this.moment10Func.calculate(input)).getRealDouble();
        double centerX = moment10 / moment00;
        double centralmoment30 = 0.0;
        Cursor it = input.localizingCursor();
        while (it.hasNext()) {
            it.fwd();
            double x = it.getDoublePosition(0) - centerX;
            double val = ((RealType)it.get()).getRealDouble();
            centralmoment30 += val * x * x * x;
        }
        output.setReal(centralmoment30);
    }
}

