/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.ops.geom.geom3d;

import net.imagej.ops.Ops;
import net.imagej.ops.geom.geom3d.mesh.Mesh;
import net.imagej.ops.special.function.Functions;
import net.imagej.ops.special.function.UnaryFunctionOp;
import net.imagej.ops.special.hybrid.AbstractUnaryHybridCF;
import net.imglib2.type.numeric.real.DoubleType;
import org.scijava.plugin.Plugin;

@Plugin(type=Ops.Geometric.Sphericity.class, label="Geometric (3D): Sphericity", priority=10000.0)
public class DefaultSphericity
extends AbstractUnaryHybridCF<Mesh, DoubleType>
implements Ops.Geometric.Sphericity {
    private UnaryFunctionOp<Mesh, DoubleType> volumeFunc;
    private UnaryFunctionOp<Mesh, DoubleType> areaFunc;

    @Override
    public void initialize() {
        this.volumeFunc = Functions.unary(this.ops(), Ops.Geometric.Size.class, DoubleType.class, this.in(), new Object[0]);
        this.areaFunc = Functions.unary(this.ops(), Ops.Geometric.BoundarySize.class, DoubleType.class, this.in(), new Object[0]);
    }

    @Override
    public void compute(Mesh input, DoubleType output) {
        double sphereArea = Math.pow(Math.PI, 0.3333333333333333) * Math.pow(6.0 * this.volumeFunc.calculate(input).get(), 0.6666666666666666);
        output.set(sphereArea / this.areaFunc.calculate(input).get());
    }

    @Override
    public DoubleType createOutput(Mesh input) {
        return new DoubleType();
    }
}

