/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.ops.geom.geom2d;

import net.imagej.ops.Ops;
import net.imagej.ops.special.hybrid.AbstractUnaryHybridCF;
import net.imglib2.RealLocalizable;
import net.imglib2.roi.geometric.Polygon;
import net.imglib2.type.numeric.real.DoubleType;
import org.scijava.plugin.Plugin;

@Plugin(type=Ops.Geometric.Size.class, label="Geometric (2D): Size", priority=9999.0)
public class DefaultSizePolygon
extends AbstractUnaryHybridCF<Polygon, DoubleType>
implements Ops.Geometric.Size {
    @Override
    public void compute(Polygon input, DoubleType output) {
        double sum = 0.0;
        int numVertices = input.getVertices().size();
        for (int i = 0; i < numVertices; ++i) {
            RealLocalizable p0 = (RealLocalizable)input.getVertices().get(i);
            RealLocalizable p1 = (RealLocalizable)input.getVertices().get((i + 1) % numVertices);
            double p0_x = p0.getDoublePosition(0);
            double p0_y = p0.getDoublePosition(1);
            double p1_x = p1.getDoublePosition(0);
            double p1_y = p1.getDoublePosition(1);
            sum += p0_x * p1_y - p0_y * p1_x;
        }
        output.set(Math.abs(sum) / 2.0);
    }

    @Override
    public DoubleType createOutput(Polygon input) {
        return new DoubleType();
    }
}

