/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.ops.filter.gauss;

import java.util.concurrent.ExecutorService;
import net.imagej.ops.Ops;
import net.imagej.ops.special.hybrid.AbstractUnaryHybridCF;
import net.imglib2.RandomAccessible;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.algorithm.gauss3.Gauss3;
import net.imglib2.algorithm.gauss3.SeparableSymmetricConvolution;
import net.imglib2.exception.IncompatibleTypeException;
import net.imglib2.outofbounds.OutOfBoundsFactory;
import net.imglib2.outofbounds.OutOfBoundsMirrorFactory;
import net.imglib2.type.NativeType;
import net.imglib2.type.numeric.RealType;
import net.imglib2.view.ExtendedRandomAccessibleInterval;
import net.imglib2.view.Views;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.scijava.thread.ThreadService;

@Plugin(type=Ops.Filter.Gauss.class, priority=1.0)
public class DefaultGaussRAI<T extends RealType<T> & NativeType<T>>
extends AbstractUnaryHybridCF<RandomAccessibleInterval<T>, RandomAccessibleInterval<T>>
implements Ops.Filter.Gauss {
    @Parameter
    private ThreadService threads;
    @Parameter
    private double[] sigmas;
    @Parameter(required=false)
    private OutOfBoundsFactory<T, RandomAccessibleInterval<T>> outOfBounds;

    @Override
    public void compute(RandomAccessibleInterval<T> input, RandomAccessibleInterval<T> output) {
        if (this.outOfBounds == null) {
            this.outOfBounds = new OutOfBoundsMirrorFactory(OutOfBoundsMirrorFactory.Boundary.SINGLE);
        }
        ExtendedRandomAccessibleInterval eIn = Views.extend(input, this.outOfBounds);
        try {
            SeparableSymmetricConvolution.convolve((double[][])Gauss3.halfkernels((double[])this.sigmas), (RandomAccessible)eIn, output, (ExecutorService)this.threads.getExecutorService());
        }
        catch (IncompatibleTypeException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public RandomAccessibleInterval<T> createOutput(RandomAccessibleInterval<T> input) {
        return this.ops().create().img(input);
    }
}

